/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.util;

import java.awt.Point;
import java.util.Random;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.util.Polyomino;
import org.ivis.layout.util.PolyominoPacking;

public class RectProc {
    static final double AspectRatio = 1.0;

    static void PlaceRandomly(int rN, double[] rX1, double[] rY1, double[] rL, double[] rH) {
        int[] index = new int[rN];
        double sumL = 0.0;
        double sumH = 0.0;
        for (int i = 0; i < rN; ++i) {
            sumL += rL[i];
            sumH += rH[i];
            index[i] = i;
        }
        Random Rgen = new Random(1L);
        for (int i = 0; i < rN; ++i) {
            int a = Rgen.nextInt(rN);
            int tmp = index[i];
            index[i] = index[a];
            index[a] = tmp;
        }
        sumL /= (double)rN;
        sumH /= (double)rN;
        int numRows = (int)(Math.sqrt(rN) + 0.4999);
        for (int i = 0; i < rN; ++i) {
            rX1[index[i]] = (double)(i / numRows) * sumL;
            rY1[index[i]] = (double)(i % numRows) * sumH;
        }
    }

    public static void packRectanglesMino(double buffer, int rN, SbgnPDNode[] rectangles) {
        int i;
        double[] rX1 = new double[rN];
        double[] rY1 = new double[rN];
        double[] rW = new double[rN];
        double[] rH = new double[rN];
        for (i = 0; i < rN; ++i) {
            rX1[i] = rectangles[i].getCenterX();
            rY1[i] = rectangles[i].getCenterY();
            rW[i] = rectangles[i].getWidth();
            rH[i] = rectangles[i].getHeight();
        }
        for (i = 0; i < rN; ++i) {
            int n = i;
            rX1[n] = rX1[n] - rW[i] / 2.0;
            int n2 = i;
            rY1[n2] = rY1[n2] - rH[i] / 2.0;
        }
        RectProc.packRectanglesMino(buffer, rN, rX1, rW, rY1, rH, rectangles);
        for (i = 0; i < rN; ++i) {
            int n = i;
            rX1[n] = rX1[n] + rW[i] / 2.0;
            int n4 = i;
            rY1[n4] = rY1[n4] + rH[i] / 2.0;
        }
        for (i = 0; i < rN; ++i) {
            rectangles[i].setCenter(rX1[i], rY1[i]);
        }
    }

    static void packRectanglesMino(double buffer, int rN, double[] rX, double[] rW, double[] rY, double[] rH, SbgnPDNode[] rectangles) {
        if (rN == 0) {
            return;
        }
        double stepX = 5.0;
        double stepY = 5.0;
        double fstep = 1.0;
        stepY = stepX * 1.0 * fstep;
        stepX *= fstep;
        Polyomino[] minos = new Polyomino[rN];
        for (int i = 0; i < rN; ++i) {
            int W = (int)Math.ceil((rW[i] + buffer) / stepX);
            int H = (int)Math.ceil((rH[i] + buffer) / stepY);
            minos[i] = new Polyomino();
            minos[i].coord = new Point[W * H];
            int cnt = 0;
            for (int y = 0; y < H; ++y) {
                int x = 0;
                while (x < W) {
                    minos[i].coord[cnt] = new Point();
                    minos[i].coord[cnt].x = x++;
                    minos[i].coord[cnt++].y = y;
                }
            }
            minos[i].l = cnt;
            minos[i].label = rectangles[i].label;
        }
        PolyominoPacking packer = new PolyominoPacking();
        packer.pack(minos, rN);
        for (int i = 0; i < rN; ++i) {
            rX[i] = (double)minos[i].x * stepX;
            rY[i] = (double)minos[i].y * stepY;
        }
    }
}

