/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.XrefImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.SetStringBridge;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@Proxy(proxyClass=PublicationXref.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PublicationXrefImpl
extends XrefImpl
implements PublicationXref {
    private String title;
    private Set<String> url;
    private Set<String> source;
    private Set<String> author;
    private int year = UNKNOWN_INT;

    public PublicationXrefImpl() {
        this.url = BPCollections.I.createSet();
        this.source = BPCollections.I.createSet();
        this.author = BPCollections.I.createSet();
    }

    @Transient
    public Class<? extends PublicationXref> getModelInterface() {
        return PublicationXref.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="author")
    @Field(name="keyword", store=Store.YES, analyze=Analyze.YES)
    @Boost(value=1.1f)
    @FieldBridge(impl=SetStringBridge.class)
    public Set<String> getAuthor() {
        return this.author;
    }

    public void setAuthor(Set<String> author) {
        this.author = author;
    }

    @Override
    public void addAuthor(String author) {
        if (author != null && author.length() > 0) {
            this.author.add(author);
        }
    }

    @Override
    public void removeAuthor(String author) {
        if (author != null) {
            this.author.remove(author);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="source")
    @Field(name="keyword", store=Store.YES, analyze=Analyze.YES)
    @Boost(value=1.1f)
    @FieldBridge(impl=SetStringBridge.class)
    public Set<String> getSource() {
        return this.source;
    }

    public void setSource(Set<String> source) {
        this.source = source;
    }

    @Override
    public void addSource(String source) {
        if (source != null && source.length() > 0) {
            this.source.add(source);
        }
    }

    @Override
    public void removeSource(String source) {
        if (source != null) {
            this.source.remove(source);
        }
    }

    @Override
    @Field(name="keyword", store=Store.YES, analyze=Analyze.YES)
    @Boost(value=1.1f)
    @Column(columnDefinition="LONGTEXT")
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection
    @JoinTable(name="url")
    @Field(name="keyword", store=Store.YES, analyze=Analyze.YES)
    @Boost(value=1.1f)
    @FieldBridge(impl=SetStringBridge.class)
    public Set<String> getUrl() {
        return this.url;
    }

    public void setUrl(Set<String> url) {
        this.url = url;
    }

    @Override
    public void addUrl(String url) {
        if (url != null && url.length() > 0) {
            this.url.add(url);
        }
    }

    @Override
    public void removeUrl(String url) {
        if (url != null) {
            this.url.remove(url);
        }
    }

    @Override
    @Column(name="published")
    @Field(name="keyword", store=Store.YES, analyze=Analyze.YES)
    @Boost(value=1.1f)
    public int getYear() {
        return this.year;
    }

    @Override
    public void setYear(int year) {
        this.year = year;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement other) {
        if (!(other instanceof PublicationXref)) {
            return false;
        }
        PublicationXref that = (PublicationXref)other;
        boolean eqv = this.year == that.getYear() && (this.title != null ? this.title.equals(that.getTitle()) : that.getTitle() == null) && this.author.containsAll(that.getAuthor()) && this.source.containsAll(that.getSource()) && this.url.containsAll(that.getUrl());
        return eqv && super.semanticallyEquivalent(other);
    }
}

