/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.ChemicalConstantImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.DeltaG;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=DeltaG.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class DeltaGImpl
extends ChemicalConstantImpl
implements DeltaG {
    private float deltaGPrime0 = UNKNOWN_FLOAT.floatValue();

    @Transient
    public Class<? extends DeltaG> getModelInterface() {
        return DeltaG.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        return super.semanticallyEquivalent(element) && Float.compare(((DeltaG)element).getDeltaGPrime0(), this.deltaGPrime0) == 0;
    }

    @Override
    public int equivalenceCode() {
        return (float)(super.equivalenceCode() + 29) + this.deltaGPrime0 != 0.0f ? Float.floatToIntBits(this.deltaGPrime0) : 0;
    }

    @Override
    public float getDeltaGPrime0() {
        return this.deltaGPrime0;
    }

    @Override
    public void setDeltaGPrime0(float deltaGPrime0) {
        this.deltaGPrime0 = deltaGPrime0;
    }
}

