/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.ControlImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Catalysis.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class CatalysisImpl
extends ControlImpl
implements Catalysis {
    private CatalysisDirectionType catalysisDirection;
    private Set<PhysicalEntity> cofactor = BPCollections.I.createSafeSet();

    @Transient
    public Class<? extends Catalysis> getModelInterface() {
        return Catalysis.class;
    }

    @Override
    @Enumerated
    public CatalysisDirectionType getCatalysisDirection() {
        return this.catalysisDirection;
    }

    @Override
    public void setCatalysisDirection(CatalysisDirectionType catalysisDirection) {
        this.catalysisDirection = catalysisDirection;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="cofactor")
    public Set<PhysicalEntity> getCofactor() {
        return this.cofactor;
    }

    protected void setCofactor(Set<PhysicalEntity> cofactor) {
        this.cofactor = cofactor;
    }

    @Override
    public void addCofactor(PhysicalEntity cofactor) {
        if (cofactor != null) {
            this.cofactor.add(cofactor);
            super.addParticipant(cofactor);
        }
    }

    @Override
    public void removeCofactor(PhysicalEntity cofactor) {
        if (cofactor != null) {
            super.removeParticipant(cofactor);
            this.cofactor.remove(cofactor);
        }
    }

    @Override
    public void addController(Controller controller) {
        if (!(controller instanceof PhysicalEntity)) {
            throw new IllegalBioPAXArgumentException("Catalysis can only be controlled with a Physical Entity");
        }
        super.addController(controller);
    }

    @Override
    protected boolean checkControlled(Process controlled) {
        return controlled instanceof Conversion;
    }
}

