/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.UnificationXref;

public final class SimpleIOExample {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Please run again providing one argument, a BioPAX OWL file path/name.");
            System.exit(-1);
        }
        SimpleIOHandler biopaxIO = new SimpleIOHandler();
        Model model = biopaxIO.convertFromOWL(new FileInputStream(args[0]));
        SimpleIOExample.output(model);
        BioPAXFactory bioPAXFactory = BioPAXLevel.L3.getDefaultFactory();
        Model model2 = bioPAXFactory.createModel();
        model2.setXmlBase("http://baderlab.org#");
        UnificationXref uxref = model2.addNew(UnificationXref.class, "http://baderlab.org#xref_P62158");
        uxref.setDb("uniprotkb");
        uxref.setId("P62158");
        ProteinReference prf = model2.addNew(ProteinReference.class, "urn:miriam:uniprot:P62158");
        prf.setDisplayName("CALM_HUMAN");
        prf.addXref(uxref);
        SimpleIOExample.output(model2);
    }

    public static void output(Model model) throws IOException {
        SimpleIOHandler simpleExporter = new SimpleIOHandler();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        simpleExporter.convertToOWL(model, out);
        System.out.println(out + "\n");
    }
}

