/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity entity2) {
        try {
            EntityUtils.consume(entity2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity entity2) throws IOException {
        InputStream instream;
        if (entity2 == null) {
            return;
        }
        if (entity2.isStreaming() && (instream = entity2.getContent()) != null) {
            instream.close();
        }
    }

    public static void updateEntity(HttpResponse response, HttpEntity entity2) throws IOException {
        Args.notNull(response, "Response");
        EntityUtils.consume(response.getEntity());
        response.setEntity(entity2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity entity2) throws IOException {
        Args.notNull(entity2, "Entity");
        InputStream instream = entity2.getContent();
        if (instream == null) {
            return null;
        }
        try {
            int l;
            Args.check(entity2.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
            int i = (int)entity2.getContentLength();
            if (i < 0) {
                i = 4096;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(i);
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            instream.close();
        }
    }

    @Deprecated
    public static String getContentCharSet(HttpEntity entity2) throws ParseException {
        NameValuePair param;
        HeaderElement[] values;
        Args.notNull(entity2, "Entity");
        String charset = null;
        if (entity2.getContentType() != null && (values = entity2.getContentType().getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        return charset;
    }

    @Deprecated
    public static String getContentMimeType(HttpEntity entity2) throws ParseException {
        HeaderElement[] values;
        Args.notNull(entity2, "Entity");
        String mimeType = null;
        if (entity2.getContentType() != null && (values = entity2.getContentType().getElements()).length > 0) {
            mimeType = values[0].getName();
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpEntity entity2, Charset defaultCharset) throws IOException, ParseException {
        Args.notNull(entity2, "Entity");
        InputStream instream = entity2.getContent();
        if (instream == null) {
            return null;
        }
        try {
            int l;
            Args.check(entity2.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
            int i = (int)entity2.getContentLength();
            if (i < 0) {
                i = 4096;
            }
            Charset charset = null;
            try {
                ContentType contentType = ContentType.get(entity2);
                if (contentType != null) {
                    charset = contentType.getCharset();
                }
            }
            catch (UnsupportedCharsetException ex) {
                throw new UnsupportedEncodingException(ex.getMessage());
            }
            if (charset == null) {
                charset = defaultCharset;
            }
            if (charset == null) {
                charset = HTTP.DEF_CONTENT_CHARSET;
            }
            InputStreamReader reader = new InputStreamReader(instream, charset);
            CharArrayBuffer buffer = new CharArrayBuffer(i);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            instream.close();
        }
    }

    public static String toString(HttpEntity entity2, String defaultCharset) throws IOException, ParseException {
        return EntityUtils.toString(entity2, defaultCharset != null ? Charset.forName(defaultCharset) : null);
    }

    public static String toString(HttpEntity entity2) throws IOException, ParseException {
        return EntityUtils.toString(entity2, (Charset)null);
    }
}

