/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.SortedBag;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.bag.HashBag;
import org.apache.commons.collections15.bag.PredicatedBag;
import org.apache.commons.collections15.bag.PredicatedSortedBag;
import org.apache.commons.collections15.bag.SynchronizedBag;
import org.apache.commons.collections15.bag.SynchronizedSortedBag;
import org.apache.commons.collections15.bag.TransformedBag;
import org.apache.commons.collections15.bag.TransformedSortedBag;
import org.apache.commons.collections15.bag.TreeBag;
import org.apache.commons.collections15.bag.TypedBag;
import org.apache.commons.collections15.bag.TypedSortedBag;
import org.apache.commons.collections15.bag.UnmodifiableBag;
import org.apache.commons.collections15.bag.UnmodifiableSortedBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagUtils {
    public static final Bag EMPTY_BAG = UnmodifiableBag.decorate(new HashBag());
    public static final Bag EMPTY_SORTED_BAG = UnmodifiableSortedBag.decorate(new TreeBag());

    public static <E> Bag<E> synchronizedBag(Bag<E> bag2) {
        return SynchronizedBag.decorate(bag2);
    }

    public static <E> Bag<E> unmodifiableBag(Bag<E> bag2) {
        return UnmodifiableBag.decorate(bag2);
    }

    public static <E> Bag<E> predicatedBag(Bag<E> bag2, Predicate<? super E> predicate) {
        return PredicatedBag.decorate(bag2, predicate);
    }

    public static <E> Bag<E> typedBag(Bag<E> bag2, Class<E> type) {
        return TypedBag.decorate(bag2, type);
    }

    public static <I, O> Bag<O> transformedBag(Bag<I> bag2, Transformer<I, O> transformer) {
        return TransformedBag.decorate(bag2, transformer);
    }

    public static <E> SortedBag<E> synchronizedSortedBag(SortedBag<E> bag2) {
        return SynchronizedSortedBag.decorate(bag2);
    }

    public static <E> SortedBag<E> unmodifiableSortedBag(SortedBag<E> bag2) {
        return UnmodifiableSortedBag.decorate(bag2);
    }

    public static <E> SortedBag<E> predicatedSortedBag(SortedBag<E> bag2, Predicate<? super E> predicate) {
        return PredicatedSortedBag.decorate(bag2, predicate);
    }

    public static <E> SortedBag<E> typedSortedBag(SortedBag<E> bag2, Class<E> type) {
        return TypedSortedBag.decorate(bag2, type);
    }

    public static <I, O> SortedBag<O> transformedSortedBag(SortedBag<I> bag2, Transformer<I, O> transformer) {
        return TransformedSortedBag.decorate(bag2, transformer);
    }
}

