/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;

public final class LargeStringBuffer
implements CharSequence,
Serializable {
    private int minAllocation;
    private int maxAllocation;
    private List segments;
    private int[] startOffsets;
    private int length;

    public LargeStringBuffer() {
        this(4096, 65536);
    }

    public LargeStringBuffer(int n, int n2) {
        this.minAllocation = n;
        this.maxAllocation = n2;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
        this.segments = new ArrayList(4);
        this.segments.add(fastStringBuffer);
        this.startOffsets = new int[1];
        this.startOffsets[0] = 0;
        this.length = 0;
    }

    public void append(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(this.segments.size() - 1);
        if (fastStringBuffer.length() + charSequence.length() <= this.maxAllocation) {
            fastStringBuffer.append(charSequence);
        } else {
            int[] nArray = new int[this.startOffsets.length + 1];
            System.arraycopy(this.startOffsets, 0, nArray, 0, this.startOffsets.length);
            nArray[this.startOffsets.length] = this.length;
            this.startOffsets = nArray;
            fastStringBuffer = new FastStringBuffer(Math.max(this.minAllocation, charSequence.length()));
            this.segments.add(fastStringBuffer);
            fastStringBuffer.append(charSequence);
        }
        this.length += charSequence.length();
    }

    public int length() {
        return this.length;
    }

    public char charAt(int n) {
        if (this.startOffsets.length == 1) {
            return ((FastStringBuffer)this.segments.get(0)).charAt(n);
        }
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException(n + "");
        }
        int n2 = Arrays.binarySearch(this.startOffsets, n);
        if (n2 >= 0) {
            return ((FastStringBuffer)this.segments.get(n2)).charAt(0);
        }
        n2 = -n2 - 2;
        int n4 = n - this.startOffsets[n2];
        return ((FastStringBuffer)this.segments.get(n2)).charAt(n4);
    }

    public CharSequence subSequence(int n, int n2) {
        int n4;
        int n5;
        if (this.startOffsets.length == 1) {
            return ((FastStringBuffer)this.segments.get(0)).subSequence(n, n2);
        }
        if (n < 0 || n2 < 0 || n2 > this.length || n > n2) {
            throw new IndexOutOfBoundsException("[" + n + ',' + n2 + ']');
        }
        int n6 = Arrays.binarySearch(this.startOffsets, n);
        if (n6 >= 0) {
            n5 = 0;
        } else {
            n6 = -n6 - 2;
            n5 = n - this.startOffsets[n6];
        }
        int n7 = Arrays.binarySearch(this.startOffsets, n2);
        if (n7 >= 0) {
            n4 = 0;
        } else {
            n7 = -n7 - 2;
            n4 = n2 - this.startOffsets[n7];
        }
        FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(n6);
        if (n6 == n7) {
            return fastStringBuffer.subSequence(n5, n4);
        }
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(n2 - n);
        fastStringBuffer2.append(fastStringBuffer.subSequence(n5, fastStringBuffer.length()));
        for (int i = n6 + 1; i < n7; ++i) {
            fastStringBuffer2.append((FastStringBuffer)this.segments.get(i));
        }
        if (n4 > 0) {
            fastStringBuffer2.append(((FastStringBuffer)this.segments.get(n7)).subSequence(0, n4));
        }
        return fastStringBuffer2;
    }

    public String toString() {
        if (this.startOffsets.length == 1) {
            return this.segments.get(0).toString();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.length);
        for (int i = 0; i < this.segments.size(); ++i) {
            fastStringBuffer.append((FastStringBuffer)this.segments.get(i));
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(i);
            for (int j = 0; j < fastStringBuffer.length(); ++j) {
                n = 31 * n + this.charAt(j);
            }
        }
        return n;
    }

    public String substring(int n, int n2) {
        return ((Object)this.subSequence(n, n2)).toString();
    }

    public void write(Writer writer) throws IOException {
        for (int i = 0; i < this.segments.size(); ++i) {
            FastStringBuffer fastStringBuffer = (FastStringBuffer)this.segments.get(i);
            fastStringBuffer.write(writer);
        }
    }
}

