/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintStream;
import java.io.Serializable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements ErrorListener,
Serializable {
    private int recoveryPolicy = 1;
    private int warningCount = 0;
    protected transient PrintStream errorOutput = System.err;

    public StandardErrorListener makeAnother(int n) {
        return new StandardErrorListener();
    }

    public void setErrorOutput(PrintStream printStream) {
        this.errorOutput = printStream;
    }

    public PrintStream getErrorOutput() {
        return this.errorOutput;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String string = "";
        if (transformerException.getLocator() != null) {
            string = StandardErrorListener.getLocationMessage(transformerException) + "\n  ";
        }
        string = string + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        if (transformerException instanceof ValidationException) {
            this.errorOutput.println("Validation error " + string);
        } else {
            this.errorOutput.println("Warning: " + string);
            ++this.warningCount;
            if (this.warningCount > 25) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String string = StandardErrorListener.getLocationMessage(transformerException) + "\n  " + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        if (transformerException instanceof ValidationException) {
            this.errorOutput.println("Validation error " + string);
        } else if (this.recoveryPolicy == 1) {
            this.errorOutput.println("Recoverable error " + string);
            ++this.warningCount;
            if (this.warningCount > 25) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.errorOutput.println("Recoverable error " + string);
            this.errorOutput.println("Processing terminated because error recovery is disabled");
            throw new DynamicError(transformerException);
        }
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        if (transformerException instanceof XPathException && ((XPathException)transformerException).hasBeenReported()) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String string = (transformerException instanceof ValidationException ? "Validation error " : "Error ") + StandardErrorListener.getLocationMessage(transformerException) + "\n  " + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(transformerException));
        this.errorOutput.println(string);
        if (transformerException instanceof XPathException) {
            ((XPathException)transformerException).setHasBeenReported();
        }
    }

    public static String getLocationMessage(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        while (sourceLocator == null) {
            if (transformerException.getException() instanceof TransformerException) {
                transformerException = (TransformerException)transformerException.getException();
                sourceLocator = transformerException.getLocator();
                continue;
            }
            if (transformerException.getCause() instanceof TransformerException) {
                transformerException = (TransformerException)transformerException.getCause();
                sourceLocator = transformerException.getLocator();
                continue;
            }
            return "";
        }
        XPathContext xPathContext = null;
        if (transformerException instanceof DynamicError) {
            xPathContext = ((DynamicError)transformerException).getXPathContext();
        }
        return StandardErrorListener.getLocationMessage(sourceLocator, xPathContext);
    }

    private static String getLocationMessage(SourceLocator sourceLocator, XPathContext xPathContext) {
        String string = "";
        String string2 = null;
        int n = -1;
        if (sourceLocator instanceof DOMLocator) {
            string = string + "at " + ((DOMLocator)sourceLocator).getOriginatingNode().getNodeName() + ' ';
        } else if (sourceLocator instanceof NodeInfo) {
            string = string + "at " + ((NodeInfo)((Object)sourceLocator)).getDisplayName() + ' ';
        } else if (sourceLocator instanceof InstructionInfoProvider) {
            String string3 = StandardErrorListener.getInstructionName((InstructionInfoProvider)((Object)sourceLocator), xPathContext);
            if (!"".equals(string3)) {
                string = string + "at " + string3 + ' ';
            }
            string2 = ((InstructionInfoProvider)((Object)sourceLocator)).getInstructionInfo().getSystemId();
            n = ((InstructionInfoProvider)((Object)sourceLocator)).getInstructionInfo().getLineNumber();
        }
        if (n == -1) {
            n = sourceLocator.getLineNumber();
        }
        if (n != -1) {
            string = string + "on line " + n + ' ';
        }
        if (sourceLocator.getColumnNumber() != -1) {
            string = string + "column " + sourceLocator.getColumnNumber() + ' ';
        }
        if (string2 == null) {
            string2 = sourceLocator.getSystemId();
        }
        if (string2 != null) {
            string = string + "of " + string2 + ':';
        }
        return string;
    }

    public static String getExpandedMessage(TransformerException transformerException) {
        String string = null;
        if (transformerException instanceof XPathException) {
            string = ((XPathException)transformerException).getErrorCodeLocalPart();
        } else if (transformerException.getException() instanceof XPathException) {
            string = ((XPathException)transformerException.getException()).getErrorCodeLocalPart();
        }
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        Throwable throwable = transformerException;
        while (throwable != null) {
            String string3 = throwable.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            if (string3.startsWith("net.sf.saxon.trans.StaticError: ")) {
                string3 = string3.substring(string3.indexOf(": ") + 2);
            }
            if (!"TRaX Transform Exception".equals(string3) && !string2.endsWith(string3)) {
                if (!"".equals(string2) && !string2.trim().endsWith(":")) {
                    string2 = string2 + ": ";
                }
                string2 = string2 + string3;
            }
            if (throwable instanceof TransformerException) {
                throwable = throwable.getException();
                continue;
            }
            if (!(throwable instanceof SAXException)) break;
            throwable = ((SAXException)throwable).getException();
        }
        return string2;
    }

    private static String getInstructionName(InstructionInfoProvider instructionInfoProvider, XPathContext xPathContext) {
        if (xPathContext == null) {
            return "";
        }
        try {
            InstructionInfo instructionInfo = instructionInfoProvider.getInstructionInfo();
            int n = instructionInfo.getConstructType();
            if (n < 1024 && n != 149 && n != 181) {
                if (xPathContext.getController().getExecutable().getHostLanguage() == 50) {
                    return StandardNames.getDisplayName(n);
                }
                String string = StandardNames.getDisplayName(n);
                int n2 = string.indexOf(58);
                if (n2 > 0) {
                    String string2 = string.substring(n2 + 1);
                    if (string2.equals("document")) {
                        return "document node constructor";
                    }
                    if (string2.equals("text") || string.equals("value-of")) {
                        return "text node constructor";
                    }
                    if (string2.equals("element")) {
                        return "computed element constructor";
                    }
                    if (string2.equals("attribute")) {
                        return "computed attribute constructor";
                    }
                }
                return string;
            }
            switch (n) {
                case 2006: {
                    int n4 = instructionInfo.getObjectNameCode();
                    String string = "element constructor";
                    if (xPathContext != null) {
                        string = string + " <" + xPathContext.getNamePool().getDisplayName(n4) + '>';
                    }
                    return string;
                }
                case 2007: {
                    int n5 = instructionInfo.getObjectNameCode();
                    String string = "attribute constructor";
                    if (xPathContext != null) {
                        string = string + ' ' + xPathContext.getNamePool().getDisplayName(n5) + "=\"{...}\"";
                    }
                    return string;
                }
                case 149: {
                    int n6 = instructionInfo.getObjectNameCode();
                    String string = "function";
                    if (xPathContext != null) {
                        string = string + ' ' + xPathContext.getNamePool().getDisplayName(n6) + "()";
                    }
                    return string;
                }
                case 181: {
                    int n7 = instructionInfo.getObjectNameCode();
                    String string = "template";
                    if (xPathContext != null && n7 != -1) {
                        string = string + " name=\"" + xPathContext.getNamePool().getDisplayName(n7) + '\"';
                    }
                    return string;
                }
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String wordWrap(String string) {
        int n = string.indexOf(10);
        if (n < 0) {
            n = string.length();
        }
        if (n > 100) {
            int n2;
            for (n2 = 90; string.charAt(n2) != ' ' && n2 > 0; --n2) {
            }
            if (n2 > 10) {
                return string.substring(0, n2) + "\n  " + StandardErrorListener.wordWrap(string.substring(n2 + 1));
            }
            return string;
        }
        if (n < string.length()) {
            return string.substring(0, n) + '\n' + StandardErrorListener.wordWrap(string.substring(n + 1));
        }
        return string;
    }
}

