/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.util;

import info.monitorenter.cpdetector.util.Entry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;

public class FileUtil {
    public static Map.Entry cutExtension(String filename) {
        String prefix;
        String suffix = null;
        StringTokenizer tokenizer = new StringTokenizer(filename, ".");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount > 1) {
            StringBuffer prefCollect = new StringBuffer();
            while (tokenCount > 1) {
                prefCollect.append(tokenizer.nextToken());
                if (--tokenCount <= 1) continue;
                prefCollect.append(".");
            }
            prefix = prefCollect.toString();
            suffix = tokenizer.nextToken();
        } else {
            prefix = filename;
            suffix = "";
        }
        return new Entry(prefix, suffix);
    }

    public static Map.Entry cutDirectoryInformation(String path) {
        StringBuffer dir = new StringBuffer();
        String file = "";
        String fileseparator = System.getProperty("file.separator");
        StringTokenizer tokenizer = new StringTokenizer(path, fileseparator);
        int size = tokenizer.countTokens();
        switch (size) {
            case 0: {
                dir.append(new File(".").getAbsolutePath());
                break;
            }
            case 1: {
                File test = new File(tokenizer.nextToken());
                if (new File(path).isDirectory()) {
                    dir.append(test.getAbsolutePath());
                    break;
                }
                dir.append(new File(".").getAbsolutePath());
                file = path;
                break;
            }
            default: {
                while (tokenizer.hasMoreElements()) {
                    String token = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        dir.append(token);
                        dir.append(fileseparator);
                        continue;
                    }
                    if (new File(path).isFile()) {
                        file = token;
                        continue;
                    }
                    dir.append(token);
                }
                break block0;
            }
        }
        return new Entry(dir.toString(), file);
    }

    public static boolean isAllASCII(InputStream in) throws IOException {
        boolean ret = true;
        int read = -1;
        do {
            if ((read = in.read()) <= 127) continue;
            ret = false;
            break;
        } while (read != -1);
        return ret;
    }
}

