/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector;

import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;

public class CharsetPrinter {
    private final CodepageDetectorProxy detector = CodepageDetectorProxy.getInstance();

    public CharsetPrinter() {
        this.detector.add(new ParsingDetector(false));
        this.detector.add(JChardetFacade.getInstance());
        this.detector.add(ASCIIDetector.getInstance());
    }

    public String guessEncoding(File f) throws MalformedURLException, IOException {
        Charset charset = this.detector.detectCodepage(f.toURL());
        if (charset == null) {
            return null;
        }
        return charset.name();
    }

    public static void main(String[] args) {
        CharsetPrinter cp = new CharsetPrinter();
        if (args.length < 1) {
            System.err.println("Please provide one or more files to examine on the command line after the command.");
        }
        try {
            int walk = 0;
            while (walk < args.length) {
                File f = new File(args[walk]);
                if (f.exists() && f.canRead() && f.isFile()) {
                    System.out.println(String.valueOf(args[walk]) + " appears to be " + cp.guessEncoding(f));
                } else {
                    System.err.println(String.valueOf(args[walk]) + " is not a file, does not exists or is not readable at this time.");
                    System.out.println(String.valueOf(args[walk]) + " appears to be UNKNOWN");
                }
                ++walk;
            }
        }
        catch (MalformedURLException e2) {
            System.err.println("The filename makes no sense.");
        }
        catch (IOException e3) {
            System.err.println("Problem reading from file");
            e3.printStackTrace();
        }
    }
}

