/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;

public class ResultSetUtils {
    public static boolean equals(ResultSet rs1, ResultSet rs2) {
        if (rs1 == rs2) {
            return true;
        }
        Model model2 = ResultSetUtils.resultSetToModel(rs2);
        return ResultSetUtils.equals(rs1, model2);
    }

    private static boolean equals(ResultSet rs1, Model model2) {
        Model model1 = ResultSetUtils.resultSetToModel(rs1);
        return model1.isIsomorphicWith(model2);
    }

    private static Model resultSetToModel(ResultSet rs) {
        Model m = GraphUtils.makeDefaultModel();
        ResultSetFormatter.asRDF(m, rs);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        if (m.getNsPrefixURI("xsd") == null) {
            m.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
        return m;
    }

    public static List resultSetToList(ResultSet rs, String selectElement) {
        ArrayList<RDFNode> items = new ArrayList<RDFNode>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            RDFNode n = qs.get(selectElement);
            items.add(n);
        }
        return items;
    }

    public static List resultSetToStringList(ResultSet rs, String selectElement, String literalOrResource) {
        ArrayList<String> items = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            RDFNode rn = qs.get(selectElement);
            if (rn.isLiteral()) {
                items.add(((Literal)rn).getLexicalForm());
                continue;
            }
            if (rn.isURIResource()) {
                items.add(((Resource)rn).getURI());
                continue;
            }
            if (rn.isAnon()) {
                items.add(((Resource)rn).getId().getLabelString());
                continue;
            }
            throw new ARQException("Unknow thing in results : " + rn);
        }
        return items;
    }
}

