/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class ElementService
extends Element {
    Node serviceNode;
    Element element;

    public ElementService(String serviceURI, Element el) {
        this(Node.createURI(serviceURI), el);
    }

    public ElementService(Node n, Element el) {
        if (!n.isURI() && !n.isVariable()) {
            ALog.fatal(this, "Must be a URI (or variable which will be bound) for a service endpoint");
        }
        this.serviceNode = n;
        this.element = el;
    }

    public Element getElement() {
        return this.element;
    }

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public String getServiceURI() {
        return this.serviceNode.getURI();
    }

    public int hashCode() {
        return this.serviceNode.hashCode() ^ this.element.hashCode();
    }

    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementService)) {
            return false;
        }
        ElementService service = (ElementService)el2;
        if (!this.serviceNode.equals(service.serviceNode)) {
            return false;
        }
        return this.getElement().equalTo(service.getElement(), isoMap);
    }

    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

