/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.sparql.util.Utils;

public class NodeValueDouble
extends NodeValue {
    double value = Double.NaN;

    public NodeValueDouble(double d) {
        this.value = d;
    }

    public NodeValueDouble(double d, Node n) {
        super(n);
        this.value = d;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public double getDouble() {
        return this.value;
    }

    protected Node makeNode() {
        return Node.createLiteral(Utils.stringForm(this.value), null, XSDDatatype.XSDdouble);
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Double.toString(this.value);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

