/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Pattern;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import java.util.ListIterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Selectivity {
    private Model model = null;
    private static Log log = LogFactory.getLog(Selectivity.class);

    public Selectivity(Model model) {
        this.model = model;
    }

    public long calculate(Triple triple) {
        BasicPattern bp = new BasicPattern();
        bp.add(this.normalize(triple));
        return this.calculate(bp);
    }

    public long calculate(Triple triple1, Triple triple2) {
        BasicPattern bp = new BasicPattern();
        bp.add(this.normalize(triple1));
        bp.add(this.normalize(triple2));
        return this.calculate(bp);
    }

    public long calculate(Pattern pattern) {
        BasicPattern bp = new BasicPattern();
        bp.add(new Triple(Var.alloc("x"), pattern.getJoiningProperty().asNode(), Var.alloc("y")));
        if (pattern.getJoinType().getURI().equals("http://jena.hpl.hp.com/ARQo/join#SS")) {
            bp.add(new Triple(Var.alloc("x"), pattern.getJoinedProperty().asNode(), Var.alloc("z")));
        } else if (pattern.getJoinType().getURI().equals("http://jena.hpl.hp.com/ARQo/join#SO")) {
            bp.add(new Triple(Var.alloc("z"), pattern.getJoinedProperty().asNode(), Var.alloc("x")));
        } else if (pattern.getJoinType().getURI().equals("http://jena.hpl.hp.com/ARQo/join#OS")) {
            bp.add(new Triple(Var.alloc("y"), pattern.getJoinedProperty().asNode(), Var.alloc("z")));
        } else if (pattern.getJoinType().getURI().equals("http://jena.hpl.hp.com/ARQo/join#OO")) {
            bp.add(new Triple(Var.alloc("z"), pattern.getJoinedProperty().asNode(), Var.alloc("y")));
        }
        return this.calculate(bp);
    }

    public long calculate(BasicPattern bp) {
        if (this.model == null) {
            log.debug("The graph model is required to calculate the selectivity");
            return -1L;
        }
        Query q = QueryFactory.make();
        q.setQuerySelectType();
        q.setQueryResultStar(true);
        q.setQueryPattern(this.getQueryBasicPattern(bp));
        QueryExecution qe = QueryExecutionFactory.create(q, this.model);
        ResultSet rs = qe.execSelect();
        ResultSetFormatter.consume(rs);
        qe.close();
        return rs.getRowNumber();
    }

    private ElementTriplesBlock getQueryBasicPattern(BasicPattern bp) {
        ElementTriplesBlock el = new ElementTriplesBlock();
        ListIterator iter = bp.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            el.addTriple(triple);
        }
        return el;
    }

    private Triple normalize(Triple triple) {
        Node subject = triple.getSubject();
        Node predicate = triple.getPredicate();
        Node object = triple.getObject();
        Random generator = new Random();
        int randInt = Math.abs(generator.nextInt());
        if (subject.isVariable()) {
            subject = Var.alloc(subject);
        } else if (!subject.isConcrete()) {
            subject = Var.alloc("x" + randInt);
        }
        if (predicate.isVariable()) {
            predicate = Var.alloc(predicate);
        } else if (!predicate.isConcrete()) {
            predicate = Var.alloc("y" + randInt);
        }
        if (object.isVariable()) {
            object = Var.alloc(object);
        } else if (!object.isConcrete()) {
            object = Var.alloc("z" + randInt);
        }
        return new Triple(subject, predicate, object);
    }
}

