/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.PropertyFunctionGenerator;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.util.Context;

public class TransformPropertyFunction
extends TransformCopy {
    private Context context;

    public TransformPropertyFunction(Context context) {
        this.context = context;
    }

    public Op transform(OpTriple opTriple) {
        boolean doingMagicProperties = this.context.isTrue(ARQ.enablePropertyFunctions);
        if (!doingMagicProperties) {
            return opTriple;
        }
        Op x = this.transform(opTriple.asBGP());
        if (!(x instanceof OpBGP)) {
            return x;
        }
        if (opTriple.equivalent((OpBGP)x)) {
            return opTriple;
        }
        return x;
    }

    public Op transform(OpBGP opBGP) {
        boolean doingMagicProperties = this.context.isTrue(ARQ.enablePropertyFunctions);
        if (!doingMagicProperties) {
            return opBGP;
        }
        return PropertyFunctionGenerator.buildPropertyFunctions(opBGP, this.context);
    }
}

