/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.Iterator;

public class TransformEqualityFilter
extends TransformCopy {
    public Op transform(OpFilter opFilter, Op subOp) {
        if (!(subOp instanceof OpBGP) && !(subOp instanceof OpQuadPattern)) {
            return super.transform(opFilter, subOp);
        }
        ExprList exprs = opFilter.getExprs();
        Op op = subOp;
        ExprList exprs2 = new ExprList();
        Iterator iter = exprs.getList().iterator();
        while (iter.hasNext()) {
            Expr e2 = (Expr)iter.next();
            Op op2 = this.processFilter(e2, op);
            if (op2 == null) {
                exprs2.add(e2);
                continue;
            }
            op = op2;
        }
        if (exprs2.size() > 0) {
            op = OpFilter.filter(exprs2, op);
        }
        return op;
    }

    private Op processFilter(Expr e2, Op subOp) {
        if (!(e2 instanceof E_Equals) && !(e2 instanceof E_SameTerm)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return null;
        }
        if (e2 instanceof E_SameTerm && !ARQ.isStrictMode() && constant.isString()) {
            return null;
        }
        if (e2 instanceof E_Equals && !ARQ.isStrictMode() && constant.isLiteral()) {
            return null;
        }
        return TransformEqualityFilter.subst(subOp, var, constant);
    }

    private static Op subst(Op subOp, Var var, NodeValue nv) {
        Op op = Substitute.substitute(subOp, var, nv.asNode());
        return OpAssign.assign(op, var, nv);
    }
}

