/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.AssertFRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BackchainFRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BaseFRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.PatternRouter;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.PropertyBRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasoner;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.ResourceBRWRule;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFSInfGraph
extends BaseInfGraph {
    protected TransitiveGraphCache subClassCache;
    protected boolean haveSplitSubClassCache = false;
    protected TransitiveGraphCache subPropertyCache;
    protected PatternRouter router;
    protected FGraph axioms = new FGraph(Factory.createGraphMem());
    protected Finder tbox;
    protected Finder tripleCache;
    protected HashMap dtRange = null;
    protected boolean scanProperties = true;
    protected static Log logger = LogFactory.getLog(RDFSInfGraph.class);
    protected static BaseFRule[] rules = new BaseFRule[]{new AssertFRule("?x rdf:type rdfs:Class -> ?x rdfs:subClassOf rdfs:Resource"), new AssertFRule("?x rdf:type rdfs:Class -> ?x rdfs:subClassOf ?x"), new AssertFRule("?x rdf:type rdf:Property -> ?x rdfs:subPropertyOf ?x"), new BackchainFRule("?p rdfs:subPropertyOf ?q -> ?s ?q ?o <- ?s ?p ?o"), new BackchainFRule("?c rdfs:subClassOf ?d -> ?s rdf:type ?d <- ?s rdf:type ?c"), new BackchainFRule("?p rdfs:domain ?z -> ?s rdf:type ?z <- ?s ?p _"), new BackchainFRule("?p rdfs:range ?z -> ?o rdf:type ?z <- _ ?p ?s")};
    protected static BRWRule[] brules = new BRWRule[]{new ResourceBRWRule(), new PropertyBRWRule()};
    protected static Triple[] baseAxioms = new Triple[]{BaseFRule.parseTriple("rdf:type rdfs:range rdfs:Class"), BaseFRule.parseTriple("rdfs:Resource rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:Literal rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:Statement rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:nil rdf:type rdf:List"), BaseFRule.parseTriple("rdf:XMLLiteral rdf:type rdfs:Datatype"), BaseFRule.parseTriple("rdf:Alt rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:Seq rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:Bag rdf:type rdfs:Class"), BaseFRule.parseTriple("rdf:XMLLiteral rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:Container rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:ContainerMembershipProperty rdf:type rdfs:Class"), BaseFRule.parseTriple("rdfs:isDefinedBy rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:seeAlso rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:comment rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:label rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:subject rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:predicate rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:object rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:first rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:rest rdf:type rdf:Property"), BaseFRule.parseTriple("rdf:type rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:range rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:domain rdf:type rdf:Property"), BaseFRule.parseTriple("rdfs:subPropertyOf rdfs:domain rdf:Property"), BaseFRule.parseTriple("rdfs:subPropertyOf rdfs:range rdf:Property"), BaseFRule.parseTriple("rdfs:subClassOf rdfs:domain rdfs:Class"), BaseFRule.parseTriple("rdfs:subClassOf rdfs:range rdfs:Class"), BaseFRule.parseTriple("rdfs:subPropertyOf rdfs:subPropertyOf rdfs:subPropertyOf"), BaseFRule.parseTriple("rdfs:subClassOf rdfs:subPropertyOf rdfs:subClassOf"), BaseFRule.parseTriple("rdf:subject rdfs:subPropertyOf rdf:subject"), BaseFRule.parseTriple("rdf:predicate rdfs:subPropertyOf rdf:predicate"), BaseFRule.parseTriple("rdf:object rdfs:subPropertyOf rdf:object"), BaseFRule.parseTriple("rdf:first rdfs:subPropertyOf rdf:first"), BaseFRule.parseTriple("rdf:rest rdfs:subPropertyOf rdf:rest"), BaseFRule.parseTriple("rdf:type rdfs:subPropertyOf rdf:type"), BaseFRule.parseTriple("rdfs:range rdfs:subPropertyOf rdfs:range"), BaseFRule.parseTriple("rdfs:domain rdfs:subPropertyOf rdfs:domain")};

    public RDFSInfGraph(RDFSReasoner reasoner, Graph data) {
        super(data, reasoner);
        this.scanProperties = reasoner.scanProperties;
    }

    public boolean getScanProperties() {
        return this.scanProperties;
    }

    public void setScanProperties(boolean scanProperties) {
        this.scanProperties = scanProperties;
    }

    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("RDFS1 reasoner got into an illegal state");
    }

    public void prepare() {
        this.subClassCache = ((TransitiveReasoner)this.reasoner).getSubClassCache();
        this.subPropertyCache = ((TransitiveReasoner)this.reasoner).getSubPropertyCache().deepCopy();
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.haveSplitSubClassCache = false;
        this.tripleCache = this.tbox == null ? this.axioms : FinderUtil.cascade(this.axioms, this.tbox);
        Graph data = this.fdata.getGraph();
        if (TransitiveEngine.checkOccuranceUtility(RDFSReasoner.subPropertyOf, data, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(RDFSReasoner.subClassOf, data, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(RDFSReasoner.domainP, data, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(RDFSReasoner.rangeP, data, this.subPropertyCache)) {
            FGraph tempTbox = this.tbox == null ? this.fdata : FinderUtil.cascade(this.tbox, this.fdata);
            this.splitSubClassCache();
            TransitiveEngine.cacheSubPropUtility(tempTbox, this.subPropertyCache);
            TransitiveEngine.cacheSubClassUtility(tempTbox, this.subPropertyCache, this.subClassCache);
            this.subPropertyCache.setCaching(true);
        }
        for (int i = 0; i < baseAxioms.length; ++i) {
            this.axioms.getGraph().add(baseAxioms[i]);
        }
        TransitiveEngine.cacheSubPropUtility(this.axioms, this.subPropertyCache);
        if (this.scanProperties) {
            ExtendedIterator it = this.tripleCache.findWithContinuation(new TriplePattern(null, null, null), this.fdata);
            HashSet<Node> properties = new HashSet<Node>();
            String memberPrefix = RDF.getURI() + "_";
            Node sP = RDF.Property.asNode();
            while (it.hasNext()) {
                Triple triple = (Triple)it.next();
                Node prop = triple.getPredicate();
                if (prop.equals(RDF.type.asNode()) && prop.equals(RDF.Property.asNode())) {
                    prop = triple.getSubject();
                }
                if (!properties.add(prop)) continue;
                this.subPropertyCache.addRelation(new Triple(prop, sP, prop));
                if (!prop.getURI().startsWith(memberPrefix)) continue;
                this.axioms.getGraph().add(new Triple(prop, RDF.type.asNode(), RDFS.ContainerMembershipProperty.asNode()));
                this.subPropertyCache.addRelation(new Triple(prop, sP, RDFS.member.asNode()));
            }
        }
        this.router = new PatternRouter();
        this.router.register(this.subPropertyCache);
        this.router.register(this.subClassCache);
        this.checkAllForwardRules();
        for (int i = 0; i < brules.length; ++i) {
            this.addBRule(brules[i]);
        }
        this.isPrepared = true;
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        return new UniqueExtendedIterator(this.router.find(pattern, this.tripleCache, continuation, this));
    }

    public ExtendedIterator findNested(TriplePattern pattern, Finder continuation, HashSet firedRules) {
        return this.router.find(pattern, this.tripleCache, continuation, this, firedRules);
    }

    public ExtendedIterator findRawWithContinuation(TriplePattern pattern, Finder continuation) {
        return this.tripleCache.findWithContinuation(pattern, continuation);
    }

    public ExtendedIterator findProperties() {
        return this.subPropertyCache.listAllSubjects();
    }

    public boolean isProperty(Node prop) {
        return this.subPropertyCache.isSubject(prop);
    }

    public ValidityReport validate() {
        StandardValidityReport report = new StandardValidityReport();
        HashMap dtRange = this.getDTRange();
        Iterator props = dtRange.keySet().iterator();
        while (props.hasNext()) {
            Node prop = (Node)props.next();
            ExtendedIterator i = this.find(null, prop, null);
            while (i.hasNext()) {
                Triple triple = (Triple)i.next();
                report.add(this.checkLiteral(prop, triple.getObject()));
            }
        }
        return report;
    }

    private HashMap getDTRange() {
        if (this.dtRange == null) {
            this.dtRange = new HashMap();
            ExtendedIterator i = this.find(null, RDFS.range.asNode(), null);
            while (i.hasNext()) {
                RDFDatatype dt;
                Triple triple = (Triple)i.next();
                Node prop = triple.getSubject();
                Node rangeValue = triple.getObject();
                if (!rangeValue.isURI() || (dt = TypeMapper.getInstance().getTypeByName(rangeValue.getURI())) == null) continue;
                ArrayList<RDFDatatype> range = (ArrayList<RDFDatatype>)this.dtRange.get(prop);
                if (range == null) {
                    range = new ArrayList<RDFDatatype>();
                    this.dtRange.put(prop, range);
                }
                range.add(dt);
            }
        }
        return this.dtRange;
    }

    private ValidityReport.Report checkLiteral(Node prop, Node value) {
        List range = (List)this.getDTRange().get(prop);
        if (range != null) {
            if (!value.isLiteral()) {
                return new ValidityReport.Report(true, "dtRange", "Property " + prop + " has a typed range but was given a non literal value " + value);
            }
            LiteralLabel ll = value.getLiteral();
            Iterator i = range.iterator();
            while (i.hasNext()) {
                RDFDatatype dt = (RDFDatatype)i.next();
                if (dt.isValidLiteral(ll)) continue;
                return new ValidityReport.Report(true, "dtRange", "Property " + prop + " has a typed range " + dt + "that is not compatible with " + value);
            }
        }
        return null;
    }

    private void checkAllForwardRules() {
        Finder caches = FinderUtil.cascade(this.subPropertyCache, this.subClassCache, this.tripleCache);
        for (int i = 0; i < rules.length; ++i) {
            BaseFRule rule = rules[i];
            TriplePattern head = rule.getHead();
            Node pPattern = head.getPredicate();
            if (pPattern.isVariable()) {
                this.checkRule(head, rule, caches);
                continue;
            }
            TriplePattern spPatt = new TriplePattern(null, TransitiveReasoner.subPropertyOf, pPattern);
            ExtendedIterator sps = this.subPropertyCache.find(spPatt);
            while (sps.hasNext()) {
                TriplePattern altHead = new TriplePattern(head.getSubject(), ((Triple)sps.next()).getSubject(), head.getObject());
                this.checkRule(altHead, rule, caches);
            }
        }
    }

    private void checkRule(TriplePattern altHead, BaseFRule rule, Finder caches) {
        ExtendedIterator it = caches.findWithContinuation(altHead, this.fdata);
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            rule.bindAndFire(t, this);
        }
    }

    public void assertTriple(Triple t) {
        this.axioms.getGraph().add(t);
    }

    public void addBRule(BRWRule rule) {
        this.router.register(rule);
    }

    private void splitSubClassCache() {
        if (!this.haveSplitSubClassCache) {
            this.subClassCache = this.subClassCache.deepCopy();
            this.haveSplitSubClassCache = true;
        }
    }

    public String toString() {
        ExtendedIterator i;
        StringBuffer state = new StringBuffer();
        TriplePattern all = new TriplePattern(null, null, null);
        if (this.tripleCache != null) {
            state.append("axioms + tbox\n");
            i = this.tripleCache.find(all);
            while (i.hasNext()) {
                state.append(TriplePattern.simplePrintString((Triple)i.next()));
                state.append("\n");
            }
        }
        if (this.fdata != null) {
            state.append("Bound raw data\n");
            i = this.fdata.find(all);
            while (i.hasNext()) {
                state.append(TriplePattern.simplePrintString((Triple)i.next()));
                state.append("\n");
            }
        }
        if (this.router != null) {
            state.append("Rule set\n");
            state.append(this.router.toString());
        }
        return state.toString();
    }
}

