### R code from vignette source 'nuCpos-intro.Rnw'

###################################################
### code chunk number 1: nuCpos-intro.Rnw:82-83
###################################################
library(nuCpos)


###################################################
### code chunk number 2: nuCpos-intro.Rnw:99-102
###################################################
predNuCpos(file = system.file("extdata", "TRP1ARS1x1.fasta", 
    package = "nuCpos"), species = "sc", smoothHBA = FALSE, 
    ActLikePredNuPoP = TRUE)


###################################################
### code chunk number 3: nuCpos-intro.Rnw:128-132
###################################################
library(NuPoP)
results.TRP1ARS1x1 <- readNuPoP("TRP1ARS1x1.fasta_Prediction4.txt", 
    startPos = 1, endPos = 1465)
results.TRP1ARS1x1[1:5,]


###################################################
### code chunk number 4: nuCpos-intro.Rnw:142-143
###################################################
results.TRP1ARS1x1[72:76,]


###################################################
### code chunk number 5: nuCpos-intro.Rnw:154-155
###################################################
plotNuPoP(results.TRP1ARS1x1)


###################################################
### code chunk number 6: nuCpos-intro.Rnw:164-169
###################################################
predNuCpos(file = system.file("extdata", "TRP1ARS1x3.fasta", 
    package = "nuCpos"), species = "sc", smoothHBA = FALSE, 
    ActLikePredNuPoP = TRUE)
results.TRP1ARS1 <- readNuPoP("TRP1ARS1x3.fasta_Prediction4.txt", 
    startPos = 1466, endPos = 2930)


###################################################
### code chunk number 7: nuCpos-intro.Rnw:179-195
###################################################
par(mfrow = c(2, 1))
plot(x = 1:1465, y = results.TRP1ARS1x1[,3], type = "n", 
    ylim = c(-0.05, 1), xlab = "Position from the EcoRI site #1", 
    ylab = "probability/occupancy")
title("Not triplicated")
polygon(c(1, 1:1465, 1465), c(0, results.TRP1ARS1x1[,3], 0), col = 8)
points(x = 1:1465, y = results.TRP1ARS1x1[,4], type = "l", col = 2)
points(x = 1:1465, y = results.TRP1ARS1x1[, 2], type = "h", col = 4)

plot(x = 1:1465, y = results.TRP1ARS1[,3], type = "n", 
    ylim = c(-0.05, 1), xlab = "Position from the EcoRI site #1", 
    ylab = "probability/occupancy")
title("Triplicated: central copy")
polygon(c(1, 1:1465, 1465), c(0, results.TRP1ARS1[,3], 0), col = 8)
points(x = 1:1465, y = results.TRP1ARS1[,4], type = "l", col = 2)
points(x = 1:1465, y = results.TRP1ARS1[, 2], type = "h", col = 4)


###################################################
### code chunk number 8: nuCpos-intro.Rnw:211-233
###################################################
predNuPoP(file = system.file("extdata", "TRP1ARS1x3.fasta", 
    package = "nuCpos"), species = 7, model = 4)
results.NuPoP <- readNuPoP("TRP1ARS1x3.fasta_Prediction4.txt", 
    startPos = 1466, endPos = 2930)

par(mfrow = c(2, 1))
plot(x = 1:1465, y = results.TRP1ARS1[,3], type = "n", 
    ylim = c(-0.05, 1), xlab = "Position from the EcoRI site #1", 
    ylab = "probability/occupancy")
title("NuCpos: Eight nucleosomes on the Viterbi path")
polygon(c(1, 1:1465, 1465), c(0, results.TRP1ARS1[,3], 0), col = 8)
points(x = 1:1465, y = results.TRP1ARS1[,4], type = "l", col = 2)
points(x = 1:1465, y = results.TRP1ARS1[, 2], type = "h", col = 4)
text(x = 800, y = 0.5, labels = "*", cex = 2)

plot(x = 1:1465, y = results.NuPoP[,3], type = "n", 
    ylim = c(-0.05, 1), xlab = "Position from the EcoRI site #1", 
    ylab = "probability/occupancy")
title("NuPoP: Seven nucleosomes on the Viterbi path")
polygon(c(1, 1:1465, 1465), c(0, results.NuPoP[,3], 0), col = 8)
points(x = 1:1465, y = results.NuPoP[,4], type = "l", col = 2)
points(x = 1:1465, y = results.NuPoP[, 2], type = "h", col = 4)


###################################################
### code chunk number 9: nuCpos-intro.Rnw:256-276
###################################################
predNuCpos(file = system.file("extdata", "TRP1ARS1x3.fasta", 
    package = "nuCpos"), species = "sc", smoothHBA = TRUE, 
    ActLikePredNuPoP = TRUE)
results.TRP1ARS1.smooth <- readNuPoP("TRP1ARS1x3.fasta_Prediction4.txt", 
    startPos = 1466, endPos = 2930)

par(mfrow = c(2, 1))
plot(x = 1:1465, y = results.TRP1ARS1[,3], type = "n", 
    ylim = c(-0.05, 1), xlab = "Position from the EcoRI site #1", 
    ylab = "probability/occupancy")
title("Occupancy(grey)/probability(blue)/Viterbi(red)")
polygon(c(1, 1:1465, 1465), c(0, results.TRP1ARS1[,3], 0), col = 8)
points(x = 1:1465, y = results.TRP1ARS1[,4], type = "l", col = 2)
points(x = 1:1465, y = results.TRP1ARS1[, 2], type = "h", col = 4)

plot(x = 1:1465, y = results.TRP1ARS1[,5], type = "n", 
    xlab = "Position from the EcoRI site #1", 
    ylab = "HBA", main = "HBA(red)/smoothed HBA(blue)")
points(x = 1:1465, y = results.TRP1ARS1[,5], type = "l", col = 2)
points(x = 1:1465, y = results.TRP1ARS1.smooth[,5], type = "l", col = 4)


###################################################
### code chunk number 10: nuCpos-intro.Rnw:307-314
###################################################
TRP1ARS1 <- paste(scan(file = 
    system.file("extdata", "TRP1ARS1x1.fasta", package = "nuCpos"), 
    what = character(), skip = 1), sep = "", collapse = "")
results.TRP1ARS1.internal <- 
    predNuCpos(inseq = TRP1ARS1, species = "sc", smoothHBA = FALSE, 
    ActLikePredNuPoP = FALSE)
results.TRP1ARS1.internal[72:76,]


###################################################
### code chunk number 11: nuCpos-intro.Rnw:326-334
###################################################
load(system.file("extdata", "inseq.RData", package = "nuCpos"))
HBA(inseq = inseq, species = "sc")
for(i in 1:3) cat(substr(inseq, start = (i-1)*60+1, 
    stop = (i-1)*60+60), "\n")
load(system.file("extdata", "INSEQ_DNAString.RData", 
    package = "nuCpos"))
INSEQ
HBA(inseq = INSEQ, species = "sc")


###################################################
### code chunk number 12: nuCpos-intro.Rnw:362-366
###################################################
localHBA(inseq = inseq, species = "sc")
barplot(localHBA(inseq = inseq, species = "sc"), 
    names.arg = LETTERS[1:13], xlab = "Nucleosomal subsegments", 
    ylab = "local HBA", main = "Local HBA scores for inseq")


###################################################
### code chunk number 13: nuCpos-intro.Rnw:382-397
###################################################
TALS <- paste(scan(file = 
    system.file("extdata", "TALS.fasta", package = "nuCpos"), 
    what = character(), skip = 1), sep = "", collapse = "")
for(i in 1:23) cat(substr(TALS, 
    start = (i-1)*80+1, stop = (i-1)*80+80), "\n")
TTAGGGx29 <- paste(scan(file = 
    system.file("extdata", "TTAGGGx29.fasta", package = "nuCpos"), 
    what = character(), skip = 1), sep = "", collapse = "")
for(i in 1:3) cat(substr(TTAGGGx29, 
    start = (i-1)*80+1, stop = (i-1)*80+80), "\n")
mut.results <- mutNuCpos(wtseq = TALS, site = 1464, ins = TTAGGGx29, 
    species = "sc", smoothHBA = TRUE, plot.window = 601, 
    ylim.HBA = c(-15, 0), show.occup.window = TRUE, 
    annotation = data.frame(name = "alpha2", color = "purple", 
    left = 1534, right = 1559), full = TRUE)


###################################################
### code chunk number 14: nuCpos-intro.Rnw:431-432
###################################################
mut.results[(((1811+76)*2)-3):(((1811+76)*2)+3),]


