  fcsFile<-system.file("extdata/List-modeDataFiles","int-gating_test_file.fcs",package="gatingMLData")
  gateFile <- system.file("extdata/Gating-MLFiles","04PolygonGates.xml",package="gatingMLData")
  csvFile<-paste(system.file("extdata/ExpectedResults/04PolygonGates",package="gatingMLData"))
 
  flowEnv=new.env()
  read.gatingML(gateFile,flowEnv)
  fcs <- read.FCS(fcsFile,transformation=FALSE)

test.ComplicatedNonSimple1<- function() {
      gateId<-"ComplicatedNonSimple1"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.ComplicatedNonSimple2<- function() {
  gateId<-"ComplicatedNonSimple2"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.ComplicatedNonSimple3<- function() {
  gateId<-"ComplicatedNonSimple3"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.ComplicatedNonSimple4<- function() {
  gateId<-"ComplicatedNonSimple4"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.ConcaveBoundary<- function() {
  gateId<-"ConcaveBoundary"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.ConcaveInside<- function() {
  gateId<-"ConcaveInside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.ConcaveOutside<- function() {
  gateId<-"ConcaveOutside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleBottomInside<- function() {
  gateId<-"NonSimpleBottomInside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleBoundaryBackSlant<- function() {
  gateId<-"NonSimpleBoundaryBackSlant"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleBoundaryCrossingPoint<- function() {
  gateId<-"NonSimpleBoundaryCrossingPoint"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleBoundaryForwardSlant<- function() {
  gateId<-"NonSimpleBoundaryForwardSlant"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleLeftOutside<- function() {
  gateId<-"NonSimpleLeftOutside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleRightOutside<- function() {
  gateId<-"NonSimpleRightOutside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.NonSimpleTopInside<- function() {
  gateId<-"NonSimpleTopInside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.RectangleBoundary<- function() {
  gateId<-"RectangleBoundary"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.RectangleInside<- function() {
  gateId<-"RectangleInside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.RectangleOutside<- function() {
  gateId<-"RectangleOutside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.SimpleConcaveBoundary<- function() {
  gateId<-"SimpleConcaveBoundary"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.SimpleConcaveInside<- function() {
  gateId<-"SimpleConcaveInside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}

test.SimpleConcaveOutside<- function() {
  gateId<-"SimpleConcaveOutside"
      csvFile<-paste(csvFile,"/",gateId,".txt",sep="")
      expectedResult<-read.csv(csvFile,header=TRUE)
      flowUtils:::performGateTest(gateId,fcs,expectedResult,flowEnv)
}