/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.DoubleOp;
import java.util.concurrent.atomic.AtomicLongArray;

public class SharedDoubleArray {
    private AtomicLongArray myArray;

    public SharedDoubleArray(int n) {
        this.myArray = new AtomicLongArray(n);
    }

    public SharedDoubleArray(double[] dArray) {
        int n = dArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = Double.doubleToLongBits(dArray[i]);
        }
        this.myArray = new AtomicLongArray(lArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public double get(int n) {
        return Double.longBitsToDouble(this.myArray.get(n));
    }

    public void set(int n, double d) {
        this.myArray.set(n, Double.doubleToLongBits(d));
    }

    public double getAndSet(int n, double d) {
        return Double.longBitsToDouble(this.myArray.getAndSet(n, Double.doubleToLongBits(d)));
    }

    public boolean compareAndSet(int n, double d, double d2) {
        return this.myArray.compareAndSet(n, Double.doubleToLongBits(d), Double.doubleToLongBits(d2));
    }

    public boolean weakCompareAndSet(int n, double d, double d2) {
        return this.myArray.weakCompareAndSet(n, Double.doubleToLongBits(d), Double.doubleToLongBits(d2));
    }

    public double getAndIncrement(int n) {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) + 1.0))) {
        }
        return d;
    }

    public double getAndDecrement(int n) {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) - 1.0))) {
        }
        return d;
    }

    public double getAndAdd(int n, double d) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d3 = (d2 = Double.longBitsToDouble(l2)) + d))) {
        }
        return d2;
    }

    public double incrementAndGet(int n) {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) + 1.0))) {
        }
        return d2;
    }

    public double decrementAndGet(int n) {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d2 = (d = Double.longBitsToDouble(l2)) - 1.0))) {
        }
        return d2;
    }

    public double addAndGet(int n, double d) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d3 = (d2 = Double.longBitsToDouble(l2)) + d))) {
        }
        return d3;
    }

    public double reduce(int n, double d, DoubleOp doubleOp) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d3 = doubleOp.op(d2 = Double.longBitsToDouble(l2), d)))) {
        }
        return d3;
    }

    public void reduce(double[] dArray, DoubleOp doubleOp) {
        this.reduce(0, dArray, 0, this.myArray.length(), doubleOp);
    }

    public void reduce(int n, double[] dArray, int n2, int n3, DoubleOp doubleOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > dArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            double d;
            double d2;
            long l;
            long l2;
            while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = Double.doubleToLongBits(d2 = doubleOp.op(d = Double.longBitsToDouble(l2), dArray[n2])))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.myArray.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.get(i));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

