/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ArrayItemGenerator;
import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.IntegerStrideForLoop;
import edu.rit.pj.ItemGenerator;
import edu.rit.pj.ItemHolder;
import edu.rit.pj.IteratorItemGenerator;
import edu.rit.pj.Lock;
import edu.rit.pj.LongForLoop;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.LongStrideForLoop;
import edu.rit.pj.ParallelConstruct;
import edu.rit.pj.ParallelIteration;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.ParallelTeamThread;
import edu.rit.util.LongRange;
import edu.rit.util.Range;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParallelRegion
extends ParallelConstruct {
    private Lock myLock = new Lock();

    public void start() throws Exception {
    }

    public abstract void run() throws Exception;

    public void finish() throws Exception {
    }

    public final void execute(int n, int n2, IntegerForLoop integerForLoop) throws Exception {
        this.execute(n, n2, integerForLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int n, int n2, IntegerForLoop integerForLoop, BarrierAction barrierAction) throws Exception {
        if (integerForLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            integerForLoop.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            int n3 = parallelTeamThread.myIndex;
            IntegerSchedule integerSchedule = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    integerSchedule = integerForLoop.schedule();
                    integerSchedule.commonStart(this.myTeam.K, new Range(n, n2));
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setIntegerSchedule(integerSchedule);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            integerForLoop.mySchedule = integerSchedule = parallelTeamThread.getIntegerSchedule();
            ParallelTeamThread[] parallelTeamThreadArray = null;
            try {
                Range range;
                integerForLoop.start();
                while ((range = integerSchedule.commonNext(n3)) != null) {
                    integerForLoop.commonRun(range.lb(), range.ub());
                }
                integerForLoop.finish();
            }
            catch (Throwable object) {
                parallelTeamThreadArray = object;
                integerSchedule.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(parallelTeamThreadArray);
        }
        finally {
            integerForLoop.myTeam = null;
            integerForLoop.mySchedule = null;
        }
    }

    public final void execute(int n, int n2, int n3, IntegerStrideForLoop integerStrideForLoop) throws Exception {
        this.execute(n, n2, n3, integerStrideForLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(int n, int n2, int n3, IntegerStrideForLoop integerStrideForLoop, BarrierAction barrierAction) throws Exception {
        if (n3 <= 0) {
            throw new IllegalArgumentException("ParallelRegion.execute(): Stride = " + n3 + " illegal");
        }
        if (integerStrideForLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            integerStrideForLoop.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            int n4 = parallelTeamThread.myIndex;
            IntegerSchedule integerSchedule = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    integerSchedule = integerStrideForLoop.schedule();
                    integerSchedule.commonStart(this.myTeam.K, new Range(n, n2, n3));
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setIntegerSchedule(integerSchedule);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            integerStrideForLoop.mySchedule = integerSchedule = parallelTeamThread.getIntegerSchedule();
            ParallelTeamThread[] parallelTeamThreadArray = null;
            try {
                Range range;
                integerStrideForLoop.start();
                while ((range = integerSchedule.commonNext(n4)) != null) {
                    integerStrideForLoop.commonRun(range.lb(), range.ub(), range.stride());
                }
                integerStrideForLoop.finish();
            }
            catch (Throwable object) {
                parallelTeamThreadArray = object;
                integerSchedule.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(parallelTeamThreadArray);
        }
        finally {
            integerStrideForLoop.myTeam = null;
            integerStrideForLoop.mySchedule = null;
        }
    }

    public final void execute(long l, long l2, LongForLoop longForLoop) throws Exception {
        this.execute(l, l2, longForLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long l, long l2, LongForLoop longForLoop, BarrierAction barrierAction) throws Exception {
        if (longForLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            longForLoop.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            int n = parallelTeamThread.myIndex;
            LongSchedule longSchedule = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    longSchedule = longForLoop.schedule();
                    longSchedule.commonStart(this.myTeam.K, new LongRange(l, l2));
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setLongSchedule(longSchedule);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            longForLoop.mySchedule = longSchedule = parallelTeamThread.getLongSchedule();
            ParallelTeamThread[] parallelTeamThreadArray = null;
            try {
                LongRange longRange;
                longForLoop.start();
                while ((longRange = longSchedule.commonNext(n)) != null) {
                    longForLoop.commonRun(longRange.lb(), longRange.ub());
                }
                longForLoop.finish();
            }
            catch (Throwable object) {
                parallelTeamThreadArray = object;
                longSchedule.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(parallelTeamThreadArray);
        }
        finally {
            longForLoop.myTeam = null;
            longForLoop.mySchedule = null;
        }
    }

    public final void execute(long l, long l2, long l3, LongStrideForLoop longStrideForLoop) throws Exception {
        this.execute(l, l2, l3, longStrideForLoop, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(long l, long l2, long l3, LongStrideForLoop longStrideForLoop, BarrierAction barrierAction) throws Exception {
        if (l3 <= 0L) {
            throw new IllegalArgumentException("ParallelRegion.execute(): Stride = " + l3 + " illegal");
        }
        if (longStrideForLoop == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel for loop is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            longStrideForLoop.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            int n = parallelTeamThread.myIndex;
            LongSchedule longSchedule = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    longSchedule = longStrideForLoop.schedule();
                    longSchedule.commonStart(this.myTeam.K, new LongRange(l, l2, l3));
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setLongSchedule(longSchedule);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            longStrideForLoop.mySchedule = longSchedule = parallelTeamThread.getLongSchedule();
            ParallelTeamThread[] parallelTeamThreadArray = null;
            try {
                LongRange longRange;
                longStrideForLoop.start();
                while ((longRange = longSchedule.commonNext(n)) != null) {
                    longStrideForLoop.commonRun(longRange.lb(), longRange.ub(), longRange.stride());
                }
                longStrideForLoop.finish();
            }
            catch (Throwable object) {
                parallelTeamThreadArray = object;
                longSchedule.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(parallelTeamThreadArray);
        }
        finally {
            longStrideForLoop.myTeam = null;
            longStrideForLoop.mySchedule = null;
        }
    }

    public final <T> void execute(T[] TArray, ParallelIteration<T> parallelIteration) throws Exception {
        this.execute(TArray, parallelIteration, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> void execute(T[] TArray, ParallelIteration<T> parallelIteration, BarrierAction barrierAction) throws Exception {
        if (TArray == null) {
            throw new NullPointerException("ParallelRegion.execute(): Array is null");
        }
        if (parallelIteration == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel iteration is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            void var6_11;
            parallelIteration.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            ItemGenerator<?> itemGenerator = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    itemGenerator = new ArrayItemGenerator(TArray);
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setItemGenerator(itemGenerator);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            itemGenerator = parallelTeamThread.getItemGenerator();
            parallelIteration.myItemGenerator = itemGenerator;
            Object var6_9 = null;
            try {
                ItemHolder<?> itemHolder;
                parallelIteration.start();
                while ((itemHolder = itemGenerator.nextItem()) != null) {
                    parallelIteration.commonRun(itemHolder.mySequenceNumber, itemHolder.myItem);
                }
                parallelIteration.finish();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                itemGenerator.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(var6_11);
        }
        finally {
            parallelIteration.myTeam = null;
            parallelIteration.myItemGenerator = null;
        }
    }

    public final <T> void execute(Iterator<T> iterator, ParallelIteration<T> parallelIteration) throws Exception {
        this.execute(iterator, parallelIteration, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> void execute(Iterator<T> iterator, ParallelIteration<T> parallelIteration, BarrierAction barrierAction) throws Exception {
        if (iterator == null) {
            throw new NullPointerException("ParallelRegion.execute(): Iterator is null");
        }
        if (parallelIteration == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel iteration is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            void var6_11;
            parallelIteration.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            ItemGenerator<?> itemGenerator = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    itemGenerator = new IteratorItemGenerator(iterator);
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setItemGenerator(itemGenerator);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            itemGenerator = parallelTeamThread.getItemGenerator();
            parallelIteration.myItemGenerator = itemGenerator;
            Object var6_9 = null;
            try {
                ItemHolder<?> itemHolder;
                parallelIteration.start();
                while ((itemHolder = itemGenerator.nextItem()) != null) {
                    parallelIteration.commonRun(itemHolder.mySequenceNumber, itemHolder.myItem);
                }
                parallelIteration.finish();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                itemGenerator.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(var6_11);
        }
        finally {
            parallelIteration.myTeam = null;
            parallelIteration.myItemGenerator = null;
        }
    }

    public final <T> void execute(Iterable<T> iterable, ParallelIteration<T> parallelIteration) throws Exception {
        this.execute(iterable, parallelIteration, BarrierAction.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> void execute(Iterable<T> iterable, ParallelIteration<T> parallelIteration, BarrierAction barrierAction) throws Exception {
        if (iterable == null) {
            throw new NullPointerException("ParallelRegion.execute(): Iterable collection is null");
        }
        if (parallelIteration == null) {
            throw new NullPointerException("ParallelRegion.execute(): Parallel iteration is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.execute(): No parallel team executing");
        }
        try {
            void var6_11;
            parallelIteration.myTeam = this.myTeam;
            ParallelTeamThread parallelTeamThread = this.getCurrentThread();
            ItemGenerator<?> itemGenerator = null;
            if (parallelTeamThread.arriveAtParallelConstruct()) {
                try {
                    itemGenerator = new IteratorItemGenerator(iterable.iterator());
                    for (ParallelTeamThread parallelTeamThread2 : this.myTeam.myThread) {
                        parallelTeamThread2.setItemGenerator(itemGenerator);
                    }
                }
                catch (Throwable throwable) {
                    for (ParallelTeamThread parallelTeamThread3 : this.myTeam.myThread) {
                        parallelTeamThread3.setConstructException(throwable);
                    }
                }
            }
            itemGenerator = parallelTeamThread.getItemGenerator();
            parallelIteration.myItemGenerator = itemGenerator;
            Object var6_9 = null;
            try {
                ItemHolder<?> itemHolder;
                parallelIteration.start();
                while ((itemHolder = itemGenerator.nextItem()) != null) {
                    parallelIteration.commonRun(itemHolder.mySequenceNumber, itemHolder.myItem);
                }
                parallelIteration.finish();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                itemGenerator.myBreak = true;
            }
            barrierAction.doBarrier(parallelTeamThread);
            ParallelTeam.rethrow(var6_11);
        }
        finally {
            parallelIteration.myTeam = null;
            parallelIteration.myItemGenerator = null;
        }
    }

    public final void execute(ParallelSection parallelSection) throws Exception {
        this.execute(new ParallelSection[]{parallelSection}, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection parallelSection, BarrierAction barrierAction) throws Exception {
        this.execute(new ParallelSection[]{parallelSection}, barrierAction);
    }

    public final void execute(ParallelSection parallelSection, ParallelSection parallelSection2) throws Exception {
        this.execute(new ParallelSection[]{parallelSection, parallelSection2}, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection parallelSection, ParallelSection parallelSection2, BarrierAction barrierAction) throws Exception {
        this.execute(new ParallelSection[]{parallelSection, parallelSection2}, barrierAction);
    }

    public final void execute(ParallelSection parallelSection, ParallelSection parallelSection2, ParallelSection parallelSection3) throws Exception {
        this.execute(new ParallelSection[]{parallelSection, parallelSection2, parallelSection3}, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection parallelSection, ParallelSection parallelSection2, ParallelSection parallelSection3, BarrierAction barrierAction) throws Exception {
        this.execute(new ParallelSection[]{parallelSection, parallelSection2, parallelSection3}, barrierAction);
    }

    public final void execute(ParallelSection[] parallelSectionArray) throws Exception {
        this.execute(parallelSectionArray, BarrierAction.WAIT);
    }

    public final void execute(ParallelSection[] parallelSectionArray, BarrierAction barrierAction) throws Exception {
        if (parallelSectionArray == null) {
            throw new NullPointerException("ParallelRegion.execute(): sections is null");
        }
        for (ParallelSection parallelSection : parallelSectionArray) {
            if (parallelSection != null) continue;
            throw new NullPointerException("ParallelRegion.execute(): A parallel section is null");
        }
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.execute(): Barrier action is null");
        }
        this.execute(parallelSectionArray, new ParallelIteration<ParallelSection>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ParallelSection parallelSection) throws Exception {
                try {
                    parallelSection.myTeam = this.myTeam;
                    parallelSection.run();
                }
                finally {
                    parallelSection.myTeam = null;
                }
            }
        }, barrierAction);
    }

    public final void critical(ParallelSection parallelSection) throws Exception {
        this.critical(this.myLock, parallelSection);
    }

    public final void criticalNonexclusive(ParallelSection parallelSection) throws Exception {
        this.criticalNonexclusive(this.myLock, parallelSection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void critical(Lock lock, ParallelSection parallelSection) throws Exception {
        if (lock == null) {
            throw new NullPointerException("ParallelRegion.critical(): Lock is null");
        }
        if (parallelSection == null) {
            throw new NullPointerException("ParallelRegion.critical(): Parallel section is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.critical(): No parallel team executing");
        }
        lock.lockExclusive();
        try {
            parallelSection.myTeam = this.myTeam;
            parallelSection.run();
        }
        finally {
            parallelSection.myTeam = null;
            lock.unlockExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void criticalNonexclusive(Lock lock, ParallelSection parallelSection) throws Exception {
        if (lock == null) {
            throw new NullPointerException("ParallelRegion.criticalNonexclusive(): Lock is null");
        }
        if (parallelSection == null) {
            throw new NullPointerException("ParallelRegion.criticalNonexclusive(): Parallel section is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelRegion.criticalNonexclusive(): No parallel team executing");
        }
        lock.lockNonexclusive();
        try {
            parallelSection.myTeam = this.myTeam;
            parallelSection.run();
        }
        finally {
            parallelSection.myTeam = null;
            lock.unlockNonexclusive();
        }
    }

    public final void barrier() {
        this.getCurrentThread().barrier();
    }

    public final void barrier(BarrierAction barrierAction) throws Exception {
        if (barrierAction == null) {
            throw new NullPointerException("ParallelRegion.barrier(): Barrier action is null");
        }
        barrierAction.doBarrier(this.getCurrentThread());
    }
}

