/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.plot.Strokes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class Ticks {
    public static final Stroke DEFAULT_STROKE = Strokes.solid(1.0);
    public static final Paint DEFAULT_PAINT = Color.black;
    public static final double DEFAULT_LENGTH = 5.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("sanserif", 0, 12);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final double DEFAULT_LABEL_OFFSET = 5.0;
    protected Stroke myStroke;
    protected Paint myPaint;
    protected double myLength;
    protected DecimalFormat myLabelFormat;
    protected double myLabelScale;
    protected Font myLabelFont;
    protected Paint myLabelPaint;
    protected double myLabelOffset;

    public Ticks() {
        this(DEFAULT_STROKE, DEFAULT_PAINT, 5.0, null, 1.0, DEFAULT_LABEL_FONT, DEFAULT_LABEL_PAINT, 5.0);
    }

    public Ticks(DecimalFormat decimalFormat) {
        this(DEFAULT_STROKE, DEFAULT_PAINT, 5.0, decimalFormat, 1.0, DEFAULT_LABEL_FONT, DEFAULT_LABEL_PAINT, 5.0);
    }

    public Ticks(DecimalFormat decimalFormat, double d) {
        this(DEFAULT_STROKE, DEFAULT_PAINT, 5.0, decimalFormat, d, DEFAULT_LABEL_FONT, DEFAULT_LABEL_PAINT, 5.0);
    }

    public Ticks(Stroke stroke, Paint paint, double d, DecimalFormat decimalFormat, double d2, Font font, Paint paint2, double d3) {
        if (stroke == null || paint == null || decimalFormat != null && font == null || decimalFormat != null && paint2 == null) {
            throw new NullPointerException();
        }
        if (d <= 0.0 || decimalFormat != null && d2 == 0.0 || decimalFormat != null && d3 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.myStroke = stroke;
        this.myPaint = paint;
        this.myLength = d;
        this.myLabelFormat = decimalFormat;
        if (decimalFormat == null) {
            this.myLabelScale = 1.0;
            this.myLabelFont = null;
            this.myLabelPaint = null;
            this.myLabelOffset = 0.0;
        } else {
            this.myLabelScale = d2;
            this.myLabelFont = font;
            this.myLabelPaint = paint2;
            this.myLabelOffset = d3;
        }
    }

    public Stroke getStroke() {
        return this.myStroke;
    }

    public Paint getPaint() {
        return this.myPaint;
    }

    public double getLength() {
        return this.myLength;
    }

    public DecimalFormat getLabelFormat() {
        return this.myLabelFormat;
    }

    public double getLabelScale() {
        return this.myLabelScale;
    }

    public Font getLabelFont() {
        return this.myLabelFont;
    }

    public Paint getLabelPaint() {
        return this.myLabelPaint;
    }

    public double getLabelOffset() {
        return this.myLabelOffset;
    }

    public void drawLeft(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, -this.myLength, 0.0));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public void drawLeft(Graphics2D graphics2D, double d) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, -this.myLength, 0.0));
        if (this.myLabelFormat != null) {
            graphics2D.setFont(this.myLabelFont);
            graphics2D.setPaint(this.myLabelPaint);
            String string = this.myLabelFormat.format(d / this.myLabelScale);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = this.myLabelFont.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = this.myLabelFont.getLineMetrics(string, fontRenderContext);
            graphics2D.drawString(string, (float)(-this.myLength - this.myLabelOffset - rectangle2D.getWidth()), lineMetrics.getAscent() / 2.0f);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public void drawRight(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, this.myLength, 0.0));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public void drawRight(Graphics2D graphics2D, double d) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, this.myLength, 0.0));
        if (this.myLabelFormat != null) {
            graphics2D.setFont(this.myLabelFont);
            graphics2D.setPaint(this.myLabelPaint);
            String string = this.myLabelFormat.format(d / this.myLabelScale);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = this.myLabelFont.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = this.myLabelFont.getLineMetrics(string, fontRenderContext);
            graphics2D.drawString(string, (float)(this.myLength + this.myLabelOffset), lineMetrics.getAscent() / 2.0f);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public void drawBelow(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, this.myLength));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public void drawBelow(Graphics2D graphics2D, double d) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, this.myLength));
        if (this.myLabelFormat != null) {
            graphics2D.setFont(this.myLabelFont);
            graphics2D.setPaint(this.myLabelPaint);
            String string = this.myLabelFormat.format(d / this.myLabelScale);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = this.myLabelFont.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = this.myLabelFont.getLineMetrics(string, fontRenderContext);
            graphics2D.drawString(string, (float)(-rectangle2D.getWidth() / 2.0), (float)(this.myLength + this.myLabelOffset + (double)lineMetrics.getAscent()));
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    public void drawAbove(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, -this.myLength));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public void drawAbove(Graphics2D graphics2D, double d) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, -this.myLength));
        if (this.myLabelFormat != null) {
            graphics2D.setFont(this.myLabelFont);
            graphics2D.setPaint(this.myLabelPaint);
            String string = this.myLabelFormat.format(d / this.myLabelScale);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = this.myLabelFont.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = this.myLabelFont.getLineMetrics(string, fontRenderContext);
            graphics2D.drawString(string, (float)(-rectangle2D.getWidth() / 2.0), (float)(-this.myLength - this.myLabelOffset - (double)lineMetrics.getDescent()));
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }
}

