/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.SharedObjectArrayReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedObjectArray;
import edu.rit.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectArrayBuf<T>
extends ObjectBuf<T> {
    SharedObjectArray<T> myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedObjectArrayBuf(SharedObjectArray<T> sharedObjectArray, Range range) {
        super(range.length());
        this.myArray = sharedObjectArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    @Override
    public T get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    @Override
    public void put(int n, T t) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, t);
        this.mySerializedItems = null;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedObjectArrayReductionBuf<T>(this.myArray, this.myRange, (ObjectOp)op, this);
    }
}

