/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongMatrixBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

class LongMatrixReductionBuf
extends LongMatrixBuf {
    LongOp myOp;

    public LongMatrixReductionBuf(long[][] lArray, Range range, Range range2, LongOp longOp) {
        super(lArray, range, range2);
        if (longOp == null) {
            throw new NullPointerException("LongMatrixReductionBuf(): op is null");
        }
        this.myOp = longOp;
    }

    public void put(int n, long l) {
        int n2 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n3 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], l);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof LongMatrixBuf) {
                LongMatrixBuf longMatrixBuf = (LongMatrixBuf)buf;
                ReduceArrays.reduce(longMatrixBuf.myMatrix, longMatrixBuf.myRowRange, longMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                LongBuf.defaultCopy((LongBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        n2 = Math.min(n2, longBuffer.remaining());
        int n3 = 0;
        int n4 = this.i2r(n);
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = this.i2c(n);
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, n2);
        while (n4 < this.myRowCount && n8 > 0) {
            long[] lArray = this.myMatrix[n5];
            for (n6 = 0; n6 < n8; ++n6) {
                lArray[n7] = this.myOp.op(lArray[n7], longBuffer.get());
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, n2 -= n8);
        }
        byteBuffer.position(byteBuffer.position() + 8 * n3);
        return n3;
    }
}

