/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.DataBufferIntegerMatrix;
import edu.rit.image.SampleModelIntegerMatrix;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

class IntegerColorModel
extends ColorModel {
    public IntegerColorModel() {
        super(24, new int[]{8, 8, 8}, ColorSpace.getInstance(1000), false, false, 1, 3);
    }

    public int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public int getAlpha(int n) {
        return 255;
    }

    public int getRGB(int n) {
        return 0xFF000000 | n;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return raster.getSampleModel() instanceof SampleModelIntegerMatrix && raster.getDataBuffer() instanceof DataBufferIntegerMatrix;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        int[][] nArray = new int[n2][n];
        return Raster.createWritableRaster(new SampleModelIntegerMatrix(n, n2), new DataBufferIntegerMatrix(nArray), null);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SampleModelIntegerMatrix(n, n2);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof SampleModelIntegerMatrix;
    }
}

