/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.prime;

import edu.rit.hyb.prime.LongIterator;
import edu.rit.hyb.prime.Sieve;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Prime32File {
    private Prime32File() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            Prime32File.usage();
        }
        File file = new File(stringArray[0]);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Sieve sieve = new Sieve(0L, 65536);
        sieve.initialize();
        long l = 3L;
        while (sieve.sieveOut(l)) {
            while (!sieve.isPrime(l += 2L)) {
            }
        }
        LongIterator longIterator = sieve.iterator();
        longIterator.next();
        long l2 = Prime32File.writePrimeDiffs(bufferedOutputStream, longIterator, 3L);
        Sieve sieve2 = new Sieve(0L, 65536);
        for (long i = 65536L; i < 0x100000000L; i += 65536L) {
            sieve2.lb(i);
            sieve2.sieveOut(sieve.iterator());
            l2 = Prime32File.writePrimeDiffs(bufferedOutputStream, sieve2.iterator(), l2);
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    private static long writePrimeDiffs(OutputStream outputStream, LongIterator longIterator, long l) throws IOException {
        long l2;
        while ((l2 = longIterator.next()) != 0L) {
            int n = (int)(l2 - l >> 1);
            outputStream.write(n);
            l = l2;
        }
        return l;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.hyb.prime.Prime32File <primefile>");
        System.err.println("<primefile> = Output prime file");
        System.exit(1);
    }
}

