/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.DrawingItem;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.SolidOutline;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class OutlinedItem
extends DrawingItem
implements Externalizable {
    public static final Outline NORMAL_OUTLINE;
    private static final long serialVersionUID = -2644075901753850353L;
    Outline myOutline = theDefaultOutline;
    static Outline theDefaultOutline;

    public OutlinedItem() {
    }

    public OutlinedItem(OutlinedItem outlinedItem) {
        super(outlinedItem);
        this.myOutline = outlinedItem.myOutline;
    }

    public static Outline defaultOutline() {
        return theDefaultOutline;
    }

    public static void defaultOutline(Outline outline) {
        theDefaultOutline = outline;
    }

    public Outline outline() {
        return this.myOutline;
    }

    public OutlinedItem outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public OutlinedItem add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public OutlinedItem add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public OutlinedItem addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public OutlinedItem addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.myOutline);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myOutline = (Outline)objectInput.readObject();
    }

    void doOutline(Outline outline) {
        this.myOutline = outline;
    }

    static {
        theDefaultOutline = NORMAL_OUTLINE = SolidOutline.NORMAL_OUTLINE;
    }
}

