/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.monte;

import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.LongOp;
import edu.rit.util.LongRange;
import edu.rit.util.Random;

public class PiClu {
    static Comm world;
    static int size;
    static int rank;
    static long seed;
    static long N;
    static Random prng;
    static long count;

    private PiClu() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            PiClu.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        LongRange longRange = new LongRange(0L, N - 1L).subrange(size, rank);
        long l2 = longRange.length();
        prng = Random.getInstance(seed);
        prng.skip(2L * longRange.lb());
        count = 0L;
        for (long i = 0L; i < l2; ++i) {
            double d;
            double d2 = prng.nextDouble();
            if (!(d2 * d2 + (d = prng.nextDouble()) * d <= 1.0)) continue;
            ++count;
        }
        LongItemBuf longItemBuf = new LongItemBuf();
        longItemBuf.item = count;
        world.reduce(0, longItemBuf, LongOp.SUM);
        count = longItemBuf.item;
        System.out.println((l += System.currentTimeMillis()) + " msec total " + rank);
        if (rank == 0) {
            System.out.println("pi = 4 * " + count + " / " + N + " = " + 4.0 * (double)count / (double)N);
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.monte.PiClu <seed> <N>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

