/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.heat;

import edu.rit.image.ColorImageRow;
import edu.rit.image.PJGHueImage;
import edu.rit.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class HotSpotAnimation {
    private static final double MIN_TEMP = 0.0;
    private static final double MAX_TEMP = 100.0;
    private static final double DELTA_TEMP = 100.0;
    private static final double MIN_HUE = 0.6666666666666666;
    private static final double MAX_HUE = 0.0;
    private static final double DELTA_HUE = -0.6666666666666666;
    private static final double EPS = 0.001;
    static File imagefile;
    static int H;
    static int W;
    static double[][] h;
    static boolean[][] hotspot;
    static int[][] matrix;
    static PJGHueImage image;
    static BufferedImage bufimage;
    static double EPS_initialTotalAbsXi;
    static double totalAbsXi;
    static int MAXITER;
    static double rho_s_sqr;
    static double omega_over_4;
    static int iterations;

    private HotSpotAnimation() {
    }

    public static void main(String[] stringArray) throws Exception {
        boolean[] blArray;
        int n;
        int n2;
        if (stringArray.length < 8 || stringArray.length % 5 != 3) {
            HotSpotAnimation.usage();
        }
        imagefile = new File(stringArray[0]);
        H = Integer.parseInt(stringArray[1]);
        W = Integer.parseInt(stringArray[2]);
        if (H < 1) {
            HotSpotAnimation.usage();
        }
        if (W < 1) {
            HotSpotAnimation.usage();
        }
        h = new double[H + 2][W + 2];
        hotspot = new boolean[H + 2][W + 2];
        matrix = new int[H + 2][W + 2];
        image = new PJGHueImage(H + 2, W + 2, matrix);
        bufimage = image.getBufferedImage();
        int n3 = (stringArray.length - 3) / 5;
        for (int i = 0; i < n3; ++i) {
            int n4 = Integer.parseInt(stringArray[3 + 5 * i]);
            n2 = Integer.parseInt(stringArray[4 + 5 * i]);
            int n5 = Integer.parseInt(stringArray[5 + 5 * i]);
            int n6 = Integer.parseInt(stringArray[6 + 5 * i]);
            double d = Double.parseDouble(stringArray[7 + 5 * i]);
            if (1 > n4 || n4 > W) {
                HotSpotAnimation.usage();
            }
            if (1 > n2 || n2 > H) {
                HotSpotAnimation.usage();
            }
            if (1 > n5 || n5 > W) {
                HotSpotAnimation.usage();
            }
            if (1 > n6 || n6 > H) {
                HotSpotAnimation.usage();
            }
            if (0.0 > d || d > 100.0) {
                HotSpotAnimation.usage();
            }
            for (n = n4; n <= n5; ++n) {
                double[] dArray = h[n];
                boolean[] blArray2 = hotspot[n];
                for (int j = n2; j <= n6; ++j) {
                    dArray[j] = d;
                    blArray2[j] = true;
                }
            }
        }
        totalAbsXi = 0.0;
        for (n2 = 1; n2 <= H; ++n2) {
            double[] dArray = h[n2 - 1];
            double[] dArray2 = h[n2];
            double[] dArray3 = h[n2 + 1];
            blArray = hotspot[n2];
            for (n = 1; n <= W; ++n) {
                double d = blArray[n] ? 0.0 : dArray[n] + dArray3[n] + dArray2[n - 1] + dArray2[n + 1] - 4.0 * dArray2[n];
                totalAbsXi += Math.abs(d);
            }
        }
        EPS_initialTotalAbsXi = 0.001 * totalAbsXi;
        MAXITER = 2 * (W + H);
        rho_s_sqr = 0.5 * (Math.cos(Math.PI / (double)W) + Math.cos(Math.PI / (double)H));
        rho_s_sqr *= rho_s_sqr;
        omega_over_4 = 0.25;
        iterations = 0;
        HotSpotAnimation.writeGifFile();
        do {
            double[] dArray;
            double[] dArray4;
            double[] dArray5;
            totalAbsXi = 0.0;
            for (n2 = 1; n2 <= H; ++n2) {
                dArray5 = h[n2 - 1];
                dArray4 = h[n2];
                dArray = h[n2 + 1];
                blArray = hotspot[n2];
                for (n = 1 + (n2 & 1); n <= W; n += 2) {
                    double d = blArray[n] ? 0.0 : dArray5[n] + dArray[n] + dArray4[n - 1] + dArray4[n + 1] - 4.0 * dArray4[n];
                    totalAbsXi += Math.abs(d);
                    int n7 = n;
                    dArray4[n7] = dArray4[n7] + omega_over_4 * d;
                }
            }
            omega_over_4 = 0.25 / (1.0 - rho_s_sqr * (iterations == 0 ? 0.5 : omega_over_4));
            for (n2 = 1; n2 <= H; ++n2) {
                dArray5 = h[n2 - 1];
                dArray4 = h[n2];
                dArray = h[n2 + 1];
                blArray = hotspot[n2];
                for (n = 2 - (n2 & 1); n <= W; n += 2) {
                    double d = blArray[n] ? 0.0 : dArray5[n] + dArray[n] + dArray4[n - 1] + dArray4[n + 1] - 4.0 * dArray4[n];
                    totalAbsXi += Math.abs(d);
                    int n8 = n;
                    dArray4[n8] = dArray4[n8] + omega_over_4 * d;
                }
            }
            omega_over_4 = 0.25 / (1.0 - rho_s_sqr * omega_over_4);
            HotSpotAnimation.writeGifFile();
        } while (++iterations < MAXITER && totalAbsXi >= EPS_initialTotalAbsXi);
        if (iterations == MAXITER) {
            System.err.println("HotSpotAnimation: Did not converge");
            System.exit(1);
        }
        System.out.println(iterations + " iterations");
    }

    private static void writeGifFile() throws IOException {
        Object object;
        ColorImageRow colorImageRow = new ColorImageRow(matrix[0]);
        for (int i = 0; i <= H + 1; ++i) {
            object = h[i];
            colorImageRow.setArray(matrix[i]);
            for (int j = 0; j <= W + 1; ++j) {
                colorImageRow.setPixelHSB(j, (float)((object[j] - 0.0) / 100.0 * -0.6666666666666666 + 0.6666666666666666), 1.0f, 1.0f);
            }
        }
        String string = "" + iterations;
        while (string.length() < 4) {
            string = "0" + string;
        }
        object = Files.fileAppend(imagefile, string);
        System.out.printf("Writing %s%n", object);
        if (!ImageIO.write((RenderedImage)bufimage, "GIF", (File)object)) {
            throw new UnsupportedOperationException("HotSpotAnimation: Writing GIF image files not supported");
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.heat.HotSpotAnimation <imagefile> <H> <W> <rl1> <cl1> <ru1> <cu1> <temp1> [ <rl2> <cl2> <ru2> <cu2> <temp2> . . . ]");
        System.err.println("<imagefile> = Output image file name");
        System.err.println("<H> = Mesh height in pixels (<H> >= 1)");
        System.err.println("<W> = Mesh width in pixels (<W> >= 1)");
        System.err.println("<rl1> = First hot spot lower row (1 <= <rl1> <= <W>)");
        System.err.println("<cl1> = First hot spot lower column (1 <= <cl1> <= <H>)");
        System.err.println("<ru1> = First hot spot upper row (1 <= <ru1> <= <W>)");
        System.err.println("<cu1> = First hot spot upper column (1 <= <cu1> <= <H>)");
        System.err.println("<temp1> = First hot spot temperature (0.0 <= <temp1> <= 100.0)");
        System.exit(1);
    }
}

