## ----1------------------------------------------------------------------------
library(cleanUpdTSeq)
testFile <- system.file("extdata", "test.bed", package="cleanUpdTSeq")
testSet <- read.table(testFile, sep="\t", header=TRUE)
peaks <- BED2GRangesSeq(testSet, withSeq=FALSE)

## ----2------------------------------------------------------------------------
peaks <- BED2GRangesSeq(testSet, upstream.seq.ind=7, 
                          downstream.seq.ind=8, withSeq=TRUE)

## ----3------------------------------------------------------------------------
head(testSet)

## ----4------------------------------------------------------------------------
library(BSgenome.Drerio.UCSC.danRer7)
testSet.NaiveBayes <- buildFeatureVector(peaks, BSgenomeName=Drerio,
                                         upstream=40, downstream=30, 
                                         wordSize=6, alphabet=c("ACGT"),
                                         sampleType="unknown", 
                                         replaceNAdistance=30, 
                                         method="NaiveBayes",
                                         ZeroBasedIndex=1, fetchSeq=TRUE)

## ----5------------------------------------------------------------------------
data(data.NaiveBayes)
if(interactive()){
    predictTestSet(data.NaiveBayes$Negative, data.NaiveBayes$Positive, 
                   testSet.NaiveBayes=testSet.NaiveBayes, 
                   outputFile="test-predNaiveBayes.tsv", 
                   assignmentCutoff=0.5)
}

## ----6------------------------------------------------------------------------
data(classifier)
testResults <- predictTestSet(testSet.NaiveBayes=testSet.NaiveBayes,
                              classifier=classifier,
                              outputFile=NULL, 
                              assignmentCutoff=0.5)
head(testResults)

## ----sessionInfo, results='asis'----------------------------------------------
sessionInfo()

