## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
library(bigPint)
library(edgeR)
library(data.table)
library(dplyr)
library(DelayedArray)
library(SummarizedExperiment)

data(soybean_ir_sub)
data = soybean_ir_sub
rownames(data) = data[,1]

y = DGEList(counts=data[,-1])
group = c(1,1,1,2,2,2)
y = DGEList(counts=y, group=group)
Group = factor(c(rep("N",3), rep("P",3)))
design <- model.matrix(~0+Group, data=y$samples)
colnames(design) <- levels(Group)
y <- estimateDisp(y, design)
fit <- glmFit(y, design)

dataMetrics <- data.frame(ID = rownames(data))
for (i in 1:(ncol(fit)-1)){
    for (j in (i+1):ncol(fit)){
        contrast=rep(0,ncol(fit))
        contrast[i]=1
        contrast[j]=-1
        lrt <- glmLRT(fit, contrast=contrast)
        lrt <- topTags(lrt, n = nrow(y[[1]]))[[1]]
        
        setDT(lrt, keep.rownames = TRUE)[]
        lrt <- as.data.frame(lrt)
        colnames(lrt) <- paste0(colnames(fit)[i], "_", colnames(fit)[j], ".", colnames(lrt))
        colnames(lrt)[1] = "ID"
        
        reorderID <- full_join(data, lrt, by = "ID")
        dataMetrics <- cbind(dataMetrics, reorderID[,-c(1:ncol(data))])
    }
}

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
dataMetrics$ID <- as.character(dataMetrics$ID)
data = data[,-1]
data <- DelayedArray(data)
se_soybean_ir_sub <- SummarizedExperiment(assays = data, rowData = dataMetrics)
assay(se_soybean_ir_sub)
rowData(se_soybean_ir_sub)

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
data(soybean_cn_sub)
data = soybean_cn_sub
rownames(data) = data[,1]

y = DGEList(counts=data[,-1])
group = c(1,1,1,2,2,2,3,3,3)
y = DGEList(counts=y, group=group)
Group = factor(c(rep("S1",3), rep("S2",3), rep("S3",3)))
design <- model.matrix(~0+Group, data=y$samples)
colnames(design) <- levels(Group)
y <- estimateDisp(y, design)
fit <- glmFit(y, design)

dataMetrics <- data.frame(ID = rownames(data))
for (i in 1:(ncol(fit)-1)){
    for (j in (i+1):ncol(fit)){
        contrast=rep(0,ncol(fit))
        contrast[i]=1
        contrast[j]=-1
        lrt <- glmLRT(fit, contrast=contrast)
        lrt <- topTags(lrt, n = nrow(y[[1]]))[[1]]
        
        setDT(lrt, keep.rownames = TRUE)[]
        lrt <- as.data.frame(lrt)
        colnames(lrt) <- paste0(colnames(fit)[i], "_", colnames(fit)[j], ".", colnames(lrt))
        colnames(lrt)[1] = "ID"
        
        reorderID <- full_join(data, lrt, by = "ID")
        dataMetrics <- cbind(dataMetrics, reorderID[,-c(1:ncol(data))])
    }
}

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
dataMetrics$ID <- as.character(dataMetrics$ID)
data = data[,-1]
data <- DelayedArray(data)
se_soybean_cn_sub <- SummarizedExperiment(assays = data, rowData = dataMetrics)
assay(se_soybean_cn_sub)
rowData(se_soybean_cn_sub)

