tabItem(tabName = "tcgaOncoPrint",
        fluidRow(
            column(8,  bsAlert("oncomessage"),
                   bsCollapse(id = "collapseOnco", open = "Oncoprint",
                              bsCollapsePanel("Oncoprint",
                                              #busyIndicator("Rendering in progress...",wait = 10000),
                                              uiOutput("oncoPlot"), style = "default")
                   )),
            column(4,
                   box(title = "Oncoprint Plot",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = FALSE,
                       box(title = "Data",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = FALSE,
                           shinyFilesButton('maffile', 'Select MAF file', 'Please select a maf file',
                                            multiple = FALSE),
                           tags$br(),
                           tags$br(),
                           bsTooltip("mafAnnotation", "The object must have a column with the ID of patients. We look for one of the following columns: bcr_patient_barcode or patient","left"),
                           shinyFilesButton('mafAnnotation', 'Select annotation file', 'Please select a file with the annotation data frame ',
                                            multiple = FALSE),
                           useShinyjs(),
                           selectizeInput('mafAnnotationcols',
                                          "Annotation columns",
                                          choices = NULL,  multiple = TRUE),
                           selectizeInput('mafAnnotationpos',
                                          "Annotation position",
                                          choices = c("top","bottom"),selected = "top",  multiple = FALSE)
                       ),
                       box(title = "Gene selection",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           radioButtons("oncoInputRb", "Genes by:",
                                        c("Selection"="Selection",
                                          "Text"="text",
                                          "File"="file")),
                           bsTooltip("oncoGenesTextArea", "Genes separeted by (;), (,) or (new line)",
                                     "left"),
                           useShinyjs(),
                           inputTextarea('oncoGenesTextArea', '', 2, 30),
                           selectizeInput('oncoGenes',
                                          "genes",
                                          choices = NULL,  multiple = TRUE),
                           shinyFilesButton('oncoGenesFiles', 'Select file with genes', 'Please select a file with genes',  multiple = FALSE)
                       ),
                       box(title = "General parameters",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           selectizeInput('oncoInformation',
                                          "Information type",
                                          choices = c("Variant_Type","Variant_Classification"),  multiple = FALSE),
                           selectizeInput('oncoHeatmapLegendSide',
                                          "Heatmap legend side",
                                          choices = c("right","bottom"),  multiple = FALSE),
                           selectizeInput('oncoAnnotationLegendSide',
                                          "Annotation legend side",
                                          choices = c("right","bottom"),  multiple = FALSE),
                           bsTooltip("oncoRmCols", "If there is no alteration in that sample, whether remove it on the oncoprint",
                                     "left"),
                           checkboxInput("oncoRowSort", "Sort by frequency of alterations decreasingly?", value = FALSE, width = NULL),
                           checkboxInput("oncoRmCols", "Remove empty columns?", value = FALSE, width = NULL),
                           checkboxInput("oncoShowColsNames", "Show column names?", value = FALSE, width = NULL),
                           checkboxInput("oncoShowRowBarplot", "Show barplot annotation on rows?", value = TRUE, width = NULL),
                           numericInput("oncoWSpace", "Distance between columns",
                                        min = 0, max = 2, value = 0.5, step = 0.1),
                           numericInput("oncoHSpace", "Distance between rows",
                                        min = 0, max = 2, value = 0.5, step = 0.1)
                       ),
                       box(title = "Text parameters",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           numericInput("oncoTextRowSize", "Rows text size",
                                        min = 0, max = 20, value = 10.0, step = 1),
                           numericInput("oncoTextLabelSize", "Labels text Size",
                                        min = 0, max = 20, value = 10.0, step = 1)),
                       box(title = "Colors control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           colourpicker::colourInput("colBG", "Background color", value = "#CCCCCC"),
                           colourpicker::colourInput("colDEL", "DEL color", value = "red"),
                           colourpicker::colourInput("colINS", "INS color", value = "blue"),
                           colourpicker::colourInput("colSNP", "SNP color", value = "#008000"),
                           colourpicker::colourInput("colDNP", "DNP color", value = "purple"),
                           colourpicker::colourInput("colFSD", "Frame_Shift_Del color", value = "red"),
                           colourpicker::colourInput("colFSI", "Frame_Shift_Ins color", value = "blue"),
                           colourpicker::colourInput("colIFD", "In_Frame_Del color", value = "pink"),
                           colourpicker::colourInput("colIFI", "In_Frame_Ins color", value = "green"),
                           colourpicker::colourInput("colMM", "Missense_Mutation color", value = "black"),
                           colourpicker::colourInput("colNM", "Nonsense_Mutation color", value = "#A52A2A"),
                           colourpicker::colourInput("colNSM", "Nonstop_Mutation color", value = "#666699"),
                           colourpicker::colourInput("colRNA", "RNA color", value = "#336600"),
                           colourpicker::colourInput("colSIL", "Silent color", value = "#999900"),
                           colourpicker::colourInput("colSS", "Splice_Site color", value = "#e63900"),
                           colourpicker::colourInput("colTSS", "Translation_Start_Site color", value = "#669999"),
                           colourpicker::colourInput("colTR", "Targeted_Region color", value = "#99ccff")),
                       box(title = "Size control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           sliderInput("oncowidth", "Plot Width (%)", min = 0, max = 100, value = 100),
                           sliderInput("oncoheight", "Plot Height (px)", min = 0, max = 2000, value = 800)
                       ),

                       actionButton("oncoprintPlot",
                                    "Plot oncoprint",
                                    style = "background-color: #000080;
                                            color: #FFFFFF;
                                            margin-left: auto;
                                            margin-right: auto;
                                            width: 100%",
                                    icon = icon("picture-o")
                       ))
            )
        )
)
