## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager",
#                        quietly = TRUE)) {
#    install.packages("BiocManager")
#  }
#  BiocManager::install("SynExtend")

## -----------------------------------------------------------------------------
library(SynExtend)

DBPATH <- system.file("extdata",
                      "VignetteSeqs.sqlite",
                      package = "SynExtend")

# Alternatively, to build this same database using DECIPHER:
# DBPATH <- tempfile()
# FNAs <- c("ftp://ftp.ncbi.nlm.nih.gov/genomes/all/GCA/006/740/685/GCA_006740685.1_ASM674068v1/GCA_006740685.1_ASM674068v1_genomic.fna.gz",
#           "ftp://ftp.ncbi.nlm.nih.gov/genomes/all/GCA/000/956/175/GCA_000956175.1_ASM95617v1/GCA_000956175.1_ASM95617v1_genomic.fna.gz",
#           "ftp://ftp.ncbi.nlm.nih.gov/genomes/all/GCA/000/875/775/GCA_000875775.1_ASM87577v1/GCA_000875775.1_ASM87577v1_genomic.fna.gz")
# for (m1 in seq_along(FNAs)) {
#  X <- readDNAStringSet(filepath = FNAs[m1])
#  X <- X[order(width(X),
#               decreasing = TRUE)]
#  
#  Seqs2DB(seqs = X,
#          type = "XStringSet",
#          dbFile = DBPATH,
#          identifier = as.character(m1),
#          verbose = TRUE)
# }

Syn <- FindSynteny(dbFile = DBPATH)

## ----synplots01---------------------------------------------------------------
Syn
pairs(Syn)

## ----synplots02---------------------------------------------------------------
print(head(Syn[[1, 2]]))
print(head(Syn[[2, 1]]))

## -----------------------------------------------------------------------------
GeneCalls <- vector(mode = "list",
                    length = ncol(Syn))

GeneCalls[[1L]] <- gffToDataFrame(GFF = system.file("extdata",
                                                    "GCA_006740685.1_ASM674068v1_genomic.gff.gz",
                                                    package = "SynExtend"),
                                  Verbose = TRUE)
GeneCalls[[2L]] <- gffToDataFrame(GFF = system.file("extdata",
                                                    "GCA_000956175.1_ASM95617v1_genomic.gff.gz",
                                                    package = "SynExtend"),
                                  Verbose = TRUE)
GeneCalls[[3L]] <- gffToDataFrame(GFF = system.file("extdata",
                                                    "GCA_000875775.1_ASM87577v1_genomic.gff.gz",
                                                    package = "SynExtend"),
                                  Verbose = TRUE)

names(GeneCalls) <- seq(length(GeneCalls))

## ----print gene calls---------------------------------------------------------
print(head(GeneCalls[[1]]))

## ----show rtracklayer---------------------------------------------------------
X01 <- rtracklayer::import(system.file("extdata",
                                       "GCA_000875775.1_ASM87577v1_genomic.gff.gz",
                                       package = "SynExtend"))
class(X01)
print(X01)

## ----generate initial links---------------------------------------------------
Links <- NucleotideOverlap(SyntenyObject = Syn,
                           GeneCalls = GeneCalls,
                           LimitIndex = FALSE,
                           Verbose = TRUE)

## ----link printing------------------------------------------------------------
class(Links)
print(Links)

## ----describe links-----------------------------------------------------------
LinkedPairs1 <- PairSummaries(SyntenyLinks = Links,
                              GeneCalls = GeneCalls,
                              DBPATH = DBPATH,
                              PIDs = FALSE,
                              Verbose = TRUE,
                              Model = "Global",
                              Correction = "none")

## ----describe more links again------------------------------------------------
print(head(LinkedPairs1))

## -----------------------------------------------------------------------------
sessionInfo()

