df <- data.frame(
    Title = sprintf("DMAP RNA microarray %s", c("logcounts", "colData")), 
    Description = sprintf("%s 211 microarray samples of hematopoietic cells generated by Differentiation Map (GSE24759)", 
        c("Matrix of log-normalized expression values from", "Per-sample metadata containing cell type labels of")),
    RDataPath = file.path("SingleR", "dmap","1.0.0", c("logcounts.rds", "coldata.rds")),
    BiocVersion="3.10",
    Genome=NA, # Can be NA.
    SourceType="TXT", 
    SourceUrl="https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE24759",
    SourceVersion="GSE24759",
    Species="Homo sapiens",
    TaxonomyId="9606",
    Coordinate_1_based=NA,
    DataProvider="GEO",
    Maintainer="Jared Andrews <jared.andrews07@gmail.com>",
    RDataClass=c("matrix", "DataFrame"), 
    DispatchClass="Rds", 
    stringsAsFactors = FALSE
)

write.csv(file="../extdata/metadata-dmap.csv", df, row.names=FALSE)
