## ----install, eval = FALSE----------------------------------------------------
#  BiocManager::install(c("SBGNview"))

## ----installGage, eval = FALSE------------------------------------------------
#  BiocManager::install(c("gage"))

## ---- echo = TRUE, results = 'hide', message = FALSE, warning = FALSE---------
library(SBGNview)
library(SummarizedExperiment)
library(SBGNview.data)
data("IFNg")
count.data <- assays(IFNg)$counts
wt <- colnames(IFNg)[IFNg$group == "wt"]
ko <- colnames(IFNg)[IFNg$group == "ko"]
head(count.data)


## ---- echo = TRUE , results = 'hide',   message = FALSE, warning = FALSE------
ensemble.to.pathway <- getMolList(
    database = "pathwayCommons"
    ,mol.list.ID.type = "ENSEMBL"
    ,org = "mmu"
    ,cpd.or.gene = "gene"
    ,output.pathway.name = TRUE
)
head(ensemble.to.pathway[[2]])

## ---- echo = TRUE, results = 'hide', message = FALSE, warning = FALSE---------
library(gage)
degs <- gage(exprs = count.data
           ,gsets = ensemble.to.pathway
           ,ref = which(colnames(count.data) %in% wt)
           ,samp = which(colnames(count.data) %in% ko)
           ,compare = "as.group"
           )
head(degs$greater)[,c(1,4:5)]
head(degs$less)
down.pathways <- degs$less
head(down.pathways)

## ---- echo = TRUE, results = 'hide', message = FALSE, warning = FALSE---------
mean.wt <- apply(count.data[,wt] ,1 ,"mean")
head(mean.wt)
mean.ko <- apply(count.data[,ko],1,"mean")
head(mean.ko)
ensemble.to.koVsWt <- mean.ko - mean.wt
head(ensemble.to.koVsWt)

## ---- echo = TRUE, results = 'hide', message = FALSE, warning = FALSE---------

down.pathways <- do.call(rbind,strsplit(row.names(down.pathways),"::"))[,1]
head(down.pathways)
sbgnview.obj <- SBGNview(
    gene.data = ensemble.to.koVsWt,
    gene.id.type = "ENSEMBL",
    input.sbgn = down.pathways[1],
    output.file = "ifn.sbgnview.less",
    show.pathway.name = TRUE,
    max.gene.value = 2,
    min.gene.value = -2,
    mid.gene.value = 0,
    node.sum = "mean",
    label.spliting.string = c("-","_"," "), 
    output.format = c("png"),
    
    inhibition.edge.end.shift = 1,
    font.size = 2,
    logic.node.font.scale = 6,
    font.size.scale.compartment = 1.5,
    org = "mmu",
    
    text.length.factor.macromolecule = 0.8,
    text.length.factor.compartment = 2,
    text.length.factor.complex = 3,
    if.scale.compartment.font.size = TRUE,
    node.width.adjust.factor.compartment = 0.058 
)
sbgnview.obj

## ----ifnSBGNview, echo = FALSE,fig.cap="\\label{fig:SBGNview map from sbgnview}SBGNview"----
library(knitr)
include_graphics("ifn.sbgnview.less_R-HSA-877300_Interferon gamma signaling.svg")

## ---- eval=FALSE, echo = TRUE, results = 'hide', message = FALSE, warning = FALSE----
#  data("cancer.ds")
#  sbgnview.obj <- SBGNview(
#      gene.data = cancer.ds,
#      gene.id.type = "ENTREZID",
#      input.sbgn = "R-HSA-877300",
#      output.file = "demo.SummarizedExperiment",
#      show.pathway.name = TRUE,
#      max.gene.value = 1,
#      min.gene.value = -1,
#      mid.gene.value = 0,
#      node.sum = "mean",
#      label.spliting.string = c("-","_"," "),
#      output.format = c("png"),
#  
#      inhibition.edge.end.shift = 1,
#      font.size = 2,
#      logic.node.font.scale = 6,
#      font.size.scale.compartment = 1.5,
#      org = "hsa",
#  
#      text.length.factor.macromolecule = 0.8,
#      text.length.factor.compartment = 2,
#      text.length.factor.complex = 3,
#      if.scale.compartment.font.size = TRUE,
#      node.width.adjust.factor.compartment = 0.058
#     )
#  sbgnview.obj
#  

## ----cancerds,eval=FALSE, echo = FALSE,fig.cap="\\label{fig:cancerds}SBGNview of a cancer dataset gse16873"----
#  include_graphics("demo.SummarizedExperiment_R-HSA-877300_Interferon gamma signaling.svg")

## -----------------------------------------------------------------------------
sessionInfo()

