/*
 * Decompiled with CFR 0.152.
 */
package reder.application.cluster;

import java.util.Vector;
import reder.application.cluster.Centroid;
import reder.application.cluster.Cluster;
import reder.application.cluster.DataPoint;

public class JCA {
    private Cluster[] clusters;
    private int miter;
    private Vector mDataPoints = new Vector();
    private double mSWCSS;

    public JCA(int k, int iter, Vector dataPoints) {
        this.clusters = new Cluster[k];
        for (int i = 0; i < k; ++i) {
            this.clusters[i] = new Cluster("Cluster" + i);
        }
        this.miter = iter;
        this.mDataPoints = dataPoints;
    }

    private void calcSWCSS() {
        double temp = 0.0;
        for (int i = 0; i < this.clusters.length; ++i) {
            temp += this.clusters[i].getSumSqr();
        }
        this.mSWCSS = temp;
    }

    public void startAnalysis() {
        int i;
        this.setInitialCentroids();
        int n = 0;
        block0: while (true) {
            int l = 0;
            while (true) {
                if (l >= this.clusters.length) continue block0;
                this.clusters[l].addDataPoint((DataPoint)this.mDataPoints.elementAt(n));
                if (++n >= this.mDataPoints.size()) break block0;
                ++l;
            }
            break;
        }
        this.calcSWCSS();
        for (i = 0; i < this.clusters.length; ++i) {
            this.clusters[i].getCentroid().calcCentroid();
        }
        this.calcSWCSS();
        for (i = 0; i < this.miter; ++i) {
            for (int j = 0; j < this.clusters.length; ++j) {
                for (int k = 0; k < this.clusters[j].getNumDataPoints(); ++k) {
                    double tempEuDt = this.clusters[j].getDataPoint(k).getCurrentEuDt();
                    Cluster tempCluster = null;
                    boolean matchFoundFlag = false;
                    for (int l = 0; l < this.clusters.length; ++l) {
                        if (!(tempEuDt > this.clusters[j].getDataPoint(k).testEuclideanDistance(this.clusters[l].getCentroid()))) continue;
                        tempEuDt = this.clusters[j].getDataPoint(k).testEuclideanDistance(this.clusters[l].getCentroid());
                        tempCluster = this.clusters[l];
                        matchFoundFlag = true;
                    }
                    if (!matchFoundFlag) continue;
                    tempCluster.addDataPoint(this.clusters[j].getDataPoint(k));
                    this.clusters[j].removeDataPoint(this.clusters[j].getDataPoint(k));
                    for (int m = 0; m < this.clusters.length; ++m) {
                        this.clusters[m].getCentroid().calcCentroid();
                    }
                    this.calcSWCSS();
                }
            }
        }
    }

    public Vector[] getClusterOutput() {
        Vector[] v = new Vector[this.clusters.length];
        for (int i = 0; i < this.clusters.length; ++i) {
            v[i] = this.clusters[i].getDataPoints();
        }
        return v;
    }

    private void setInitialCentroids() {
        double cx = 0.0;
        double cy = 0.0;
        for (int n = 1; n <= this.clusters.length; ++n) {
            cx = (this.getMaxXValue() - this.getMinXValue()) / (double)(this.clusters.length + 1) * (double)n + this.getMinXValue();
            cy = (this.getMaxYValue() - this.getMinYValue()) / (double)(this.clusters.length + 1) * (double)n + this.getMinYValue();
            Centroid c1 = new Centroid(cx, cy);
            this.clusters[n - 1].setCentroid(c1);
            c1.setCluster(this.clusters[n - 1]);
        }
    }

    private double getMaxXValue() {
        double temp = ((DataPoint)this.mDataPoints.elementAt(0)).getX();
        for (int i = 0; i < this.mDataPoints.size(); ++i) {
            DataPoint dp = (DataPoint)this.mDataPoints.elementAt(i);
            temp = dp.getX() > temp ? dp.getX() : temp;
        }
        return temp;
    }

    private double getMinXValue() {
        double temp = 0.0;
        temp = ((DataPoint)this.mDataPoints.elementAt(0)).getX();
        for (int i = 0; i < this.mDataPoints.size(); ++i) {
            DataPoint dp = (DataPoint)this.mDataPoints.elementAt(i);
            temp = dp.getX() < temp ? dp.getX() : temp;
        }
        return temp;
    }

    private double getMaxYValue() {
        double temp = 0.0;
        temp = ((DataPoint)this.mDataPoints.elementAt(0)).getY();
        for (int i = 0; i < this.mDataPoints.size(); ++i) {
            DataPoint dp = (DataPoint)this.mDataPoints.elementAt(i);
            temp = dp.getY() > temp ? dp.getY() : temp;
        }
        return temp;
    }

    private double getMinYValue() {
        double temp = 0.0;
        temp = ((DataPoint)this.mDataPoints.elementAt(0)).getY();
        for (int i = 0; i < this.mDataPoints.size(); ++i) {
            DataPoint dp = (DataPoint)this.mDataPoints.elementAt(i);
            temp = dp.getY() < temp ? dp.getY() : temp;
        }
        return temp;
    }

    public int getKValue() {
        return this.clusters.length;
    }

    public int getIterations() {
        return this.miter;
    }

    public int getTotalDataPoints() {
        return this.mDataPoints.size();
    }

    public double getSWCSS() {
        return this.mSWCSS;
    }
}

