/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraphView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class mxGraphOutline
extends JComponent {
    private static final long serialVersionUID = -2521103946905154267L;
    public static Color DEFAULT_ZOOMHANDLE_FILL = new Color(0, 255, 255);
    protected mxGraphComponent graphComponent;
    protected BufferedImage tripleBuffer;
    protected Graphics2D tripleBufferGraphics;
    protected boolean repaintBuffer = false;
    protected mxRectangle repaintClip = null;
    protected boolean tripleBuffered = true;
    protected Rectangle finderBounds = new Rectangle();
    protected Point zoomHandleLocation = null;
    protected boolean finderVisible = true;
    protected boolean zoomHandleVisible = true;
    protected boolean useScaledInstance = false;
    protected boolean antiAlias = false;
    protected boolean drawLabels = false;
    protected boolean fitPage = true;
    protected int outlineBorder = 10;
    protected MouseTracker tracker = new MouseTracker();
    protected double scale = 1.0;
    protected Point translate = new Point();
    protected transient boolean zoomGesture = false;
    protected mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxGraphOutline.this.updateScaleAndTranslate();
            mxRectangle mxRectangle2 = (mxRectangle)mxEventObject2.getProperty("region");
            if (mxRectangle2 != null) {
                mxGraphOutline.this.repaintClip = new mxRectangle(mxRectangle2);
            } else {
                mxGraphOutline.this.repaintBuffer = true;
            }
            if (mxRectangle2 != null) {
                mxGraphOutline.this.updateFinder(true);
                mxRectangle2.grow(1.0 / mxGraphOutline.this.scale);
                mxRectangle2.setX(mxRectangle2.getX() * mxGraphOutline.this.scale + (double)mxGraphOutline.this.translate.x);
                mxRectangle2.setY(mxRectangle2.getY() * mxGraphOutline.this.scale + (double)mxGraphOutline.this.translate.y);
                mxRectangle2.setWidth(mxRectangle2.getWidth() * mxGraphOutline.this.scale);
                mxRectangle2.setHeight(mxRectangle2.getHeight() * mxGraphOutline.this.scale);
                mxGraphOutline.this.repaint(mxRectangle2.getRectangle());
            } else {
                mxGraphOutline.this.updateFinder(false);
                mxGraphOutline.this.repaint();
            }
        }
    };
    protected ComponentListener componentHandler = new ComponentAdapter(){

        public void componentResized(ComponentEvent componentEvent) {
            if (mxGraphOutline.this.updateScaleAndTranslate()) {
                mxGraphOutline.this.repaintBuffer = true;
                mxGraphOutline.this.updateFinder(false);
                mxGraphOutline.this.repaint();
            } else {
                mxGraphOutline.this.updateFinder(true);
            }
        }
    };
    protected AdjustmentListener adjustmentHandler = new AdjustmentListener(){

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (mxGraphOutline.this.updateScaleAndTranslate()) {
                mxGraphOutline.this.repaintBuffer = true;
                mxGraphOutline.this.updateFinder(false);
                mxGraphOutline.this.repaint();
            } else {
                mxGraphOutline.this.updateFinder(true);
            }
        }
    };

    public mxGraphOutline(mxGraphComponent mxGraphComponent2) {
        this.addComponentListener(this.componentHandler);
        this.addMouseMotionListener(this.tracker);
        this.addMouseListener(this.tracker);
        this.setGraphComponent(mxGraphComponent2);
        this.setEnabled(true);
        this.setOpaque(true);
    }

    public void setTripleBuffered(boolean bl) {
        boolean bl2 = this.tripleBuffered;
        this.tripleBuffered = bl;
        if (!bl) {
            this.destroyTripleBuffer();
        }
        this.firePropertyChange("tripleBuffered", bl2, bl);
    }

    public boolean isTripleBuffered() {
        return this.tripleBuffered;
    }

    public void setDrawLabels(boolean bl) {
        boolean bl2 = this.drawLabels;
        this.drawLabels = bl;
        this.repaintTripleBuffer(null);
        this.firePropertyChange("drawLabels", bl2, bl);
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    public void setAntiAlias(boolean bl) {
        boolean bl2 = this.antiAlias;
        this.antiAlias = bl;
        this.repaintTripleBuffer(null);
        this.firePropertyChange("antiAlias", bl2, bl);
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.destroyTripleBuffer();
        }
    }

    public void setFinderVisible(boolean bl) {
        this.finderVisible = bl;
    }

    public void setZoomHandleVisible(boolean bl) {
        this.zoomHandleVisible = bl;
    }

    public void setFitPage(boolean bl) {
        boolean bl2 = this.fitPage;
        this.fitPage = bl;
        if (this.updateScaleAndTranslate()) {
            this.repaintBuffer = true;
            this.updateFinder(false);
        }
        this.firePropertyChange("fitPage", bl2, bl);
    }

    public boolean isFitPage() {
        return this.fitPage;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public void setGraphComponent(mxGraphComponent mxGraphComponent2) {
        mxGraphComponent mxGraphComponent3 = this.graphComponent;
        if (this.graphComponent != null) {
            this.graphComponent.getGraph().removeListener(this.repaintHandler);
            this.graphComponent.getGraphControl().removeComponentListener(this.componentHandler);
            this.graphComponent.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentHandler);
            this.graphComponent.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentHandler);
        }
        this.graphComponent = mxGraphComponent2;
        if (this.graphComponent != null) {
            this.graphComponent.getGraph().addListener("repaint", this.repaintHandler);
            this.graphComponent.getGraphControl().addComponentListener(this.componentHandler);
            this.graphComponent.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentHandler);
            this.graphComponent.getVerticalScrollBar().addAdjustmentListener(this.adjustmentHandler);
        }
        if (this.updateScaleAndTranslate()) {
            this.repaintBuffer = true;
            this.repaint();
        }
        this.firePropertyChange("graphComponent", mxGraphComponent3, mxGraphComponent2);
    }

    public void checkTripleBuffer() {
        if (this.tripleBuffer != null && (this.tripleBuffer.getWidth() != this.getWidth() || this.tripleBuffer.getHeight() != this.getHeight())) {
            this.destroyTripleBuffer();
        }
        if (this.tripleBuffer == null) {
            this.createTripleBuffer(this.getWidth(), this.getHeight());
        }
    }

    protected void createTripleBuffer(int n, int n2) {
        try {
            this.tripleBuffer = mxUtils.createBufferedImage(n, n2, null);
            this.tripleBufferGraphics = this.tripleBuffer.createGraphics();
            this.repaintTripleBuffer(null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void destroyTripleBuffer() {
        if (this.tripleBuffer != null) {
            this.tripleBuffer = null;
            this.tripleBufferGraphics.dispose();
            this.tripleBufferGraphics = null;
        }
    }

    public void repaintTripleBuffer(Rectangle rectangle) {
        if (this.tripleBuffered && this.tripleBufferGraphics != null) {
            if (rectangle == null) {
                rectangle = new Rectangle(this.tripleBuffer.getWidth(), this.tripleBuffer.getHeight());
            }
            mxUtils.clearRect(this.tripleBufferGraphics, rectangle, null);
            this.tripleBufferGraphics.setClip(rectangle);
            this.paintGraph(this.tripleBufferGraphics);
            this.tripleBufferGraphics.setClip(null);
            this.repaintBuffer = false;
            this.repaintClip = null;
        }
    }

    public void updateFinder(boolean bl) {
        Rectangle rectangle = this.graphComponent.getViewport().getViewRect();
        int n = (int)Math.round((double)rectangle.x * this.scale);
        int n2 = (int)Math.round((double)rectangle.y * this.scale);
        int n3 = (int)Math.round((double)(rectangle.x + rectangle.width) * this.scale) - n;
        int n4 = (int)Math.round((double)(rectangle.y + rectangle.height) * this.scale) - n2;
        this.updateFinderBounds(new Rectangle(n + this.translate.x, n2 + this.translate.y, n3 + 1, n4 + 1), bl);
    }

    public void updateFinderBounds(Rectangle rectangle, boolean bl) {
        if (rectangle != null && !rectangle.equals(this.finderBounds)) {
            Rectangle rectangle2 = new Rectangle(this.finderBounds);
            this.finderBounds = rectangle;
            if (bl) {
                rectangle2 = rectangle2.union(this.finderBounds);
                rectangle2.grow(3, 3);
                this.repaint(rectangle2);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintBackground(graphics);
        if (this.graphComponent != null) {
            if (this.tripleBuffered) {
                this.checkTripleBuffer();
            } else if (this.tripleBuffer != null) {
                this.destroyTripleBuffer();
            }
            if (this.tripleBuffer != null) {
                if (this.repaintBuffer) {
                    this.repaintTripleBuffer(null);
                } else if (this.repaintClip != null) {
                    this.repaintClip.grow(1.0 / this.scale);
                    this.repaintClip.setX(this.repaintClip.getX() * this.scale + (double)this.translate.x);
                    this.repaintClip.setY(this.repaintClip.getY() * this.scale + (double)this.translate.y);
                    this.repaintClip.setWidth(this.repaintClip.getWidth() * this.scale);
                    this.repaintClip.setHeight(this.repaintClip.getHeight() * this.scale);
                    this.repaintTripleBuffer(this.repaintClip.getRectangle());
                }
                mxUtils.drawImageClip(graphics, this.tripleBuffer, this);
            } else {
                this.paintGraph(graphics);
            }
            this.paintForeground(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBackground(Graphics graphics) {
        if (this.graphComponent != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            try {
                graphics.setColor(this.graphComponent.getPageBackgroundColor());
                mxUtils.fillClippedRect(graphics, 0, 0, this.getWidth(), this.getHeight());
                graphics2D.translate(this.translate.x, this.translate.y);
                graphics2D.scale(this.scale, this.scale);
                if (!this.graphComponent.isPageVisible()) {
                    graphics.setColor(this.graphComponent.getBackground());
                    Dimension dimension = this.graphComponent.getGraphControl().getSize();
                    mxUtils.fillClippedRect(graphics, 0, 0, dimension.width, dimension.height);
                    graphics.setColor(graphics.getColor().darker().darker());
                    graphics.drawRect(0, 0, dimension.width, dimension.height);
                }
                this.graphComponent.paintBackgroundPage(graphics);
            }
            finally {
                graphics2D.setTransform(affineTransform);
            }
        } else {
            graphics.setColor(this.getBackground());
            mxUtils.fillClippedRect(graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGraph(Graphics graphics) {
        if (this.graphComponent != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            try {
                graphics2D.translate(this.translate.x, this.translate.y);
                graphics2D.scale(this.scale, this.scale);
                this.graphComponent.paintGraph(graphics2D, this.drawLabels);
            }
            finally {
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    protected void paintForeground(Graphics graphics) {
        if (this.graphComponent != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics.setColor(Color.BLUE);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics.drawRect(this.finderBounds.x, this.finderBounds.y, this.finderBounds.width, this.finderBounds.height);
            graphics2D.setStroke(stroke);
            graphics.setColor(DEFAULT_ZOOMHANDLE_FILL);
            graphics.fillRect(this.finderBounds.x + this.finderBounds.width - 6, this.finderBounds.y + this.finderBounds.height - 6, 8, 8);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(this.finderBounds.x + this.finderBounds.width - 6, this.finderBounds.y + this.finderBounds.height - 6, 8, 8);
        }
    }

    public boolean updateScaleAndTranslate() {
        double d = 1.0;
        int n = 0;
        int n2 = 0;
        if (this.graphComponent != null) {
            Dimension dimension = this.graphComponent.getGraphControl().getSize();
            Dimension dimension2 = this.getSize();
            int n3 = (int)dimension.getWidth();
            int n4 = (int)dimension.getHeight();
            if (n3 > 0 && n4 > 0) {
                boolean bl = this.graphComponent.isPageVisible() && this.isFitPage() && this.graphComponent.getHorizontalScrollBar().isVisible() && this.graphComponent.getVerticalScrollBar().isVisible();
                double d2 = this.graphComponent.getGraph().getView().getScale();
                mxPoint mxPoint2 = this.graphComponent.getGraph().getView().getTranslate();
                int n5 = (int)dimension2.getWidth() - 2 * this.outlineBorder;
                int n6 = (int)dimension2.getHeight() - 2 * this.outlineBorder;
                if (bl) {
                    n3 = (int)((long)n3 - 2L * Math.round(mxPoint2.getX() * d2));
                    n4 = (int)((long)n4 - 2L * Math.round(mxPoint2.getY() * d2));
                }
                d = Math.min((double)n5 / (double)n3, (double)n6 / (double)n4);
                n += (int)Math.round((dimension2.getWidth() - (double)n3 * d) / 2.0);
                n2 += (int)Math.round((dimension2.getHeight() - (double)n4 * d) / 2.0);
                if (bl) {
                    n = (int)((long)n - Math.round(mxPoint2.getX() * d * d2));
                    n2 = (int)((long)n2 - Math.round(mxPoint2.getY() * d * d2));
                }
            }
        }
        if (d != this.scale || this.translate.x != n || this.translate.y != n2) {
            this.scale = d;
            this.translate.setLocation(n, n2);
            return true;
        }
        return false;
    }

    public class MouseTracker
    implements MouseListener,
    MouseMotionListener {
        protected Point start = null;

        public void mousePressed(MouseEvent mouseEvent) {
            mxGraphOutline.this.zoomGesture = this.hitZoomHandle(mouseEvent.getX(), mouseEvent.getY());
            if (mxGraphOutline.this.graphComponent != null && !mouseEvent.isConsumed() && !mouseEvent.isPopupTrigger() && (mxGraphOutline.this.finderBounds.contains(mouseEvent.getPoint()) || mxGraphOutline.this.zoomGesture)) {
                this.start = mouseEvent.getPoint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mxGraphOutline.this.isEnabled() && this.start != null) {
                if (mxGraphOutline.this.zoomGesture) {
                    Rectangle rectangle = mxGraphOutline.this.graphComponent.getViewport().getViewRect();
                    double d = rectangle.getWidth() / rectangle.getHeight();
                    rectangle = new Rectangle(mxGraphOutline.this.finderBounds);
                    rectangle.width = (int)Math.max(0.0, (double)mouseEvent.getX() - rectangle.getX());
                    rectangle.height = (int)Math.max(0.0, rectangle.getWidth() / d);
                    mxGraphOutline.this.updateFinderBounds(rectangle, true);
                } else {
                    int n = (int)(((double)mouseEvent.getX() - this.start.getX()) / mxGraphOutline.this.scale);
                    int n2 = (int)(((double)mouseEvent.getY() - this.start.getY()) / mxGraphOutline.this.scale);
                    this.start = mouseEvent.getPoint();
                    mxGraphOutline.this.graphComponent.getHorizontalScrollBar().setValue(mxGraphOutline.this.graphComponent.getHorizontalScrollBar().getValue() + n);
                    mxGraphOutline.this.graphComponent.getVerticalScrollBar().setValue(mxGraphOutline.this.graphComponent.getVerticalScrollBar().getValue() + n2);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.start != null) {
                if (mxGraphOutline.this.zoomGesture) {
                    double d = (double)mouseEvent.getX() - this.start.getX();
                    double d2 = mxGraphOutline.this.finderBounds.getWidth();
                    JScrollBar jScrollBar = mxGraphOutline.this.graphComponent.getHorizontalScrollBar();
                    double d3 = jScrollBar != null ? (double)jScrollBar.getValue() / (double)jScrollBar.getMaximum() : 0.0;
                    JScrollBar jScrollBar2 = mxGraphOutline.this.graphComponent.getVerticalScrollBar();
                    double d4 = jScrollBar2 != null ? (double)jScrollBar2.getValue() / (double)jScrollBar2.getMaximum() : 0.0;
                    mxGraphView mxGraphView2 = mxGraphOutline.this.graphComponent.getGraph().getView();
                    double d5 = mxGraphView2.getScale();
                    double d6 = d5 - d * d5 / d2;
                    double d7 = d6 / d5;
                    mxGraphView2.setScale(d6);
                    if (jScrollBar != null) {
                        jScrollBar.setValue((int)(d3 * (double)jScrollBar.getMaximum() * d7));
                    }
                    if (jScrollBar2 != null) {
                        jScrollBar2.setValue((int)(d4 * (double)jScrollBar2.getMaximum() * d7));
                    }
                }
                mxGraphOutline.this.zoomGesture = false;
                this.start = null;
            }
        }

        public boolean hitZoomHandle(int n, int n2) {
            return new Rectangle(mxGraphOutline.this.finderBounds.x + mxGraphOutline.this.finderBounds.width - 6, mxGraphOutline.this.finderBounds.y + mxGraphOutline.this.finderBounds.height - 6, 8, 8).contains(n, n2);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.hitZoomHandle(mouseEvent.getX(), mouseEvent.getY())) {
                mxGraphOutline.this.setCursor(new Cursor(12));
            } else if (mxGraphOutline.this.finderBounds.contains(mouseEvent.getPoint())) {
                mxGraphOutline.this.setCursor(new Cursor(13));
            } else {
                mxGraphOutline.this.setCursor(new Cursor(0));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

