## ----style, echo=FALSE, results="asis", message=FALSE-------------------------
knitr::opts_chunk$set(tidy = FALSE,
                      warning = FALSE,
                      message = FALSE)

## ----echo=FALSE, results='hide', message=FALSE--------------------------------
CRANpkg <- function (pkg) {
    cran <- "https://CRAN.R-project.org/package"
    fmt <- "[%s](%s=%s)"
    sprintf(fmt, pkg, cran, pkg)
}

Biocpkg <- function (pkg) {
    sprintf("[%s](http://bioconductor.org/packages/%s)", pkg, pkg)
}

library(org.Hs.eg.db)
library(DOSE)
library(ReactomePA)

## -----------------------------------------------------------------------------
library(ReactomePA)
data(geneList)
de <- names(geneList)[abs(geneList) > 1.5]
head(de)
x <- enrichPathway(gene=de,pvalueCutoff=0.05, readable=T)
head(as.data.frame(x))

## ----fig.height=6, fig.width=12-----------------------------------------------
barplot(x, showCategory=8)

## ----fig.height=6, fig.width=12-----------------------------------------------
dotplot(x, showCategory=15)

## ----fig.height=10, fig.width=10----------------------------------------------
emapplot(x)

## ----fig.height=8, fig.width=8------------------------------------------------
cnetplot(x, categorySize="pvalue", foldChange=geneList)

## ----fig.height=8, fig.width=13, eval=FALSE-----------------------------------
#  require(clusterProfiler)
#  data(gcSample)
#  res <- compareCluster(gcSample, fun="enrichPathway")
#  dotplot(res)

## -----------------------------------------------------------------------------
y <- gsePathway(geneList, nPerm=10000,
                pvalueCutoff=0.2,
                pAdjustMethod="BH", verbose=FALSE)
res <- as.data.frame(y)
head(res)

## ----fig.height=8, fig.width=8------------------------------------------------
emapplot(y, color="pvalue")

## ----fig.height=7, fig.width=10-----------------------------------------------
gseaplot(y, geneSetID = "R-HSA-69242")

## ----fig.height=8, fig.width=8------------------------------------------------
viewPathway("E2F mediated regulation of DNA replication", readable=TRUE, foldChange=geneList)

