/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.Iterator;
import java.util.List;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceView;
import org.biojava3.core.util.Equals;
import org.biojava3.core.util.Hashcoder;

public class SingleCompoundSequenceReader<C extends Compound>
implements ProxySequenceReader<C> {
    private final C compound;
    private final CompoundSet<C> compoundSet;
    private final int length;

    public SingleCompoundSequenceReader(String compound, CompoundSet<C> compoundSet, int length) {
        this(compoundSet.getCompoundForString(compound), compoundSet, length);
    }

    public SingleCompoundSequenceReader(C compound, CompoundSet<C> compoundSet, int length) {
        this.compound = compound;
        this.compoundSet = compoundSet;
        this.length = length;
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setContents(String sequence) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public C getCompoundAt(int position) {
        return this.compound;
    }

    @Override
    public int getIndexOf(C compound) {
        if (compound.equals(this.compound)) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        if (compound.equals(this.compound)) {
            return this.getLength();
        }
        return -1;
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toString(this);
    }

    @Override
    public List<C> getAsList() {
        return SequenceMixin.toList(this);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer start, Integer end) {
        return new SequenceProxyView(this, start, end);
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public AccessionID getAccession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public Iterator<C> iterator() {
        return new SequenceMixin.SequenceIterator(this);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }

    public int hashCode() {
        int s = 9;
        s = Hashcoder.hash(s, this.compound);
        s = Hashcoder.hash(s, this.length);
        s = Hashcoder.hash(s, this.compoundSet);
        return s;
    }

    public boolean equals(Object o) {
        if (Equals.classEqual(this, o)) {
            SingleCompoundSequenceReader that = (SingleCompoundSequenceReader)o;
            return Equals.equal(this.compound, that.compound) && Equals.equal(this.compoundSet, that.compoundSet) && Equals.equal(this.length, that.length);
        }
        return false;
    }
}

