/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;

public class AminoAcidPattern
extends ExperimentObject
implements TagComponent {
    static final long serialVersionUID = -2823716418631089876L;
    private Integer target = 0;
    private int length = -1;
    private HashMap<Integer, ArrayList<Character>> residueTargeted = null;
    private HashMap<Integer, ArrayList<AminoAcid>> aaTargeted = null;
    private HashMap<Integer, ArrayList<AminoAcid>> aaExcluded = null;
    private HashMap<Integer, ArrayList<ModificationMatch>> targetModifications = null;

    public AminoAcidPattern() {
    }

    public AminoAcidPattern(String sequence) {
        this.residueTargeted = new HashMap(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char letter = sequence.charAt(i);
            ArrayList<Character> list = new ArrayList<Character>(1);
            list.add(Character.valueOf(letter));
            this.residueTargeted.put(i, list);
        }
        this.length = sequence.length();
    }

    public AminoAcidPattern(AminoAcidSequence aminoAcidSequence) {
        String sequence = aminoAcidSequence.getSequence();
        this.residueTargeted = new HashMap(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char letter = sequence.charAt(i);
            ArrayList<Character> list = new ArrayList<Character>(1);
            list.add(Character.valueOf(letter));
            this.residueTargeted.put(i, list);
        }
        this.length = sequence.length();
        this.targetModifications = aminoAcidSequence.getModificationMatches();
    }

    public AminoAcidPattern(AminoAcidPattern aminoAcidPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<AminoAcid>> otherExcluded;
        this.target = aminoAcidPattern.getTarget();
        HashMap<Integer, ArrayList<Character>> otherTargets = aminoAcidPattern.getAaTargeted();
        if (otherTargets != null) {
            this.residueTargeted = new HashMap(otherTargets.size());
            for (int index : otherTargets.keySet()) {
                this.residueTargeted.put(index, (ArrayList)otherTargets.get(index).clone());
            }
        }
        if ((otherExcluded = aminoAcidPattern.getAaExcluded()) != null) {
            for (int index : otherExcluded.keySet()) {
                ArrayList<AminoAcid> aasAtExclusion = otherExcluded.get(index);
                ArrayList<Character> chars = new ArrayList<Character>(aasAtExclusion.size());
                for (AminoAcid aminoAcid : aasAtExclusion) {
                    chars.add(Character.valueOf(aminoAcid.getSingleLetterCodeAsChar()));
                }
                this.setExcluded(index, chars);
            }
        }
        if ((modificationMatches = aminoAcidPattern.getModificationMatches()) != null) {
            this.targetModifications = new HashMap(modificationMatches.size());
            for (int index : modificationMatches.keySet()) {
                this.targetModifications.put(index, (ArrayList)modificationMatches.get(index).clone());
            }
        }
    }

    public HashMap<Integer, ArrayList<Character>> getAaTargeted() {
        return this.residueTargeted;
    }

    public HashMap<Integer, ArrayList<AminoAcid>> getAaExcluded() {
        return this.aaExcluded;
    }

    public AminoAcidPattern(ArrayList<String> targetTesidues) throws IllegalArgumentException {
        ArrayList<Character> aminoAcids = new ArrayList<Character>(targetTesidues.size());
        for (String letter : targetTesidues) {
            aminoAcids.add(Character.valueOf(letter.charAt(0)));
        }
        this.residueTargeted = new HashMap(1);
        this.residueTargeted.put(0, aminoAcids);
        this.length = 1;
    }

    public void swapRows(int fromRow, int toRow) throws IllegalArgumentException {
        if (this.residueTargeted.size() < fromRow || fromRow < 0 || toRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + fromRow);
        }
        if (this.residueTargeted.size() < toRow || toRow < 0 || fromRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + toRow);
        }
        ArrayList<Character> toRowDataTarget = this.residueTargeted.get(toRow);
        this.residueTargeted.put(toRow, this.residueTargeted.get(fromRow));
        this.residueTargeted.put(fromRow, toRowDataTarget);
        if (this.target == fromRow) {
            this.target = toRow;
        } else if (this.target == toRow) {
            this.target = fromRow;
        }
    }

    public Integer getTarget() {
        return this.target;
    }

    public void setTarget(Integer target) {
        this.target = target;
    }

    public ArrayList<Character> getAminoAcidsAtTarget() {
        return this.getTargetedAA(this.target);
    }

    public void setTargeted(int index, ArrayList<Character> targets) {
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
            this.residueTargeted = new HashMap(1);
        }
        this.residueTargeted.put(index, targets);
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
    }

    public void setExcluded(int index, ArrayList<Character> exceptions) {
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
            this.residueTargeted = new HashMap(1);
        }
        if (exceptions == null || exceptions.isEmpty()) {
            this.residueTargeted.put(index, new ArrayList());
        } else {
            ArrayList<Character> notExcluded = new ArrayList<Character>();
            ArrayList<Character> targeted = this.residueTargeted.get(index);
            if (targeted == null || targeted.isEmpty()) {
                for (char aa : AminoAcid.getUniqueAminoAcids()) {
                    if (exceptions.contains(Character.valueOf(aa))) continue;
                    notExcluded.add(Character.valueOf(aa));
                }
            } else {
                for (Character aminoAcid : targeted) {
                    if (exceptions.contains(aminoAcid)) continue;
                    notExcluded.add(aminoAcid);
                }
            }
            this.residueTargeted.put(index, notExcluded);
        }
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
    }

    public ArrayList<Character> getTargetedAA(int index) {
        ArrayList<Character> result;
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
        }
        if (this.residueTargeted != null && (result = this.residueTargeted.get(index)) != null) {
            return result;
        }
        return new ArrayList<Character>(0);
    }

    public int getNTargetedAA(int index) {
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
        }
        if (this.residueTargeted == null) {
            return 0;
        }
        ArrayList<Character> aas = this.getTargetedAA(index);
        return aas.size();
    }

    public void removeAA(int index) {
        ArrayList<Integer> indexes;
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
        }
        if (this.residueTargeted != null) {
            indexes = new ArrayList<Integer>(this.residueTargeted.keySet());
            Collections.sort(indexes);
            for (int aa : indexes) {
                if (aa < index) continue;
                if (aa > index) {
                    this.residueTargeted.put(aa - 1, this.residueTargeted.get(aa));
                }
                this.residueTargeted.remove(aa);
            }
        }
        if (this.targetModifications != null) {
            indexes = new ArrayList<Integer>(this.targetModifications.keySet());
            Collections.sort(indexes);
            int ptmIndex = index + 1;
            for (int aa : indexes) {
                if (aa < ptmIndex || aa <= ptmIndex) continue;
                this.targetModifications.put(aa - 1, this.targetModifications.get(aa));
            }
        }
        this.length = -1;
    }

    public Pattern getAsStringPattern(SequenceMatchingPreferences sequenceMatchingPreferences, boolean includeMutations) {
        SequenceMatchingPreferences.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
        int tempLength = this.length();
        StringBuilder regexBuilder = new StringBuilder(tempLength);
        for (int i = 0; i < tempLength; ++i) {
            ArrayList<Character> toAdd = new ArrayList<Character>(1);
            if (this.residueTargeted == null) {
                this.backwardCompatibilityCheck();
            }
            if (this.residueTargeted != null) {
                Object object;
                ArrayList<Character> tempTarget = this.residueTargeted.get(i);
                if (tempTarget == null || tempTarget.isEmpty()) {
                    toAdd.ensureCapacity(AminoAcid.getUniqueAminoAcids().length);
                    object = AminoAcid.getUniqueAminoAcids();
                    int n = ((Object)object).length;
                    for (int j = 0; j < n; ++j) {
                        Iterator<Character> aa = Character.valueOf((char)object[j]);
                        toAdd.add((Character)((Object)aa));
                    }
                } else {
                    object = tempTarget.iterator();
                    while (object.hasNext()) {
                        char aa = ((Character)object.next()).charValue();
                        if (!toAdd.contains(Character.valueOf(aa))) {
                            toAdd.add(Character.valueOf(aa));
                        }
                        if (matchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
                        for (Object tempAa : (Iterator<Character>)aminoAcid.getSubAminoAcids()) {
                            if (toAdd.contains(Character.valueOf((char)tempAa))) continue;
                            toAdd.add(Character.valueOf((char)tempAa));
                        }
                        for (Object tempAa : (Iterator<Character>)aminoAcid.getCombinations()) {
                            if (toAdd.contains(Character.valueOf((char)tempAa))) continue;
                            toAdd.add(Character.valueOf((char)tempAa));
                        }
                        if (matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                        for (char tempAa : aminoAcid.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance())) {
                            if (toAdd.contains(Character.valueOf(tempAa))) continue;
                            toAdd.add(Character.valueOf(tempAa));
                        }
                    }
                    if (includeMutations && sequenceMatchingPreferences.hasMutationMatrix()) {
                        ArrayList<Character> toAddWithMutations = new ArrayList<Character>(toAdd);
                        for (Character aa : toAdd) {
                            HashSet<Character> mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(aa);
                            if (mutatedAas == null) continue;
                            for (Character mutatedAa : mutatedAas) {
                                toAddWithMutations.add(mutatedAa);
                            }
                        }
                        toAdd = toAddWithMutations;
                    }
                }
            }
            Collections.sort(toAdd);
            regexBuilder.ensureCapacity(toAdd.size() + 2);
            regexBuilder.append("[");
            for (Character aa : toAdd) {
                regexBuilder.append(aa);
            }
            regexBuilder.append("]");
        }
        return Pattern.compile(regexBuilder.toString(), 2);
    }

    public String getPrositeFormat() {
        StringBuilder result = new StringBuilder();
        int cpt = 0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<Character> targetedAas = this.getTargetedAA(i);
            if (targetedAas.isEmpty()) {
                ++cpt;
            } else if (targetedAas.size() > 15) {
                ArrayList<Character> excludedAas = new ArrayList<Character>();
                for (char aa : AminoAcid.getUniqueAminoAcids()) {
                    if (targetedAas.contains(Character.valueOf(aa))) continue;
                    excludedAas.add(Character.valueOf(aa));
                }
                if (cpt > 0) {
                    result.append("(").append(cpt).append(")");
                    cpt = 0;
                }
                result.append("{");
                Object object = excludedAas.iterator();
                while (object.hasNext()) {
                    Character aa = (Character)object.next();
                    result.append(aa);
                }
                result.append("}");
            } else {
                if (cpt > 0) {
                    result.append("(").append(cpt).append(")");
                    cpt = 0;
                }
                if (!targetedAas.isEmpty()) {
                    result.append("[");
                    for (Character aa : targetedAas) {
                        result.append(aa);
                    }
                    result.append("]");
                }
            }
            if (i != this.target) continue;
            result.append("!");
        }
        return result.toString();
    }

    public ArrayList<Integer> getIndexes(String input, SequenceMatchingPreferences sequenceMatchingPreferences) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        while ((index = this.firstIndex(input, sequenceMatchingPreferences, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public ArrayList<Integer> getIndexes(AminoAcidPattern input, SequenceMatchingPreferences sequenceMatchingPreferences) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        while ((index = this.firstIndex(input, sequenceMatchingPreferences, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences, 0);
    }

    public int firstIndex(AminoAcidSequence aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence.getSequence(), sequenceMatchingPreferences, 0);
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidPattern, sequenceMatchingPreferences, 0);
    }

    public boolean contains(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        AminoAcidPattern pattern = new AminoAcidPattern(aminoAcidSequence);
        return pattern.firstIndex(this, sequenceMatchingPreferences) >= 0;
    }

    public boolean contains(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return aminoAcidPattern.firstIndex(this, sequenceMatchingPreferences) >= 0;
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidSequence.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        int nMutations = 0;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                char aa = aminoAcidSequence.charAt(i + j);
                if (!this.isTargeted(aa, j, sequenceMatchingPreferences)) {
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || sequenceMatchingPreferences.getMaxMutationsPerPeptide() != null && sequenceMatchingPreferences.getMaxMutationsPerPeptide() == nMutations || !this.isMutationTarget(aa, j, sequenceMatchingPreferences)) {
                        match = false;
                    } else {
                        ++nMutations;
                    }
                }
                if (!match) break;
            }
            if (!match) continue;
            return i + this.target;
        }
        return -1;
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidPattern.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        int nMutations = 0;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                ArrayList<Character> aminoAcids = aminoAcidPattern.getTargetedAA(i + j);
                if (aminoAcids.isEmpty()) continue;
                boolean aaMatched = false;
                for (Character aa : aminoAcids) {
                    if (!this.isTargeted(aa.charValue(), j, sequenceMatchingPreferences)) continue;
                    aaMatched = true;
                    break;
                }
                if (!aaMatched) {
                    for (Character aa : aminoAcids) {
                        if (!sequenceMatchingPreferences.hasMutationMatrix() || sequenceMatchingPreferences.getMaxMutationsPerPeptide() != null && sequenceMatchingPreferences.getMaxMutationsPerPeptide() < nMutations || !this.isMutationTarget(aa.charValue(), j, sequenceMatchingPreferences)) continue;
                        aaMatched = true;
                        ++nMutations;
                    }
                }
                if (aaMatched) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i + this.target;
        }
        return -1;
    }

    public boolean isTargeted(char aa, int index, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
        }
        if (this.residueTargeted != null) {
            SequenceMatchingPreferences.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
            ArrayList<Character> aaList = this.residueTargeted.get(index);
            if (aaList != null && !aaList.isEmpty()) {
                for (int i = 0; i < aaList.size(); ++i) {
                    Character targetedAA = aaList.get(i);
                    if (aa == targetedAA.charValue()) {
                        return true;
                    }
                    if (matchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                    AminoAcid targetedAminoAcid = AminoAcid.getAminoAcid(targetedAA.charValue());
                    for (char tempAA : targetedAminoAcid.getSubAminoAcids()) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                    for (char tempAA : targetedAminoAcid.getCombinations()) {
                        if (aa != tempAA) continue;
                        return true;
                    }
                    if (matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                    ArrayList<Character> indistinguishibleAas = targetedAminoAcid.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance());
                    for (int j = 0; j < indistinguishibleAas.size(); ++j) {
                        char tempAA = indistinguishibleAas.get(j).charValue();
                        if (aa != tempAA) continue;
                        return true;
                    }
                }
            } else if (aaList != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isMutationTarget(char aa, int index, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!sequenceMatchingPreferences.hasMutationMatrix()) {
            return false;
        }
        if (this.residueTargeted == null) {
            this.backwardCompatibilityCheck();
        }
        if (this.residueTargeted != null) {
            SequenceMatchingPreferences.MatchingType matchingType = sequenceMatchingPreferences.getSequenceMatchingType();
            ArrayList<Character> aaList = this.residueTargeted.get(index);
            if (aaList != null && !aaList.isEmpty()) {
                for (int i = 0; i < aaList.size(); ++i) {
                    Character targetedAA = aaList.get(i);
                    HashSet<Character> mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(targetedAA);
                    if (mutatedAas != null && mutatedAas.contains(Character.valueOf(aa))) {
                        return true;
                    }
                    if (matchingType != SequenceMatchingPreferences.MatchingType.aminoAcid && matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                    AminoAcid targetedAminoAcid = AminoAcid.getAminoAcid(targetedAA.charValue());
                    for (char tempAA : targetedAminoAcid.getSubAminoAcids()) {
                        mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(tempAA));
                        if (mutatedAas == null || !mutatedAas.contains(Character.valueOf(aa))) continue;
                        return true;
                    }
                    for (char tempAA : targetedAminoAcid.getCombinations()) {
                        mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(tempAA));
                        if (mutatedAas == null || !mutatedAas.contains(Character.valueOf(aa))) continue;
                        return true;
                    }
                    if (matchingType != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                    Object object = targetedAminoAcid.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance()).iterator();
                    while (object.hasNext()) {
                        char tempAA = ((Character)object.next()).charValue();
                        mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(tempAA));
                        if (mutatedAas == null || !mutatedAas.contains(Character.valueOf(aa))) continue;
                        return true;
                    }
                }
            } else if (aaList != null) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesIn(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public boolean matchesIn(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.firstIndex(aminoAcidPattern, sequenceMatchingPreferences) >= 0;
    }

    public boolean matches(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.length() == aminoAcidSequence.length() && this.firstIndex(aminoAcidSequence, sequenceMatchingPreferences) >= 0;
    }

    public int nMutations(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(aminoAcidSequence, sequenceMatchingPreferences)) {
            return -1;
        }
        int nMutations = 0;
        int patternLength = this.length();
        for (int i = 0; i < patternLength; ++i) {
            char aa = aminoAcidSequence.charAt(i);
            if (this.isTargeted(aa, i, sequenceMatchingPreferences) || !sequenceMatchingPreferences.hasMutationMatrix() || sequenceMatchingPreferences.getMaxMutationsPerPeptide() != null && sequenceMatchingPreferences.getMaxMutationsPerPeptide() < nMutations || !this.isMutationTarget(aa, i, sequenceMatchingPreferences)) continue;
            ++nMutations;
        }
        return nMutations;
    }

    public boolean matches(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.length() == aminoAcidPattern.length() && this.firstIndex(aminoAcidPattern, sequenceMatchingPreferences) >= 0;
    }

    public boolean isStarting(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidSequence.substring(0, patternLength), sequenceMatchingPreferences);
    }

    public boolean isStarting(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidPattern.getSubPattern(0, patternLength, false), sequenceMatchingPreferences);
    }

    public boolean isEnding(AminoAcidPattern aminoAcidPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidPattern.getSubPattern(aminoAcidPattern.length() - patternLength, false), sequenceMatchingPreferences);
    }

    public boolean isEnding(String aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidSequence.substring(aminoAcidSequence.length() - patternLength), sequenceMatchingPreferences);
    }

    public boolean isSameAs(AminoAcidPattern anotherPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(anotherPattern, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> mods2 = anotherPattern.getModificationsAt(i);
            if (mods1.size() != mods2.size()) {
                return false;
            }
            for (ModificationMatch modificationMatch1 : mods1) {
                PTM ptm1 = ptmFactory.getPTM(modificationMatch1.getTheoreticPtm());
                boolean found = false;
                for (ModificationMatch modificationMatch2 : mods2) {
                    PTM ptm2 = ptmFactory.getPTM(modificationMatch2.getTheoreticPtm());
                    if (ptm1.getMass() != ptm2.getMass()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSameSequenceAndModificationStatusAs(AminoAcidPattern anotherPattern, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!this.matches(anotherPattern, sequenceMatchingPreferences)) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        HashMap<Double, Integer> masses1 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> modifications = this.getModificationsAt(i);
            for (ModificationMatch modificationMatch : modifications) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses1.get(mass);
                if (occurrence == null) {
                    masses1.put(mass, 1);
                    continue;
                }
                masses1.put(mass, occurrence + 1);
            }
        }
        HashMap<Double, Integer> masses2 = new HashMap<Double, Integer>();
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> modifications = anotherPattern.getModificationsAt(i);
            for (ModificationMatch modMatch : modifications) {
                PTM ptm = ptmFactory.getPTM(modMatch.getTheoreticPtm());
                double mass = ptm.getMass();
                Integer occurrence = (Integer)masses2.get(mass);
                if (occurrence == null) {
                    masses2.put(mass, 1);
                    continue;
                }
                masses2.put(mass, occurrence + 1);
            }
        }
        if (masses1.size() != masses2.size()) {
            return false;
        }
        for (Double mass : masses1.keySet()) {
            Integer n = (Integer)masses1.get(mass);
            Integer occurrence2 = (Integer)masses2.get(mass);
            if (occurrence2 != null && occurrence2 == n) continue;
            return false;
        }
        for (int i = 1; i <= this.length(); ++i) {
            ArrayList<ModificationMatch> mods1 = this.getModificationsAt(i);
            ArrayList<ModificationMatch> arrayList = anotherPattern.getModificationsAt(i);
            if (mods1.size() != arrayList.size()) {
                return false;
            }
            for (int j = 0; j < mods1.size(); ++j) {
                ModificationMatch modificationMatch2;
                ModificationMatch modificationMatch1 = mods1.get(j);
                if (modificationMatch1.equals(modificationMatch2 = arrayList.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public int length() {
        if (this.length == -1 || this.length == 0) {
            if (this.residueTargeted == null) {
                this.backwardCompatibilityCheck();
            }
            this.length = this.residueTargeted == null || this.residueTargeted.isEmpty() ? 0 : Collections.max(this.residueTargeted.keySet()) + 1;
        }
        return this.length;
    }

    private void backwardCompatibilityCheck() {
        if (this.aaTargeted != null) {
            this.residueTargeted = new HashMap(this.aaTargeted.size());
            for (int i : this.aaTargeted.keySet()) {
                ArrayList<AminoAcid> oldAas = this.aaTargeted.get(i);
                ArrayList<Character> newAas = new ArrayList<Character>(oldAas.size());
                for (AminoAcid aminoAcid : oldAas) {
                    newAas.add(Character.valueOf(aminoAcid.getSingleLetterCodeAsChar()));
                }
                this.residueTargeted.put(i, newAas);
            }
            this.aaTargeted = null;
        }
    }

    public AminoAcidPattern getStandardSearchPattern() {
        AminoAcidPattern result = new AminoAcidPattern();
        result.setTarget(this.target);
        result.setTargeted(this.target, this.getAminoAcidsAtTarget());
        return result;
    }

    public static AminoAcidPattern getTrypsinExample() {
        AminoAcidPattern example = new AminoAcidPattern();
        example.setTarget(0);
        ArrayList<Character> target = new ArrayList<Character>();
        target.add(Character.valueOf(AminoAcid.K.getSingleLetterCodeAsChar()));
        target.add(Character.valueOf(AminoAcid.R.getSingleLetterCodeAsChar()));
        example.setTargeted(0, target);
        ArrayList<Character> exclusion = new ArrayList<Character>();
        exclusion.add(Character.valueOf(AminoAcid.P.getSingleLetterCodeAsChar()));
        example.setExcluded(1, exclusion);
        return example;
    }

    public void merge(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        HashMap<Integer, ArrayList<Character>> otherInclusionMap = otherPattern.getAaTargeted();
        if (otherInclusionMap != null) {
            for (int i : otherInclusionMap.keySet()) {
                ArrayList<Character> targetedAA;
                ArrayList<Character> otherAAs = otherPattern.getTargetedAA(i);
                if (this.residueTargeted == null) {
                    this.backwardCompatibilityCheck();
                    this.residueTargeted = new HashMap(otherInclusionMap.size());
                }
                if ((targetedAA = this.residueTargeted.get(i)) == null) {
                    this.residueTargeted.put(i, (ArrayList)otherAAs.clone());
                } else if (!otherAAs.isEmpty()) {
                    for (Character aa : otherAAs) {
                        if (targetedAA.contains(aa)) continue;
                        targetedAA.add(aa);
                    }
                } else {
                    targetedAA.clear();
                }
                if (i + 1 <= this.length) continue;
                this.length = i + 1;
            }
        }
        if ((modificationMatches = otherPattern.getModificationMatches()) != null) {
            for (int i : modificationMatches.keySet()) {
                this.addModificationMatches(i, otherPattern.getModificationMatches().get(i));
                if (i + 1 <= this.length) continue;
                this.length = i + 1;
            }
        }
    }

    public void append(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<ModificationMatch>> modificationMatches;
        int patternLength = this.length();
        HashMap<Integer, ArrayList<Character>> otherTargetedMap = otherPattern.getAaTargeted();
        if (otherTargetedMap != null) {
            if (this.residueTargeted == null) {
                this.backwardCompatibilityCheck();
                this.residueTargeted = new HashMap(otherTargetedMap.size());
            }
            for (int i : otherTargetedMap.keySet()) {
                int index = patternLength + i;
                this.residueTargeted.put(index, (ArrayList)otherTargetedMap.get(i).clone());
            }
        }
        if ((modificationMatches = otherPattern.getModificationMatches()) != null) {
            for (int i : modificationMatches.keySet()) {
                int newIndex = i + patternLength;
                for (ModificationMatch oldModificationMatch : modificationMatches.get(i)) {
                    ModificationMatch newModificationMatch = new ModificationMatch(oldModificationMatch.getTheoreticPtm(), oldModificationMatch.isVariable(), newIndex);
                    this.addModificationMatch(newIndex, newModificationMatch);
                }
            }
        }
        this.length = patternLength + otherPattern.length();
    }

    public static AminoAcidPattern merge(AminoAcidPattern pattern1, AminoAcidPattern pattern2) {
        AminoAcidPattern result = new AminoAcidPattern(pattern1);
        result.merge(pattern2);
        return result;
    }

    public String toString() {
        return this.asSequence();
    }

    public StringBuilder asStringBuilder() {
        StringBuilder result = new StringBuilder(this.length());
        for (int i = 0; i < this.length(); ++i) {
            if (this.getNTargetedAA(i) == 1) {
                result.append(this.getTargetedAA(i).get(0));
                continue;
            }
            int nTargetedAas = this.getNTargetedAA(i);
            if (nTargetedAas == 0) {
                result.append("X");
                continue;
            }
            if (nTargetedAas == 1) {
                result.append(this.getTargetedAA(i).get(0));
                continue;
            }
            result.append("[");
            for (Character aa : this.getTargetedAA(i)) {
                result.append(aa);
            }
            result.append("]");
        }
        return result;
    }

    @Override
    public String asSequence() {
        return this.asStringBuilder().toString();
    }

    public String asSequence(int index) {
        return this.asStringBuilder().toString();
    }

    public HashMap<Integer, ArrayList<ModificationMatch>> getModificationMatches() {
        return this.targetModifications;
    }

    public ArrayList<Integer> getModificationIndexes() {
        if (this.targetModifications == null) {
            return new ArrayList<Integer>();
        }
        return new ArrayList<Integer>(this.targetModifications.keySet());
    }

    public ArrayList<ModificationMatch> getModificationsAt(int localization) {
        ArrayList<ModificationMatch> result;
        if (this.targetModifications != null && (result = this.targetModifications.get(localization)) != null) {
            return result;
        }
        return new ArrayList<ModificationMatch>();
    }

    public void removeModificationMatch(int localisation, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches = this.targetModifications.get(localisation);
        if (modificationMatches != null) {
            modificationMatches.remove(modificationMatch);
            if (modificationMatches.isEmpty()) {
                this.targetModifications.remove(localisation);
            }
        }
    }

    public void clearModificationMatches() {
        if (this.targetModifications != null) {
            this.targetModifications.clear();
        }
    }

    public void addModificationMatch(int localization, ModificationMatch modificationMatch) {
        ArrayList<ModificationMatch> modificationMatches;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null) {
            this.targetModifications = new HashMap();
        }
        if ((modificationMatches = this.targetModifications.get(localization)) == null) {
            modificationMatches = new ArrayList();
            this.targetModifications.put(localization, modificationMatches);
        }
        modificationMatches.add(modificationMatch);
    }

    public void addModificationMatches(int localization, ArrayList<ModificationMatch> modificationMatches) {
        ArrayList<ModificationMatch> modificationMatchesAtIndex;
        int index = localization - 1;
        if (index < 0) {
            throw new IllegalArgumentException("Wrong modification target index " + localization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null) {
            this.targetModifications = new HashMap();
        }
        if ((modificationMatchesAtIndex = this.targetModifications.get(localization)) == null) {
            modificationMatchesAtIndex = new ArrayList();
            this.targetModifications.put(localization, modificationMatchesAtIndex);
        }
        modificationMatches.addAll(modificationMatches);
    }

    public void changeModificationSite(ModificationMatch modificationMatch, int oldLocalization, int newLocalization) {
        int oldIndex = oldLocalization - 1;
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Wrong modification old target index " + oldLocalization + ", 1 is the first amino acid for PTM localization.");
        }
        if (this.targetModifications == null || !this.targetModifications.containsKey(oldIndex) || !this.targetModifications.get(oldIndex).contains(modificationMatch)) {
            throw new IllegalArgumentException("Modification match " + modificationMatch + " not found at index " + oldLocalization + ".");
        }
        this.targetModifications.get(oldIndex).remove(modificationMatch);
        this.addModificationMatch(newLocalization, modificationMatch);
    }

    public String getTaggedModifiedSequence(ModificationProfile modificationProfile, boolean useHtmlColorCoding, boolean useShortName, boolean excludeAllFixedPtms) {
        HashMap<Integer, ArrayList<String>> mainModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> secondaryModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> fixedModificationSites = new HashMap<Integer, ArrayList<String>>();
        if (this.targetModifications != null) {
            for (int modSite : this.targetModifications.keySet()) {
                for (ModificationMatch modificationMatch : this.targetModifications.get(modSite)) {
                    String modName = modificationMatch.getTheoreticPtm();
                    if (modificationMatch.isVariable()) {
                        if (modificationMatch.isConfident()) {
                            if (!mainModificationSites.containsKey(modSite)) {
                                mainModificationSites.put(modSite, new ArrayList());
                            }
                            mainModificationSites.get(modSite).add(modName);
                            continue;
                        }
                        if (!secondaryModificationSites.containsKey(modSite)) {
                            secondaryModificationSites.put(modSite, new ArrayList());
                        }
                        secondaryModificationSites.get(modSite).add(modName);
                        continue;
                    }
                    if (excludeAllFixedPtms) continue;
                    if (!fixedModificationSites.containsKey(modSite)) {
                        fixedModificationSites.put(modSite, new ArrayList());
                    }
                    fixedModificationSites.get(modSite).add(modName);
                }
            }
        }
        return AminoAcidPattern.getTaggedModifiedSequence(modificationProfile, this, mainModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName);
    }

    public static String getTaggedModifiedSequence(ModificationProfile modificationProfile, AminoAcidPattern aminoAcidPattern, HashMap<Integer, ArrayList<String>> mainModificationSites, HashMap<Integer, ArrayList<String>> secondaryModificationSites, HashMap<Integer, ArrayList<String>> fixedModificationSites, boolean useHtmlColorCoding, boolean useShortName) {
        if (mainModificationSites == null) {
            mainModificationSites = new HashMap();
        }
        if (secondaryModificationSites == null) {
            secondaryModificationSites = new HashMap();
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new HashMap();
        }
        String modifiedSequence = "";
        for (int aa = 1; aa <= aminoAcidPattern.length(); ++aa) {
            int patternIndex = aa - 1;
            if (aminoAcidPattern.getNTargetedAA(patternIndex) > 1) {
                modifiedSequence = modifiedSequence + "[";
            }
            if (aminoAcidPattern.getNTargetedAA(patternIndex) == 0) {
                if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : mainModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue('X', ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                } else if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : secondaryModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue('X', ptmName, modificationProfile, false, useHtmlColorCoding, useShortName);
                    }
                } else if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : fixedModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue('X', ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                } else {
                    modifiedSequence = modifiedSequence + "X";
                }
            }
            for (Character aminoAcid : aminoAcidPattern.getTargetedAA(patternIndex)) {
                if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : mainModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.charValue(), ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : secondaryModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.charValue(), ptmName, modificationProfile, false, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                if (fixedModificationSites.containsKey(aa) && !fixedModificationSites.get(aa).isEmpty()) {
                    for (String ptmName : fixedModificationSites.get(aa)) {
                        modifiedSequence = modifiedSequence + AminoAcidPattern.getTaggedResidue(aminoAcid.charValue(), ptmName, modificationProfile, true, useHtmlColorCoding, useShortName);
                    }
                    continue;
                }
                modifiedSequence = modifiedSequence + aminoAcid;
            }
            if (aminoAcidPattern.getNTargetedAA(aa) <= 1) continue;
            modifiedSequence = modifiedSequence + "]";
        }
        return modifiedSequence;
    }

    private static String getTaggedResidue(char residue, String ptmName, ModificationProfile modificationProfile, boolean mainPtm, boolean useHtmlColorCoding, boolean useShortName) {
        String taggedResidue = "";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        PTM ptm = ptmFactory.getPTM(ptmName);
        if (ptm.getType() == 0) {
            if (!useHtmlColorCoding) {
                taggedResidue = useShortName ? taggedResidue + residue + "<" + ptmFactory.getShortName(ptmName) + ">" : taggedResidue + residue + "<" + ptmName + ">";
            } else {
                Color ptmColor = modificationProfile.getColor(ptmName);
                taggedResidue = mainPtm ? taggedResidue + "<span style=\"color:#" + Util.color2Hex(Color.WHITE) + ";background:#" + Util.color2Hex(ptmColor) + "\">" + residue + "</span>" : taggedResidue + "<span style=\"color:#" + Util.color2Hex(ptmColor) + ";background:#" + Util.color2Hex(Color.WHITE) + "\">" + residue + "</span>";
            }
        } else {
            taggedResidue = taggedResidue + residue;
        }
        return taggedResidue;
    }

    public ArrayList<String> getAllPossibleSequences() {
        ArrayList<StringBuilder> stringBuilders = new ArrayList<StringBuilder>(1);
        int tempLength = this.length();
        for (int i = 0; i < this.length(); ++i) {
            StringBuilder newBuilder;
            if (stringBuilders.isEmpty()) {
                if (this.residueTargeted != null) {
                    ArrayList<Character> aminoAcids = this.residueTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (Character c : aminoAcids) {
                            newBuilder = new StringBuilder(tempLength);
                            newBuilder.append(c);
                            stringBuilders.add(newBuilder);
                        }
                        continue;
                    }
                    StringBuilder stringBuilder = new StringBuilder(tempLength);
                    stringBuilder.append('X');
                    stringBuilders.add(stringBuilder);
                    continue;
                }
                StringBuilder newBuilder3 = new StringBuilder(tempLength);
                newBuilder3.append('X');
                stringBuilders.add(newBuilder3);
                continue;
            }
            ArrayList<StringBuilder> newBuilders = new ArrayList<StringBuilder>(1);
            for (StringBuilder stringBuilder : stringBuilders) {
                if (this.residueTargeted != null) {
                    ArrayList<Character> aminoAcids = this.residueTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (Character aminoAcid : this.residueTargeted.get(i)) {
                            StringBuilder newBuilder4 = new StringBuilder(stringBuilder);
                            newBuilder4.append(aminoAcid);
                            newBuilders.add(newBuilder4);
                        }
                        continue;
                    }
                    StringBuilder newBuilder5 = new StringBuilder(stringBuilder);
                    newBuilder5.append('X');
                    newBuilders.add(newBuilder5);
                    continue;
                }
                newBuilder = new StringBuilder(stringBuilder);
                newBuilder.append('X');
                newBuilders.add(newBuilder);
            }
            stringBuilders = newBuilders;
        }
        ArrayList<String> results = new ArrayList<String>(stringBuilders.size());
        for (StringBuilder stringBuilder : stringBuilders) {
            results.add(stringBuilder.toString());
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Double getMass() {
        double mass = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<ModificationMatch> modificationAtIndex;
            if (this.residueTargeted == null) throw new IllegalArgumentException("Impossible to estimate the mass of the amino acid pattern " + this.asSequence() + ". null as targeted amino acid map.");
            ArrayList<Character> aminoAcids = this.residueTargeted.get(i);
            if (aminoAcids.size() != 1) throw new IllegalArgumentException("Impossible to estimate the mass of the amino acid pattern " + this.asSequence() + ". " + aminoAcids.size() + " amino acids at target position " + i + " as targeted amino acid.");
            Character aa = this.getTargetedAA(i).get(0);
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa.charValue());
            mass += aminoAcid.monoisotopicMass;
            if (this.targetModifications == null || (modificationAtIndex = this.targetModifications.get(i + 1)) == null) continue;
            for (ModificationMatch modificationMatch : modificationAtIndex) {
                PTM ptm = PTMFactory.getInstance().getPTM(modificationMatch.getTheoreticPtm());
                mass += ptm.getMass();
            }
        }
        return mass;
    }

    public AminoAcidPattern getSubPattern(int startIndex, int endIndex, boolean updateTarget) {
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern();
        if (this.residueTargeted != null) {
            for (int i : this.residueTargeted.keySet()) {
                if (i < startIndex || i > endIndex) continue;
                ArrayList aminoAcids = (ArrayList)this.residueTargeted.get(i).clone();
                aminoAcidPattern.setTargeted(i - startIndex, aminoAcids);
            }
        }
        if (updateTarget) {
            aminoAcidPattern.setTarget(this.getTarget() - startIndex);
        } else {
            aminoAcidPattern.setTarget(this.getTarget());
        }
        if (this.targetModifications != null) {
            for (int i : this.targetModifications.keySet()) {
                if (i <= startIndex || i > endIndex + 1) continue;
                int index = i - startIndex;
                ArrayList<ModificationMatch> modificationMatches = this.targetModifications.get(i);
                ArrayList<ModificationMatch> newMatches = new ArrayList<ModificationMatch>(modificationMatches.size());
                for (ModificationMatch modificationMatch : modificationMatches) {
                    newMatches.add(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), index));
                }
                aminoAcidPattern.addModificationMatches(index, newMatches);
            }
        }
        return aminoAcidPattern;
    }

    public AminoAcidPattern getSubPattern(int startIndex, boolean updateTarget) {
        return this.getSubPattern(startIndex, this.length(), updateTarget);
    }

    public AminoAcidPattern reverse() {
        int reversed;
        AminoAcidPattern newPattern = new AminoAcidPattern();
        if (this.residueTargeted != null) {
            for (int i : this.residueTargeted.keySet()) {
                reversed = this.length() - i - 1;
                newPattern.setTargeted(reversed, (ArrayList)this.residueTargeted.get(i).clone());
            }
        }
        if (this.targetModifications != null) {
            for (int i : this.targetModifications.keySet()) {
                reversed = this.length() - i + 1;
                for (ModificationMatch modificationMatch : this.targetModifications.get(i)) {
                    ModificationMatch newMatch = new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), reversed);
                    if (modificationMatch.isConfident()) {
                        newMatch.setConfident(true);
                    }
                    if (modificationMatch.isInferred()) {
                        newMatch.setInferred(true);
                    }
                    newPattern.addModificationMatch(reversed, newMatch);
                }
            }
        }
        if (this.target > -1) {
            newPattern.setTarget(this.length() - this.target - 1);
        }
        return newPattern;
    }

    @Override
    public boolean isSameAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidPattern)) {
            return false;
        }
        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)anotherCompontent;
        return this.isSameAs(aminoAcidPattern, sequenceMatchingPreferences);
    }

    @Override
    public boolean isSameSequenceAndModificationStatusAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (!(anotherCompontent instanceof AminoAcidPattern)) {
            return false;
        }
        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)anotherCompontent;
        return this.isSameSequenceAndModificationStatusAs(aminoAcidPattern, sequenceMatchingPreferences);
    }
}

