/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.db.DBMetaData;
import com.compomics.util.db.components.Constructors;
import com.compomics.util.db.components.DeleteableCode;
import com.compomics.util.db.components.GettersAndSetters;
import com.compomics.util.db.components.InstanceVariables;
import com.compomics.util.db.components.PersistableCode;
import com.compomics.util.db.components.RetrievableCode;
import com.compomics.util.db.components.UpdateableCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DBAccessor {
    Logger logger = Logger.getLogger(DBAccessor.class);
    private String iName = null;
    private String iPackage = null;
    private GettersAndSetters iGetSet = null;
    private InstanceVariables iVars = null;
    private Constructors iConstr = null;
    private DeleteableCode iDeleteable = null;
    private RetrievableCode iRetrieveable = null;
    private UpdateableCode iUpdateable = null;
    private PersistableCode iPersistable = null;

    public DBAccessor(DBMetaData aMeta, String aPackage, boolean debug) {
        String name = aMeta.getTableName();
        name = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
        this.iName = name + "TableAccessor";
        this.iPackage = aPackage.trim();
        if (debug) {
            this.logger.info("\nGenerating instance variables...");
        }
        this.iVars = new InstanceVariables(aMeta);
        if (debug) {
            this.logger.info("Variables done.\nGenerating constructors...");
        }
        this.iConstr = new Constructors(aMeta);
        if (debug) {
            this.logger.info("Constructors done.\nGenerating Getters and Setters...");
        }
        this.iGetSet = new GettersAndSetters(aMeta);
        if (debug) {
            this.logger.info("Getters and Setters done.\nGenerating Deleteable implementation...");
        }
        this.iDeleteable = new DeleteableCode(aMeta);
        if (debug) {
            this.logger.info("Deleteable implementation done.\nGenerating Retrievable implementation...");
        }
        this.iRetrieveable = new RetrievableCode(aMeta);
        if (debug) {
            this.logger.info("Retrievable implementation done.\nGenerating Updateable implementation...");
        }
        this.iUpdateable = new UpdateableCode(aMeta);
        if (debug) {
            this.logger.info("Updateable implementation done.\nGenerating Persistable implementation...");
        }
        this.iPersistable = new PersistableCode(aMeta);
        if (debug) {
            this.logger.info("Persistable implementation done.\n\nGeneration process complete!.");
        }
    }

    public String toString() {
        Date date = new Date();
        SimpleDateFormat lsdDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat lsdTime = new SimpleDateFormat("HH:mm:ss");
        String lDate = lsdDate.format(date);
        String time = lsdTime.format(date);
        StringBuffer lsb = new StringBuffer("/*\n * Created by the DBAccessor generator.\n * Programmer: Lennart Martens\n * Date: " + lDate + "\n * Time: " + time + "\n */\n");
        if (this.iPackage != null && !this.iPackage.equals("")) {
            lsb.append("package " + this.iPackage + ";\n");
        }
        lsb.append("\nimport java.sql.*;\n");
        lsb.append("import java.io.*;\n");
        lsb.append("import java.util.*;\n");
        lsb.append("import com.compomics.util.db.interfaces.*;\n");
        lsb.append("\n/*\n * CVS information:\n *\n * $Revision: 1.4 $\n * $Date: 2007/07/06 09:41:53 $\n */\n");
        int location = this.iName.indexOf("Table");
        lsb.append("\n/**\n * This class is a generated accessor for the " + this.iName.substring(0, location) + " table.\n *\n * @author DBAccessor generator class (Lennart Martens).\n */\n");
        lsb.append("public class " + this.iName + " implements Deleteable, Retrievable, Updateable, Persistable {\n");
        lsb.append(this.iVars.toString());
        lsb.append(this.iConstr.toString());
        lsb.append(this.iGetSet.toString());
        lsb.append(this.iDeleteable.toString());
        lsb.append(this.iRetrieveable.toString());
        lsb.append(this.iUpdateable.toString());
        lsb.append(this.iPersistable.toString());
        lsb.append("}");
        return lsb.toString();
    }
}

