/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MascotRawParser {
    private static Logger logger = Logger.getLogger(MascotRawParser.class);
    private static String iSeparatorA = "=";
    private static String iSeparatorB = ":";
    private HashMap allSections = new HashMap(400);
    private int numQueries = -1;

    public void addSection(String aKey, HashMap aSection) {
        this.allSections.put(aKey, aSection);
    }

    public HashMap getSection(String aKey) {
        return (HashMap)this.allSections.get(aKey);
    }

    public String toString() {
        StringBuffer lsb = new StringBuffer("Hi, I'm currently holding the following sections:\n");
        Iterator i = this.allSections.keySet().iterator();
        while (i.hasNext()) {
            lsb.append("Section : '" + i.next() + "'.\n");
        }
        return lsb.toString();
    }

    public int getNumberOfQueries() {
        if (this.numQueries < 0) {
            this.numQueries = Integer.parseInt((String)((HashMap)this.allSections.get("header")).get("queries"));
        }
        return this.numQueries;
    }

    public MascotRawParser(File aFile) throws IOException {
        BufferedReader lbr = new BufferedReader(new InputStreamReader(new FileInputStream(aFile)));
        this.parseFromReader(lbr);
        lbr.close();
    }

    public MascotRawParser(String aString) {
        try {
            BufferedReader lbr = new BufferedReader(new StringReader(aString));
            this.parseFromReader(lbr);
            lbr.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public MascotRawParser(BufferedReader abr) throws IOException {
        this.parseFromReader(abr);
    }

    private void parseFromReader(BufferedReader abr) throws IOException {
        String line = null;
        if (abr != null) {
            line = abr.readLine();
            line = abr.readLine();
            while (line != null && line.indexOf("boundary") < 0) {
                line = abr.readLine();
            }
            if (line == null) {
                throw new IllegalArgumentException("Did not find 'boundary' definition in the datfile!");
            }
            String boundary = this.getBoundary(line);
            Vector<InnerSectionWrapper> sections = new Vector<InnerSectionWrapper>(400, 20);
            boolean lbInSection = false;
            InnerSectionWrapper isw = null;
            StringBuffer lsb = null;
            while ((line = abr.readLine()) != null) {
                if (line.indexOf(boundary) >= 0) {
                    if (lbInSection) {
                        isw.setContent(lsb.toString());
                        sections.addElement(isw);
                    }
                    if (line.endsWith(boundary + "--")) break;
                    lbInSection = true;
                    isw = new InnerSectionWrapper(this.getSectionName(abr.readLine()));
                    lsb = new StringBuffer();
                    continue;
                }
                if (!lbInSection || line.trim().equals("")) continue;
                lsb.append(line + "\n");
            }
            int liSize = sections.size();
            for (int i = 0; i < liSize; ++i) {
                InnerSectionWrapper lsw = (InnerSectionWrapper)sections.elementAt(i);
                HashMap lhmToPut = null;
                if (!"index".equalsIgnoreCase(lsw.getName())) {
                    lhmToPut = this.processSectionToHashMap(lsw.getContent());
                }
                if (lhmToPut == null) continue;
                this.addSection(lsw.getName(), lhmToPut);
            }
        }
    }

    public void clear() {
        if (this.allSections != null) {
            this.allSections.clear();
        }
    }

    private HashMap processSectionToHashMap(String aContent) {
        HashMap<String, String> lhmResult = new HashMap<String, String>();
        try {
            BufferedReader lbr = new BufferedReader(new StringReader(aContent));
            String line = null;
            boolean firstLine = true;
            while ((line = lbr.readLine()) != null) {
                if (firstLine) {
                    if (line.startsWith("<?xml version")) {
                        lhmResult.put("XML", aContent);
                        break;
                    }
                    firstLine = false;
                }
                String key = null;
                String value = null;
                if (line.startsWith("h") && line.indexOf("_text=") >= 0 || line.startsWith("\"") && line.endsWith("\"")) {
                    key = line.substring(0, line.indexOf("=")).trim();
                    if (line.length() > line.indexOf("=") + 1) {
                        value = line.substring(line.indexOf("=") + 1).trim();
                    }
                } else {
                    String sep = this.analyseSeparator(line);
                    if (sep != null) {
                        StringTokenizer lst = new StringTokenizer(line, sep);
                        key = lst.nextToken().trim();
                        value = null;
                        if (lst.hasMoreTokens()) {
                            value = lst.nextToken().trim();
                        }
                    }
                }
                lhmResult.put(key, value);
            }
            lbr.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lhmResult;
    }

    private String getSectionName(String sectionDefLine) {
        return this.getProp(sectionDefLine, "name");
    }

    private String analyseSeparator(String aLine) {
        if (aLine.indexOf(iSeparatorA) > 0) {
            return iSeparatorA;
        }
        if (aLine.indexOf(iSeparatorB) > 0) {
            return iSeparatorB;
        }
        return null;
    }

    private String getBoundary(String boundaryDefLine) {
        String lookFor = "boundary";
        String found = this.getProp(boundaryDefLine, lookFor);
        return found;
    }

    private String getProp(String line, String propName) {
        int offset;
        int start = line.indexOf(propName = propName + "=");
        String found = line.substring(start + (offset = propName.length())).trim();
        if (found.startsWith("\"")) {
            found = found.substring(1);
        }
        if (found.endsWith("\"")) {
            found = found.substring(0, found.length() - 1);
        }
        return found.trim();
    }

    private class InnerSectionWrapper {
        private String name = null;
        private String content = null;

        public InnerSectionWrapper() {
            this(null, null);
        }

        public InnerSectionWrapper(String aName) {
            this(aName, null);
        }

        public InnerSectionWrapper(String aName, String aContent) {
            this.name = aName;
            this.content = aContent;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

