/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProteinID {
    private static Logger logger = Logger.getLogger(ProteinID.class);
    private double iMass;
    private String iAccession;
    private String iDescription;
    private Vector iSources = null;

    public ProteinID(String aAccession, double aMass, String aDescription) {
        this.iMass = aMass;
        this.iAccession = aAccession;
        this.iDescription = aDescription;
    }

    public void addSource(int aQueryNumber, int aPeptidehitNumber) {
        if (this.iSources == null) {
            this.iSources = new Vector();
        }
        this.iSources.add(new int[]{aQueryNumber, aPeptidehitNumber});
    }

    public String getAccession() {
        return this.iAccession;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public double getMass() {
        return this.iMass;
    }

    public int[] getQueryNumbers() {
        int[] lQueryNumbers = new int[this.iSources.size()];
        Enumeration lEnum = this.iSources.elements();
        int lCount = 0;
        while (lEnum.hasMoreElements()) {
            lQueryNumbers[lCount] = ((int[])lEnum.nextElement())[0];
            ++lCount;
        }
        return lQueryNumbers;
    }

    public int[][] getQueryNumbersAndPeptideHits() {
        int[][] lQueryNumbersAndPeptideHits = new int[this.iSources.size()][2];
        Enumeration lEnumeration = this.iSources.elements();
        int lCount = 0;
        while (lEnumeration.hasMoreElements()) {
            lQueryNumbersAndPeptideHits[lCount] = (int[])lEnumeration.nextElement();
            ++lCount;
        }
        return lQueryNumbersAndPeptideHits;
    }

    public String toString() {
        return "ProteinID{iMass=" + this.iMass + ", iAccession='" + this.iAccession + '\'' + ", iDescription='" + this.iDescription + '\'' + ", iSources=" + this.iSources + '}';
    }
}

