/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.interfaces.Modification;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.Masses;
import com.compomics.mascotdatfile.util.mascot.Parameters;
import com.compomics.mascotdatfile.util.mascot.Peak;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideToQueryMap;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.QueryToPeptideMap;
import com.compomics.mascotdatfile.util.mascot.VariableModification;
import com.compomics.mascotdatfile.util.mascot.fragmentions.FragmentIonImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PeptideHitAnnotation
implements Serializable {
    private static Logger logger = Logger.getLogger(PeptideHitAnnotation.class);
    Vector iSignificantTheoreticalFragmentions = null;
    Vector iNonSignificantTheoreticalFragmentions = null;
    private String iSequence = null;
    private int iH2OStartB = -1;
    private int iH2OStartY = -1;
    private int iNH3StartB = -1;
    private int iNH3StartY = -1;
    private int[] iIonSeriesFound = null;
    private double iIntensityPercentage = 0.1;
    private Modification[] iMods = null;
    private FragmentIonImpl[] iYions = null;
    private FragmentIonImpl[] iBions = null;
    private double iFragmentMassErrorMargin = 0.0;
    private double iPeptideMassErrorMargin = 0.0;
    private double iPrecursorMZ = 0.0;
    private String iPrecursorCharge = null;
    private Peak[] iPeaks = null;
    private int[] iMascotCoverage;
    private int[] iFusedCoverage;
    private int[] iIonSeriesRules;

    public PeptideHitAnnotation(String aSequence, Modification[] aMods, Masses aM, Parameters aP, int[] aIonSeriesFound) {
        this.iSequence = aSequence;
        this.iYions = new FragmentIonImpl[this.iSequence.length() - 1];
        this.iBions = new FragmentIonImpl[this.iSequence.length() - 1];
        this.iMods = aMods;
        this.iIonSeriesFound = aIonSeriesFound;
        this.iPeptideMassErrorMargin = Double.parseDouble(aP.getTOL());
        this.iFragmentMassErrorMargin = Double.parseDouble(aP.getITOL());
        this.parseFragmentationRules(aP);
        this.calculateBYions(aM);
    }

    private void parseFragmentationRules(Parameters aP) {
        int i;
        ArrayList<Integer> lIonSeriesRules = new ArrayList<Integer>();
        int[] lRules = aP.getRules();
        block10: for (i = 0; i < lRules.length; ++i) {
            int lRule = lRules[i];
            switch (lRule) {
                case 5: {
                    lIonSeriesRules.add(0);
                    lIonSeriesRules.add(2);
                    continue block10;
                }
                case 8: {
                    lIonSeriesRules.add(3);
                    lIonSeriesRules.add(5);
                    continue block10;
                }
                case 11: {
                    lIonSeriesRules.add(9);
                    lIonSeriesRules.add(10);
                    continue block10;
                }
                case 12: {
                    lIonSeriesRules.add(11);
                    lIonSeriesRules.add(12);
                    continue block10;
                }
                case 13: {
                    lIonSeriesRules.add(6);
                    lIonSeriesRules.add(8);
                    continue block10;
                }
                case 16: {
                    lIonSeriesRules.add(13);
                    lIonSeriesRules.add(14);
                    continue block10;
                }
                case 21: {
                    lIonSeriesRules.add(15);
                    lIonSeriesRules.add(16);
                    continue block10;
                }
                case 25: {
                    lIonSeriesRules.add(17);
                    lIonSeriesRules.add(18);
                    continue block10;
                }
            }
        }
        this.iIonSeriesRules = new int[lIonSeriesRules.size()];
        for (i = 0; i < lIonSeriesRules.size(); ++i) {
            this.iIonSeriesRules[i] = (Integer)lIonSeriesRules.get(i);
        }
    }

    private void calculateBYions(Masses aM) {
        double[] lPeptideUnitMasses = this.calculatePeptideUnitMasses(aM);
        double lHydrogen = aM.getMass("Hydrogen");
        double lCtermMass = lHydrogen + aM.getMass("Oxygen");
        int length = this.iSequence.length();
        for (int i = 1; i < length; ++i) {
            int j;
            double bMass = 0.0;
            double yMass = 0.0;
            for (j = 0; j < i; ++j) {
                bMass += lPeptideUnitMasses[j];
            }
            this.iBions[i - 1] = new FragmentIonImpl(bMass += lHydrogen, this.iFragmentMassErrorMargin, 1, i, "b");
            for (j = 0; j < i; ++j) {
                yMass += lPeptideUnitMasses[length - 1 - j];
            }
            yMass = yMass + lCtermMass + 2.0 * lHydrogen;
            this.iYions[i - 1] = new FragmentIonImpl(yMass, this.iFragmentMassErrorMargin, 7, i, "y");
        }
    }

    private double[] calculatePeptideUnitMasses(Masses aM) {
        int length = this.iSequence.length();
        double[] lPeptideUnitMasses = new double[length];
        for (int i = 0; i < length; ++i) {
            double lUnitMass = 0.0;
            if (i == 0 && this.iMods[0] != null) {
                lUnitMass += this.iMods[0].getMass();
            }
            if (i == length - 1 && this.iMods[i + 2] != null) {
                lUnitMass += this.iMods[i + 2].getMass();
            }
            lUnitMass += aM.getMass(this.iSequence.charAt(i));
            if (this.iMods[i + 1] != null && !this.iMods[i + 1].isFixed()) {
                lUnitMass += this.iMods[i + 1].getMass();
            }
            lPeptideUnitMasses[i] = lUnitMass;
        }
        return lPeptideUnitMasses;
    }

    public PeptideHitAnnotation(String aSequence, Modification[] aMods, Masses aM, Parameters aP, int[] aIonSeriesFound, double aPrecursorMZ, String aPrecursorCharge) {
        this(aSequence, aMods, aM, aP, aIonSeriesFound);
        this.iPrecursorMZ = aPrecursorMZ;
        this.iPrecursorCharge = aPrecursorCharge;
    }

    public FragmentIonImpl[] getBions() {
        return this.iBions;
    }

    private int getH2OStartB() {
        if (this.iH2OStartB == -1) {
            int lStart = this.iSequence.length() - 1;
            if (this.iSequence.indexOf(83) != -1 && this.iSequence.indexOf(83) < lStart) {
                lStart = this.iSequence.indexOf(83);
            }
            if (this.iSequence.indexOf(84) != -1 && this.iSequence.indexOf(84) < lStart) {
                lStart = this.iSequence.indexOf(84);
            }
            if (this.iSequence.indexOf(68) != -1 && this.iSequence.indexOf(68) < lStart) {
                lStart = this.iSequence.indexOf(68);
            }
            if (this.iSequence.indexOf(69) != -1 && this.iSequence.indexOf(69) < lStart) {
                lStart = this.iSequence.indexOf(69);
            }
            this.iH2OStartB = lStart;
        }
        return this.iH2OStartB;
    }

    private int getH2OStartY() {
        if (this.iH2OStartY == -1) {
            int lStart = 0;
            if (this.iSequence.lastIndexOf(83) > lStart) {
                lStart = this.iSequence.indexOf(83);
            }
            if (this.iSequence.lastIndexOf(84) > lStart) {
                lStart = this.iSequence.indexOf(84);
            }
            if (this.iSequence.lastIndexOf(68) > lStart) {
                lStart = this.iSequence.indexOf(68);
            }
            if (this.iSequence.lastIndexOf(69) > lStart) {
                lStart = this.iSequence.indexOf(69);
            }
            this.iH2OStartY = lStart;
        }
        return this.iH2OStartY;
    }

    public double getIntensityPercentage() {
        return this.iIntensityPercentage;
    }

    public void setIntensityPercentage(double aIntensityPercentage) {
        this.iIntensityPercentage = aIntensityPercentage;
    }

    private int getNH3StartB() {
        if (this.iNH3StartB == -1) {
            int lStart = this.iSequence.length() - 1;
            if (this.iSequence.indexOf(82) != -1 && this.iSequence.indexOf(82) < lStart) {
                lStart = this.iSequence.indexOf(82);
            }
            if (this.iSequence.indexOf(75) != -1 && this.iSequence.indexOf(75) < lStart) {
                lStart = this.iSequence.indexOf(75);
            }
            if (this.iSequence.indexOf(78) != -1 && this.iSequence.indexOf(78) < lStart) {
                lStart = this.iSequence.indexOf(78);
            }
            if (this.iSequence.indexOf(81) != -1 && this.iSequence.indexOf(81) < lStart) {
                lStart = this.iSequence.indexOf(81);
            }
            this.iNH3StartB = lStart;
        }
        return this.iNH3StartB;
    }

    private int getNH3StartY() {
        if (this.iNH3StartY == -1) {
            int lStart = 0;
            if (this.iSequence.lastIndexOf(82) > lStart) {
                lStart = this.iSequence.lastIndexOf(82);
            }
            if (this.iSequence.lastIndexOf(75) > lStart) {
                lStart = this.iSequence.lastIndexOf(75);
            }
            if (this.iSequence.lastIndexOf(78) > lStart) {
                lStart = this.iSequence.lastIndexOf(78);
            }
            if (this.iSequence.lastIndexOf(81) > lStart) {
                lStart = this.iSequence.lastIndexOf(81);
            }
            this.iNH3StartY = lStart;
        }
        return this.iNH3StartY;
    }

    public FragmentIonImpl[] getYions() {
        return this.iYions;
    }

    public int[] getFusedIonCoverage(Peak[] aPeaks, int aNumberOfPeaksUsed, double aMaxIntensity, double aIntensityPercentage) {
        boolean work = false;
        if (this.iPeaks == null || this.iFusedCoverage == null) {
            work = true;
        } else if (this.iPeaks != aPeaks) {
            work = true;
        }
        if (work) {
            this.iPeaks = aPeaks;
            Vector lFragmentIons = this.getFusedMatchedIons(this.iPeaks, aNumberOfPeaksUsed, aMaxIntensity, aIntensityPercentage);
            this.iFusedCoverage = this.calculateCoverage(lFragmentIons);
        }
        return this.iFusedCoverage;
    }

    public Vector getFusedMatchedIons(Peak[] aPeaks, int aNumberOfIonsUsed, double aMaxIntensity, double aIntensityPercentage) {
        this.resetPreviousMatching();
        Vector lFusedMatches = new Vector();
        lFusedMatches.addAll(this.getMatchedIonsByMascot(aPeaks, aNumberOfIonsUsed));
        lFusedMatches.addAll(this.getSignificantMatchedIonsAboveIntensityThreshold(aPeaks, aMaxIntensity, aIntensityPercentage));
        lFusedMatches.addAll(this.getNonSignificantMatchedIonsAboveIntensityThreshold(aPeaks, aMaxIntensity, aIntensityPercentage));
        lFusedMatches.addAll(this.getMatchedIons(this.getPrecursorAndImmoniumIons(), aPeaks));
        return lFusedMatches;
    }

    private void resetPreviousMatching() {
        int i;
        if (this.iSignificantTheoreticalFragmentions != null) {
            for (i = 0; i < this.iSignificantTheoreticalFragmentions.size(); ++i) {
                ((FragmentIonImpl)this.iSignificantTheoreticalFragmentions.elementAt(i)).resetMatchingValues();
            }
        }
        if (this.iNonSignificantTheoreticalFragmentions != null) {
            for (i = 0; i < this.iNonSignificantTheoreticalFragmentions.size(); ++i) {
                ((FragmentIonImpl)this.iNonSignificantTheoreticalFragmentions.elementAt(i)).resetMatchingValues();
            }
        }
    }

    public Vector getMatchedIonsByMascot(Peak[] aPeaks, int aNumberOfPeaksUsed) {
        this.resetPreviousMatching();
        Peak[] lPeaksUsedByMascot = null;
        if (aPeaks.length > aNumberOfPeaksUsed) {
            lPeaksUsedByMascot = new Peak[aNumberOfPeaksUsed];
            for (int i = 0; i < lPeaksUsedByMascot.length; ++i) {
                lPeaksUsedByMascot[i] = aPeaks[i];
            }
        } else {
            lPeaksUsedByMascot = aPeaks;
        }
        if (this.iSignificantTheoreticalFragmentions == null) {
            this.iSignificantTheoreticalFragmentions = this.getSignificantTheoreticalFragmentions();
        }
        return this.getMatchedIons(this.iSignificantTheoreticalFragmentions, lPeaksUsedByMascot);
    }

    private Vector getMatchedIons(Vector fmv, Peak[] aPeaks) {
        Vector<FragmentIon> lMatchedIons = new Vector<FragmentIon>();
        for (FragmentIon fi : fmv) {
            if (fi.hasBeenMatched() || !fi.isMatch(aPeaks, this.iFragmentMassErrorMargin)) continue;
            lMatchedIons.add(fi);
        }
        return lMatchedIons;
    }

    public Peak[] reducePeaks(Peak[] aPeaks, Vector aFragmentions) {
        int j;
        Vector<Double> lFragmentionsMasses = new Vector<Double>();
        for (int i = 0; i < aFragmentions.size(); ++i) {
            FragmentIon fm = (FragmentIon)aFragmentions.get(i);
            double lPeak = fm.getMZ() + fm.getTheoreticalExperimantalMassError();
            boolean lIsNotMatchedYet = true;
            if (lFragmentionsMasses.size() != 0) {
                for (j = 0; j < lFragmentionsMasses.size(); ++j) {
                    double lDouble = (Double)lFragmentionsMasses.elementAt(j);
                    if (lPeak != lDouble) continue;
                    lIsNotMatchedYet = false;
                }
            }
            if (!lIsNotMatchedYet) continue;
            lFragmentionsMasses.add(new Double(lPeak));
        }
        Peak[] lReducedPeaks = new Peak[aPeaks.length - lFragmentionsMasses.size()];
        int lCountReducedPeaks = 0;
        for (int i = 0; i < aPeaks.length; ++i) {
            Peak lPeak = new Peak(aPeaks[i].getMZ(), aPeaks[i].getIntensity());
            boolean lPeakHasBeenMatched = false;
            for (j = 0; j < lFragmentionsMasses.size(); ++j) {
                double lTemp = (Double)lFragmentionsMasses.get(j);
                if (lTemp != lPeak.getMZ()) continue;
                lPeakHasBeenMatched = true;
                break;
            }
            if (lPeakHasBeenMatched) continue;
            lReducedPeaks[lCountReducedPeaks] = lPeak;
            ++lCountReducedPeaks;
        }
        return lReducedPeaks;
    }

    public Vector getSignificantMatchedIonsAboveIntensityThreshold(Peak[] aPeaks, double aMaxIntensity, double aIntensityPercentage) {
        if (this.iSignificantTheoreticalFragmentions == null) {
            this.iSignificantTheoreticalFragmentions = this.getSignificantTheoreticalFragmentions();
        }
        return this.getMatchedIons(this.iSignificantTheoreticalFragmentions, aPeaks, aMaxIntensity, aIntensityPercentage);
    }

    public Vector getSignificantTheoreticalFragmentions() {
        Vector<FragmentIonImpl> lAllSignificantIons = new Vector<FragmentIonImpl>();
        for (int i = 0; i < this.iIonSeriesFound.length; ++i) {
            if (this.iIonSeriesFound[i] == 0) continue;
            FragmentIonImpl[] fma = this.getFragmentIons(i);
            for (int j = 0; j < fma.length; ++j) {
                if (this.iIonSeriesFound[i] == 1) {
                    fma[j].setImportance(1);
                }
                if (this.iIonSeriesFound[i] == 2) {
                    fma[j].setImportance(2);
                }
                lAllSignificantIons.add(fma[j]);
            }
        }
        return lAllSignificantIons;
    }

    public FragmentIonImpl[] getBNeutralLossIons() {
        Vector<FragmentIonImpl> lNeutralLossIons = new Vector<FragmentIonImpl>();
        for (int i = 0; i < this.iMods.length; ++i) {
            double lNeutralLossMass;
            Modification lMod = this.iMods[i];
            if (lMod == null || !(lMod instanceof VariableModification) || !((lNeutralLossMass = ((VariableModification)lMod).getNeutralLoss()) > 0.0)) continue;
            try {
                for (int j = i - 1; j < this.iBions.length; ++j) {
                    FragmentIonImpl lBion = this.iBions[j].clone();
                    lBion.setMZ(lBion.getMZ() - lNeutralLossMass);
                    lBion.setType(lBion.getType() + "-" + lMod.getShortType() + "-");
                    lNeutralLossIons.add(lBion);
                }
                continue;
            }
            catch (CloneNotSupportedException e) {
                logger.error(e.getMessage(), e);
            }
        }
        if (lNeutralLossIons.size() > 0) {
            return lNeutralLossIons.toArray(new FragmentIonImpl[lNeutralLossIons.size()]);
        }
        return null;
    }

    public FragmentIonImpl[] getYNeutralLossIons() {
        Vector<FragmentIonImpl> lNeutralLossIons = new Vector<FragmentIonImpl>();
        for (int i = 0; i < this.iMods.length; ++i) {
            double lNeutralLossMass;
            Modification lMod = this.iMods[i];
            if (lMod == null || !(lMod instanceof VariableModification) || !((lNeutralLossMass = ((VariableModification)lMod).getNeutralLoss()) > 0.0)) continue;
            try {
                for (int j = this.iMods.length - i - 1; j < this.iYions.length; ++j) {
                    FragmentIonImpl lYion = this.iYions[j].clone();
                    lYion.setMZ(lYion.getMZ() - lNeutralLossMass);
                    lYion.setType(lYion.getType() + "-" + lMod.getShortType());
                    lNeutralLossIons.add(lYion);
                }
                continue;
            }
            catch (CloneNotSupportedException e) {
                logger.error(e.getMessage(), e);
            }
        }
        if (lNeutralLossIons.size() > 0) {
            return lNeutralLossIons.toArray(new FragmentIonImpl[lNeutralLossIons.size()]);
        }
        return null;
    }

    private FragmentIonImpl[] getFragmentIons(int aIonSeriesIndex) {
        FragmentIonImpl[] lFragmentIons = null;
        switch (aIonSeriesIndex) {
            case 0: {
                lFragmentIons = this.getASeries();
                break;
            }
            case 1: {
                throw new MascotDatfileException("Ionseries index = 1; this is a placeholder!");
            }
            case 2: {
                lFragmentIons = this.getADoubleSeries();
                break;
            }
            case 3: {
                lFragmentIons = this.getBSeries();
                break;
            }
            case 4: {
                throw new MascotDatfileException("Ionseries index = 4; this is a placeholder!");
            }
            case 5: {
                lFragmentIons = this.getBDoubleSeries();
                break;
            }
            case 6: {
                lFragmentIons = this.getYSeries();
                break;
            }
            case 7: {
                throw new MascotDatfileException("Ionseries index = 7; this is a placeholder!");
            }
            case 8: {
                lFragmentIons = this.getYDoubleSeries();
                break;
            }
            case 9: {
                lFragmentIons = this.getCions();
                break;
            }
            case 10: {
                lFragmentIons = this.getCDoubleions();
                break;
            }
            case 11: {
                lFragmentIons = this.getXions();
                break;
            }
            case 12: {
                lFragmentIons = this.getXDoubleions();
                break;
            }
            case 13: {
                lFragmentIons = this.getZions();
                break;
            }
            case 14: {
                lFragmentIons = this.getZDoubleions();
                break;
            }
            case 15: {
                lFragmentIons = this.getZHions();
                break;
            }
            case 16: {
                lFragmentIons = this.getZHDoubleions();
                break;
            }
            case 17: {
                lFragmentIons = this.getZHHions();
                break;
            }
            case 18: {
                lFragmentIons = this.getZHHDoubleions();
                break;
            }
            default: {
                throw new MascotDatfileException("Ionseries index '" + aIonSeriesIndex + "' not handled by MascotDatfile!!");
            }
        }
        return lFragmentIons;
    }

    private FragmentIonImpl[] getASeries() {
        FragmentIonImpl[] lAions = this.getAions();
        FragmentIonImpl[] lAH2O = this.getAH2Oions();
        FragmentIonImpl[] lANH3 = this.getANH3ions();
        int lASeriesLength = lAions.length;
        if (lAH2O != null) {
            lASeriesLength += lAH2O.length;
        }
        if (lANH3 != null) {
            lASeriesLength += lANH3.length;
        }
        FragmentIonImpl[] lASeries = new FragmentIonImpl[lASeriesLength];
        System.arraycopy(lAions, 0, lASeries, 0, lAions.length);
        int lASeriesIndex = lAions.length;
        if (lANH3 != null) {
            System.arraycopy(lANH3, 0, lASeries, lASeriesIndex, lANH3.length);
            lASeriesIndex += lANH3.length;
        }
        if (lAH2O != null) {
            System.arraycopy(lAH2O, 0, lASeries, lASeriesIndex, lAH2O.length);
            lASeriesIndex += lAH2O.length;
        }
        return lASeries;
    }

    public FragmentIonImpl[] getAH2Oions() {
        int lStart = this.getH2OStartB();
        FragmentIonImpl[] lAH2Oions = null;
        if (lStart != this.iBions.length) {
            FragmentIonImpl[] lAions = this.getAions();
            lAH2Oions = new FragmentIonImpl[this.iBions.length - lStart];
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lAH2Oions[lCount] = new FragmentIonImpl(lAions[i].getMZ() - 18.010565, this.iFragmentMassErrorMargin, 15, i + 1, "a-H2O");
                ++lCount;
            }
        }
        return lAH2Oions;
    }

    public FragmentIonImpl[] getANH3ions() {
        int lStart = this.getNH3StartB();
        FragmentIonImpl[] lANH3ions = null;
        if (lStart != this.iBions.length) {
            lANH3ions = new FragmentIonImpl[this.iBions.length - lStart];
            FragmentIonImpl[] lAions = this.getAions();
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lANH3ions[lCount] = new FragmentIonImpl(lAions[i].getMZ() - 17.026549, this.iFragmentMassErrorMargin, 17, i + 1, "a-NH3");
                ++lCount;
            }
        }
        return lANH3ions;
    }

    private FragmentIonImpl[] getADoubleSeries() {
        FragmentIonImpl[] lADouble = this.getADoubleions();
        FragmentIonImpl[] lADoubleH2O = this.getADoubleH2Oions();
        FragmentIonImpl[] lADoubleNH3 = this.getADoubleNH3ions();
        int lADoubleSeriesLength = lADouble.length;
        if (lADoubleH2O != null) {
            lADoubleSeriesLength += lADoubleH2O.length;
        }
        if (lADoubleNH3 != null) {
            lADoubleSeriesLength += lADoubleNH3.length;
        }
        FragmentIonImpl[] lADoubleSeries = new FragmentIonImpl[lADoubleSeriesLength];
        System.arraycopy(lADouble, 0, lADoubleSeries, 0, lADouble.length);
        int lADoubleSeriesIndex = lADouble.length;
        if (lADoubleNH3 != null) {
            System.arraycopy(lADoubleNH3, 0, lADoubleSeries, lADoubleSeriesIndex, lADoubleNH3.length);
            lADoubleSeriesIndex += lADoubleNH3.length;
        }
        if (lADoubleH2O != null) {
            System.arraycopy(lADoubleH2O, 0, lADoubleSeries, lADoubleSeriesIndex, lADoubleH2O.length);
            lADoubleSeriesIndex += lADoubleH2O.length;
        }
        return lADoubleSeries;
    }

    public FragmentIonImpl[] getADoubleions() {
        FragmentIonImpl[] lAions = this.getAions();
        FragmentIonImpl[] lADoubleIons = new FragmentIonImpl[lAions.length];
        for (int i = 0; i < lAions.length; ++i) {
            lADoubleIons[i] = new FragmentIonImpl((lAions[i].getMZ() + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 14, i + 1, "a++");
        }
        return lADoubleIons;
    }

    public FragmentIonImpl[] getAions() {
        FragmentIonImpl[] lAions = new FragmentIonImpl[this.iBions.length];
        for (int i = 0; i < this.iBions.length; ++i) {
            lAions[i] = new FragmentIonImpl(this.iBions[i].getMZ() - 27.994915, this.iFragmentMassErrorMargin, 13, i + 1, "a");
        }
        return lAions;
    }

    public FragmentIonImpl[] getADoubleH2Oions() {
        int lStart = this.getH2OStartB();
        FragmentIonImpl[] lADoubleH2Oions = null;
        if (lStart != this.iBions.length) {
            lADoubleH2Oions = new FragmentIonImpl[this.iBions.length - lStart];
            FragmentIonImpl[] lAions = this.getAions();
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lADoubleH2Oions[lCount] = new FragmentIonImpl((lAions[i].getMZ() - 18.010565 + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 16, i + 1, "a++-H2O");
                ++lCount;
            }
        }
        return lADoubleH2Oions;
    }

    public FragmentIonImpl[] getADoubleNH3ions() {
        int lStart = this.getNH3StartB();
        FragmentIonImpl[] lADoubleNH3ions = null;
        if (lStart != this.iBions.length) {
            lADoubleNH3ions = new FragmentIonImpl[this.iBions.length - lStart];
            FragmentIonImpl[] lAions = this.getAions();
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lADoubleNH3ions[lCount] = new FragmentIonImpl((lAions[i].getMZ() - 17.026549 + 1.0) / 2.0, this.iFragmentMassErrorMargin, 18, i + 1, "a++-NH3");
                ++lCount;
            }
        }
        return lADoubleNH3ions;
    }

    private FragmentIonImpl[] getBSeries() {
        FragmentIonImpl[] lBH2O = this.getBH2Oions();
        FragmentIonImpl[] lBNH3 = this.getBNH3ions();
        FragmentIonImpl[] lBNL = this.getBNeutralLossIons();
        int lBSeriesLength = this.iBions.length;
        if (lBH2O != null) {
            lBSeriesLength += lBH2O.length;
        }
        if (lBNH3 != null) {
            lBSeriesLength += lBNH3.length;
        }
        if (lBNL != null) {
            lBSeriesLength += lBNL.length;
        }
        FragmentIonImpl[] lBSeries = new FragmentIonImpl[lBSeriesLength];
        System.arraycopy(this.iBions, 0, lBSeries, 0, this.iBions.length);
        int lBSeriesIndex = this.iBions.length;
        if (lBNH3 != null) {
            System.arraycopy(lBNH3, 0, lBSeries, lBSeriesIndex, lBNH3.length);
            lBSeriesIndex += lBNH3.length;
        }
        if (lBH2O != null) {
            System.arraycopy(lBH2O, 0, lBSeries, lBSeriesIndex, lBH2O.length);
            lBSeriesIndex += lBH2O.length;
        }
        if (lBNL != null) {
            System.arraycopy(lBNL, 0, lBSeries, lBSeriesIndex, lBNL.length);
            lBSeriesIndex += lBNL.length;
        }
        return lBSeries;
    }

    public FragmentIonImpl[] getBH2Oions() {
        int lStart = this.getH2OStartB();
        FragmentIonImpl[] lBH2Oions = null;
        if (lStart != this.iBions.length) {
            lBH2Oions = new FragmentIonImpl[this.iBions.length - lStart];
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lBH2Oions[lCount] = new FragmentIonImpl(this.iBions[i].getMZ() - 18.010565, this.iFragmentMassErrorMargin, 3, i + 1, "b-H2O");
                ++lCount;
            }
        }
        return lBH2Oions;
    }

    public FragmentIonImpl[] getBNH3ions() {
        int lStart = this.getNH3StartB();
        FragmentIonImpl[] lBNH3ions = null;
        if (lStart != this.iBions.length) {
            lBNH3ions = new FragmentIonImpl[this.iBions.length - lStart];
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lBNH3ions[lCount] = new FragmentIonImpl(this.iBions[i].getMZ() - 17.026549, this.iFragmentMassErrorMargin, 5, i + 1, "b-NH3");
                ++lCount;
            }
        }
        return lBNH3ions;
    }

    private FragmentIonImpl[] getBDoubleSeries() {
        FragmentIonImpl[] lBDouble = this.getBDoubleions();
        FragmentIonImpl[] lBDoubleH2O = this.getBDoubleH2Oions();
        FragmentIonImpl[] lBDoubleNH3 = this.getBDoubleNH3ions();
        int lBDoubleSeriesLength = lBDouble.length;
        if (lBDoubleH2O != null) {
            lBDoubleSeriesLength += lBDoubleH2O.length;
        }
        if (lBDoubleNH3 != null) {
            lBDoubleSeriesLength += lBDoubleNH3.length;
        }
        FragmentIonImpl[] lBDoubleSeries = new FragmentIonImpl[lBDoubleSeriesLength];
        System.arraycopy(lBDouble, 0, lBDoubleSeries, 0, lBDouble.length);
        int lBDoubleSeriesIndex = lBDouble.length;
        if (lBDoubleNH3 != null) {
            System.arraycopy(lBDoubleNH3, 0, lBDoubleSeries, lBDoubleSeriesIndex, lBDoubleNH3.length);
            lBDoubleSeriesIndex += lBDoubleNH3.length;
        }
        if (lBDoubleH2O != null) {
            System.arraycopy(lBDoubleH2O, 0, lBDoubleSeries, lBDoubleSeriesIndex, lBDoubleH2O.length);
            lBDoubleSeriesIndex += lBDoubleH2O.length;
        }
        return lBDoubleSeries;
    }

    public FragmentIonImpl[] getBDoubleions() {
        FragmentIonImpl[] lBDoubleIons = new FragmentIonImpl[this.iBions.length];
        for (int i = 0; i < this.iBions.length; ++i) {
            lBDoubleIons[i] = new FragmentIonImpl((this.iBions[i].getMZ() + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 2, i + 1, "b++");
        }
        return lBDoubleIons;
    }

    public FragmentIonImpl[] getBDoubleH2Oions() {
        int lStart = this.getH2OStartB();
        FragmentIonImpl[] lBDoubleH2Oions = null;
        if (lStart != this.iBions.length) {
            lBDoubleH2Oions = new FragmentIonImpl[this.iBions.length - lStart];
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lBDoubleH2Oions[lCount] = new FragmentIonImpl((this.iBions[i].getMZ() - 18.010565 + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 4, i + 1, "b++-H2O");
                ++lCount;
            }
        }
        return lBDoubleH2Oions;
    }

    public FragmentIonImpl[] getBDoubleNH3ions() {
        int lStart = this.getNH3StartB();
        FragmentIonImpl[] lBDoubleNH3ions = null;
        if (lStart != this.iBions.length) {
            lBDoubleNH3ions = new FragmentIonImpl[this.iBions.length - lStart];
            int lCount = 0;
            for (int i = lStart; i < this.iBions.length; ++i) {
                lBDoubleNH3ions[lCount] = new FragmentIonImpl((this.iBions[i].getMZ() - 17.026549 + 1.0) / 2.0, this.iFragmentMassErrorMargin, 6, i + 1, "b++-NH3");
                ++lCount;
            }
        }
        return lBDoubleNH3ions;
    }

    private FragmentIonImpl[] getYSeries() {
        FragmentIonImpl[] lYH2O = this.getYH2Oions();
        FragmentIonImpl[] lYNH3 = this.getYNH3ions();
        FragmentIonImpl[] lYNL = this.getYNeutralLossIons();
        int lYSeriesLength = this.iYions.length;
        if (lYH2O != null) {
            lYSeriesLength += lYH2O.length;
        }
        if (lYNH3 != null) {
            lYSeriesLength += lYNH3.length;
        }
        if (lYNL != null) {
            lYSeriesLength += lYNL.length;
        }
        FragmentIonImpl[] lYSeries = new FragmentIonImpl[lYSeriesLength];
        System.arraycopy(this.iYions, 0, lYSeries, 0, this.iYions.length);
        int lYSeriesIndex = this.iYions.length;
        if (lYNH3 != null) {
            System.arraycopy(lYNH3, 0, lYSeries, lYSeriesIndex, lYNH3.length);
            lYSeriesIndex += lYNH3.length;
        }
        if (lYH2O != null) {
            System.arraycopy(lYH2O, 0, lYSeries, lYSeriesIndex, lYH2O.length);
            lYSeriesIndex += lYH2O.length;
        }
        if (lYNL != null) {
            System.arraycopy(lYNL, 0, lYSeries, lYSeriesIndex, lYNL.length);
            lYSeriesIndex += lYNL.length;
        }
        return lYSeries;
    }

    public FragmentIonImpl[] getYH2Oions() {
        int lStart = this.getH2OStartY();
        FragmentIonImpl[] lYH2Oions = null;
        if (lStart != 0) {
            lYH2Oions = new FragmentIonImpl[lStart];
            int lCount = 0;
            for (int i = this.iYions.length - lStart; i < this.iYions.length; ++i) {
                lYH2Oions[lCount] = new FragmentIonImpl(this.iYions[i].getMZ() - 18.010565, this.iFragmentMassErrorMargin, 9, i + 1, "y-H2O");
                ++lCount;
            }
        }
        return lYH2Oions;
    }

    public FragmentIonImpl[] getYNH3ions() {
        int lStart = this.getNH3StartY();
        FragmentIonImpl[] lYNH3ions = null;
        if (lStart != 0) {
            lYNH3ions = new FragmentIonImpl[lStart];
            int lCount = 0;
            for (int i = this.iYions.length - lStart; i < this.iYions.length; ++i) {
                lYNH3ions[lCount] = new FragmentIonImpl(this.iYions[i].getMZ() - 17.026549, this.iFragmentMassErrorMargin, 11, i + 1, "y-NH3");
                ++lCount;
            }
        }
        return lYNH3ions;
    }

    private FragmentIonImpl[] getYDoubleSeries() {
        FragmentIonImpl[] lYDouble = this.getYDoubleions();
        FragmentIonImpl[] lYDoubleH2O = this.getYDoubleH2Oions();
        FragmentIonImpl[] lYDoubleNH3 = this.getYDoubleNH3ions();
        int lYDoubleSeriesLength = lYDouble.length;
        if (lYDoubleH2O != null) {
            lYDoubleSeriesLength += lYDoubleH2O.length;
        }
        if (lYDoubleNH3 != null) {
            lYDoubleSeriesLength += lYDoubleNH3.length;
        }
        FragmentIonImpl[] lYDoubleSeries = new FragmentIonImpl[lYDoubleSeriesLength];
        System.arraycopy(lYDouble, 0, lYDoubleSeries, 0, lYDouble.length);
        int lYDoubleSeriesIndex = lYDouble.length;
        if (lYDoubleNH3 != null) {
            System.arraycopy(lYDoubleNH3, 0, lYDoubleSeries, lYDoubleSeriesIndex, lYDoubleNH3.length);
            lYDoubleSeriesIndex += lYDoubleNH3.length;
        }
        if (lYDoubleH2O != null) {
            System.arraycopy(lYDoubleH2O, 0, lYDoubleSeries, lYDoubleSeriesIndex, lYDoubleH2O.length);
            lYDoubleSeriesIndex += lYDoubleH2O.length;
        }
        return lYDoubleSeries;
    }

    public FragmentIonImpl[] getYDoubleions() {
        FragmentIonImpl[] lY2ions = new FragmentIonImpl[this.iYions.length];
        for (int i = 0; i < this.iYions.length; ++i) {
            lY2ions[i] = new FragmentIonImpl((this.iYions[i].getMZ() + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 8, i + 1, "y++");
        }
        return lY2ions;
    }

    public FragmentIonImpl[] getYDoubleH2Oions() {
        int lStart = this.getH2OStartY();
        FragmentIonImpl[] lYDoubleH2Oions = null;
        if (lStart != 0) {
            lYDoubleH2Oions = new FragmentIonImpl[lStart];
            int lCount = 0;
            for (int i = this.iYions.length - lStart; i < this.iYions.length; ++i) {
                lYDoubleH2Oions[lCount] = new FragmentIonImpl((this.iYions[i].getMZ() - 18.010565 + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 10, i + 1, "y++-H2O");
                ++lCount;
            }
        }
        return lYDoubleH2Oions;
    }

    public FragmentIonImpl[] getYDoubleNH3ions() {
        int lStart = this.getNH3StartY();
        FragmentIonImpl[] lYDoubleNH3ions = null;
        if (lStart != 0) {
            lYDoubleNH3ions = new FragmentIonImpl[lStart];
            int lCount = 0;
            for (int i = this.iYions.length - lStart; i < this.iYions.length; ++i) {
                lYDoubleNH3ions[lCount] = new FragmentIonImpl((this.iYions[i].getMZ() - 17.026549 + 1.0) / 2.0, this.iFragmentMassErrorMargin, 12, i + 1, "y++-NH3");
                ++lCount;
            }
        }
        return lYDoubleNH3ions;
    }

    public FragmentIonImpl[] getCDoubleions() {
        FragmentIonImpl[] lCions = this.getCions();
        FragmentIonImpl[] lCDoubleIons = new FragmentIonImpl[lCions.length];
        for (int i = 0; i < lCions.length; ++i) {
            lCDoubleIons[i] = new FragmentIonImpl((lCions[i].getMZ() + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 22, i + 1, "c++");
        }
        return lCDoubleIons;
    }

    public FragmentIonImpl[] getCions() {
        FragmentIonImpl[] lCions = new FragmentIonImpl[this.iBions.length];
        for (int i = 0; i < this.iBions.length; ++i) {
            lCions[i] = new FragmentIonImpl(this.iBions[i].getMZ() + 17.026549, this.iFragmentMassErrorMargin, 21, i + 1, "c");
        }
        return lCions;
    }

    public FragmentIonImpl[] getXDoubleions() {
        FragmentIonImpl[] lXions = this.getXions();
        FragmentIonImpl[] lXDoubleIons = new FragmentIonImpl[lXions.length];
        for (int i = 0; i < lXions.length; ++i) {
            lXDoubleIons[i] = new FragmentIonImpl((lXions[i].getMZ() + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 20, i + 1, "x++");
        }
        return lXDoubleIons;
    }

    public FragmentIonImpl[] getXions() {
        FragmentIonImpl[] lXions = new FragmentIonImpl[this.iYions.length];
        for (int i = 0; i < this.iYions.length; ++i) {
            lXions[i] = new FragmentIonImpl(this.iYions[i].getMZ() + 25.979265, this.iFragmentMassErrorMargin, 19, i + 1, "x");
        }
        return lXions;
    }

    public FragmentIonImpl[] getZDoubleions() {
        FragmentIonImpl[] lZions = this.getZions();
        FragmentIonImpl[] lZDoubleIons = new FragmentIonImpl[lZions.length];
        for (int i = 0; i < lZions.length; ++i) {
            lZDoubleIons[i] = new FragmentIonImpl((lZions[i].getMZ() + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 24, i + 1, "z++");
        }
        return lZDoubleIons;
    }

    public FragmentIonImpl[] getZions() {
        FragmentIonImpl[] lZions = new FragmentIonImpl[this.iYions.length];
        for (int i = 0; i < this.iYions.length; ++i) {
            lZions[i] = new FragmentIonImpl(this.iYions[i].getMZ() - 17.026549, this.iFragmentMassErrorMargin, 23, i + 1, "z");
        }
        return lZions;
    }

    public FragmentIonImpl[] getZHions() {
        FragmentIonImpl[] lZHions = new FragmentIonImpl[this.iYions.length];
        for (int i = 0; i < this.iYions.length; ++i) {
            lZHions[i] = new FragmentIonImpl(this.iYions[i].getMZ() - 17.026549 + 1.007825, this.iFragmentMassErrorMargin, 25, i + 1, "zH");
        }
        return lZHions;
    }

    public FragmentIonImpl[] getZHDoubleions() {
        FragmentIonImpl[] lZHions = this.getZions();
        FragmentIonImpl[] lZDoubleIons = new FragmentIonImpl[lZHions.length];
        for (int i = 0; i < lZHions.length; ++i) {
            lZDoubleIons[i] = new FragmentIonImpl((lZHions[i].getMZ() + 1.007825 + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 26, i + 1, "zH++");
        }
        return lZDoubleIons;
    }

    public FragmentIonImpl[] getZHHions() {
        FragmentIonImpl[] lZHHions = new FragmentIonImpl[this.iYions.length];
        for (int i = 0; i < this.iYions.length; ++i) {
            lZHHions[i] = new FragmentIonImpl(this.iYions[i].getMZ() - 17.026549 + 1.007825 + 1.007825, this.iFragmentMassErrorMargin, 27, i + 1, "zHH");
        }
        return lZHHions;
    }

    public FragmentIonImpl[] getZHHDoubleions() {
        FragmentIonImpl[] lZHions = this.getZions();
        FragmentIonImpl[] lZDoubleIons = new FragmentIonImpl[lZHions.length];
        for (int i = 0; i < lZHions.length; ++i) {
            lZDoubleIons[i] = new FragmentIonImpl((lZHions[i].getMZ() + 1.007825 + 1.007825 + 1.007825) / 2.0, this.iFragmentMassErrorMargin, 28, i + 1, "zHH++");
        }
        return lZDoubleIons;
    }

    private Vector getMatchedIons(Vector fmv, Peak[] aPeaks, double aMaxIntensity, double aIntensityPercentage) {
        Vector<FragmentIon> lMatchedIons = new Vector<FragmentIon>();
        for (FragmentIon fi : fmv) {
            if (fi.hasBeenMatched() || !fi.isMatchAboveIntensityThreshold(aPeaks, aMaxIntensity, aIntensityPercentage, this.iFragmentMassErrorMargin)) continue;
            lMatchedIons.add(fi);
        }
        return lMatchedIons;
    }

    public Vector getNonSignificantMatchedIonsAboveIntensityThreshold(Peak[] aPeaks, double aMaxIntensity, double aIntensityPercentage) {
        if (this.iNonSignificantTheoreticalFragmentions == null) {
            this.iNonSignificantTheoreticalFragmentions = this.getNonSignificantTheoreticalFragmentions();
        }
        return this.getMatchedIons(this.iNonSignificantTheoreticalFragmentions, aPeaks, aMaxIntensity, this.iIntensityPercentage);
    }

    public Vector getNonSignificantTheoreticalFragmentions() {
        Vector<FragmentIonImpl> lAllNonSignificantIons = new Vector<FragmentIonImpl>();
        for (int i = 0; i < this.iIonSeriesRules.length; ++i) {
            if (this.iIonSeriesFound[this.iIonSeriesRules[i]] != 0) continue;
            FragmentIonImpl[] fma = this.getFragmentIons(this.iIonSeriesRules[i]);
            for (int j = 0; j < fma.length; ++j) {
                fma[j].setImportance(0);
                lAllNonSignificantIons.add(fma[j]);
            }
        }
        return lAllNonSignificantIons;
    }

    public Vector getPrecursorAndImmoniumIons() {
        Vector<FragmentIonImpl> lPrecAndImmoIons = new Vector<FragmentIonImpl>();
        if (this.iPrecursorMZ != 0.0) {
            lPrecAndImmoIons.add(new FragmentIonImpl(this.iPrecursorMZ, this.iFragmentMassErrorMargin, 31, 0, "Prec " + this.iPrecursorCharge));
            lPrecAndImmoIons.add(new FragmentIonImpl(this.iPrecursorMZ - 18.010565 / Double.parseDouble(this.iPrecursorCharge.substring(0, 1)), this.iFragmentMassErrorMargin, 30, 0, "Prec-H2O " + this.iPrecursorCharge));
            lPrecAndImmoIons.add(new FragmentIonImpl(this.iPrecursorMZ - 17.026549 / Double.parseDouble(this.iPrecursorCharge.substring(0, 1)), this.iFragmentMassErrorMargin, 30, 0, "Prec-NH3 " + this.iPrecursorCharge));
        }
        if (this.iSequence.indexOf(65) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(44.0, 0.5, 32, 0, "iA"));
        }
        if (this.iSequence.indexOf(82) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(129.0, 0.5, 32, 0, "iR"));
        }
        if (this.iSequence.indexOf(78) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(87.0, 0.5, 32, 0, "iN"));
        }
        if (this.iSequence.indexOf(68) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(88.0, 0.5, 32, 0, "iD"));
        }
        if (this.iSequence.indexOf(67) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(76.0, 0.5, 32, 0, "iC"));
        }
        if (this.iSequence.indexOf(69) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(102.0, 0.5, 32, 0, "iE"));
        }
        if (this.iSequence.indexOf(81) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(101.0, 0.5, 32, 0, "iQ"));
        }
        if (this.iSequence.indexOf(71) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(30.0, 0.5, 32, 0, "iG"));
        }
        if (this.iSequence.indexOf(72) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(110.0, 0.5, 32, 0, "iH"));
        }
        if (this.iSequence.indexOf(73) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(86.0, 0.5, 32, 0, "iI"));
        }
        if (this.iSequence.indexOf(76) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(86.0, 0.5, 32, 0, "iL"));
        }
        if (this.iSequence.indexOf(75) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(101.0, 0.5, 32, 0, "iK"));
        }
        if (this.iSequence.indexOf(77) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(104.0, 0.5, 32, 0, "iM"));
        }
        if (this.iSequence.indexOf(70) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(120.0, 0.5, 32, 0, "iF"));
        }
        if (this.iSequence.indexOf(80) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(70.0, 0.5, 32, 0, "iP"));
        }
        if (this.iSequence.indexOf(83) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(60.0, 0.5, 32, 0, "iS"));
        }
        if (this.iSequence.indexOf(84) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(74.0, 0.5, 32, 0, "iT"));
        }
        if (this.iSequence.indexOf(87) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(159.0, 0.5, 32, 0, "iW"));
        }
        if (this.iSequence.indexOf(89) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(136.0, 0.5, 32, 0, "iY"));
        }
        if (this.iSequence.indexOf(86) != -1) {
            lPrecAndImmoIons.add(new FragmentIonImpl(72.0, 0.5, 32, 0, "iV"));
        }
        return lPrecAndImmoIons;
    }

    public Vector getAllTheoreticalFragmentions() {
        return this.getTheoreticalFragmentions(this.iIonSeriesRules);
    }

    public Vector getTheoreticalFragmentions(int[] aIonTypes) {
        Vector<FragmentIonImpl> lAllIons = new Vector<FragmentIonImpl>();
        for (int i = 0; i < aIonTypes.length; ++i) {
            int index = aIonTypes[i];
            FragmentIonImpl[] fma = this.getFragmentIons(index);
            for (int j = 0; j < fma.length; ++j) {
                lAllIons.add(fma[j]);
            }
        }
        return lAllIons;
    }

    public int[] getMascotIonCoverage(Peak[] aPeaks, int aNumberOfPeaksUsed) {
        boolean work = false;
        if (this.iPeaks == null || this.iMascotCoverage == null) {
            work = true;
        } else if (this.iPeaks != aPeaks) {
            work = true;
        }
        if (work) {
            this.iPeaks = aPeaks;
            Vector lFragmentIons = this.getMatchedIonsByMascot(this.iPeaks, aNumberOfPeaksUsed);
            this.iMascotCoverage = this.calculateCoverage(lFragmentIons);
        }
        return this.iMascotCoverage;
    }

    private int[] calculateCoverage(Vector aFragmentIons) {
        int lLength = this.iSequence.length();
        int[] lCoverage = new int[3];
        int[] lB = new int[lLength - 1];
        int[] lY = new int[lLength - 1];
        int[] lAll = new int[lLength];
        for (FragmentIon fm : aFragmentIons) {
            int lNumber = fm.getNumber() - 1;
            if (0 < fm.getID() && fm.getID() < 7) {
                if (lB[lNumber] == 0) {
                    lB[lNumber] = 1;
                }
                if (lAll[lNumber] != 0) continue;
                lAll[lNumber] = 1;
                continue;
            }
            if (12 < fm.getID() && fm.getID() < 19) {
                if (lB[lNumber] == 0) {
                    lB[lNumber] = 1;
                }
                if (lAll[lNumber] != 0) continue;
                lAll[lNumber] = 1;
                continue;
            }
            if (6 < fm.getID() && fm.getID() < 13) {
                if (lY[lNumber] == 0) {
                    lY[lNumber] = 1;
                }
                if (lAll[lLength - (lNumber + 1)] != 0) continue;
                lAll[lLength - (lNumber + 1)] = 1;
                continue;
            }
            if (20 < fm.getID() && fm.getID() < 23) {
                if (lB[lNumber] == 0) {
                    lB[lNumber] = 1;
                }
                if (lAll[lNumber] != 0) continue;
                lAll[lNumber] = 1;
                continue;
            }
            if (18 < fm.getID() && fm.getID() < 21) {
                if (lY[lNumber] == 0) {
                    lY[lNumber] = 1;
                }
                if (lAll[lLength - (lNumber + 1)] != 0) continue;
                lAll[lLength - (lNumber + 1)] = 1;
                continue;
            }
            if (22 >= fm.getID() || fm.getID() >= 25) continue;
            if (lY[lNumber] == 0) {
                lY[lNumber] = 1;
            }
            if (lAll[lLength - (lNumber + 1)] != 0) continue;
            lAll[lLength - (lNumber + 1)] = 1;
        }
        lCoverage[0] = this.sumIntArray(lB);
        lCoverage[1] = this.sumIntArray(lY);
        lCoverage[2] = this.sumIntArray(lAll);
        return lCoverage;
    }

    private int sumIntArray(int[] aCoverage) {
        int lCount = 0;
        for (int i = 0; i < aCoverage.length; ++i) {
            lCount += aCoverage[i];
        }
        return lCount;
    }

    public Vector getMatchedBYions(Peak[] aPeaks) {
        int i;
        this.resetPreviousMatching();
        Vector<FragmentIonImpl> lBYions = new Vector<FragmentIonImpl>();
        for (i = 0; i < this.iBions.length; ++i) {
            FragmentIonImpl lBion = this.iBions[i];
            lBion.setImportance(2);
            lBYions.add(lBion);
        }
        for (i = 0; i < this.iYions.length; ++i) {
            FragmentIonImpl lYion = this.iYions[i];
            lYion.setImportance(2);
            lBYions.add(lYion);
        }
        return this.getMatchedIons(lBYions, aPeaks);
    }

    public static void main(String[] args) {
        MascotDatfile mdf = new MascotDatfile("/Users/kenny/Proteomics/Projects/1002/0210_mascotdatfile_mod_error/F046001.dat");
        QueryToPeptideMap lQuery2P = mdf.getQueryToPeptideMap();
        PeptideHit ph = lQuery2P.getPeptideHitOfOneQuery(218, 1);
        PeptideHitAnnotation lPha = new PeptideHitAnnotation(ph.getSequence(), ph.getModifications(), mdf.getMasses(), mdf.getParametersSection(), ph.getIonSeriesFound());
        lPha.printIonSeries();
        PeptideToQueryMap lPeptide2Q = mdf.getPeptideToQueryMap();
        Vector Queries = lPeptide2Q.getQueriesByModifiedSequence(ph.getModifiedSequence());
        for (Query q : Queries) {
            System.out.println("First: check for matches by intensityThreshold.");
            Vector lIntensityMatchedIons = lPha.getSignificantMatchedIonsAboveIntensityThreshold(q.getPeakList(), q.getMaxIntensity(), 0.1);
            for (int i = 0; i < lIntensityMatchedIons.size(); ++i) {
                FragmentIon fm = (FragmentIon)lIntensityMatchedIons.get(i);
                System.out.println(fm.getType() + fm.getNumber() + " was matched in the mass spectrum with a mass error of " + fm.getTheoreticalExperimantalMassError());
            }
            System.out.println("Second: check for Mascot Matches.");
            Vector lMascotMatchedIons = lPha.getMatchedIonsByMascot(q.getPeakList(), ph.getPeaksUsedFromIons1());
            for (int i = 0; i < lMascotMatchedIons.size(); ++i) {
                FragmentIon fm = (FragmentIon)lMascotMatchedIons.get(i);
                System.out.println(fm.getType() + fm.getNumber() + " was matched in the mass spectrum with a mass error of " + fm.getTheoreticalExperimantalMassError());
            }
            System.out.println("Finally: Get the fused matches!");
            Vector lFusedMatchedIons = lPha.getFusedMatchedIons(q.getPeakList(), ph.getPeaksUsedFromIons1(), q.getMaxIntensity(), 0.1);
            for (int i = 0; i < lFusedMatchedIons.size(); ++i) {
                FragmentIon fm = (FragmentIon)lFusedMatchedIons.get(i);
                System.out.println(fm.getType() + fm.getNumber() + " was matched in the mass spectrum with a mass error of " + fm.getTheoreticalExperimantalMassError());
            }
        }
    }

    public void printIonSeries() {
        System.out.println("The theoretical b- and y-ion series of :" + this.iSequence + "\n\n");
        for (int i = 0; i < this.iYions.length; ++i) {
            System.out.println(this.iBions[i].getLabel() + "\t" + this.iBions[i].getMZ() + "\t||\t" + this.iYions[i].getLabel() + "\t" + this.iYions[i].getMZ());
        }
    }
}

