/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_model;

import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_model.DatfileTreeCellRenderer;
import com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_model.DatfileTreeModel;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DatfileTreePanel
extends JPanel {
    private static Logger logger = Logger.getLogger(DatfileTreePanel.class);
    private MascotDatfileInf iMascotDatfile = null;
    private JPanel jpanMain = null;
    private JSplitPane splt1 = null;
    private JPanel jpanSpectrum = null;
    private JPanel jpanTree = null;
    private SpectrumPanel iSpectrumPanel;
    private JTree treeDatfile = null;
    private DatfileTreeModel iDatfileTreeModel = null;

    public DatfileTreePanel(MascotDatfileInf aMascotDatfile) {
        this.iMascotDatfile = aMascotDatfile;
        this.setDefaultFilterSettingsOnTreeModel();
        this.construct();
    }

    private void construct() {
        this.removeAll();
        this.jpanMain = new JPanel(new BorderLayout());
        this.construct_jpanSpectrum();
        this.construct_jpanTree();
        this.splt1 = new JSplitPane(1, true, this.jpanTree, this.jpanSpectrum);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splt1, "Center");
        this.validate();
    }

    private void construct_jpanSpectrum() {
        this.jpanSpectrum = new JPanel(new BorderLayout());
        this.jpanSpectrum.add((Component)new JLabel("Click a PeptideHit in the Tree structure."), "Center");
        this.jpanSpectrum.validate();
    }

    private void construct_jpanTree() {
        this.treeDatfile = new JTree(this.iDatfileTreeModel);
        this.treeDatfile.setCellRenderer(new DatfileTreeCellRenderer());
        this.treeDatfile.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Object lTemp;
                TreePath path = DatfileTreePanel.this.treeDatfile.getSelectionPath();
                if (path != null && (lTemp = path.getLastPathComponent()) instanceof PeptideHit) {
                    PeptideHit lPeptideHit = (PeptideHit)lTemp;
                    Query lQuery = (Query)path.getParentPath().getLastPathComponent();
                    DatfileTreePanel.this.jpanSpectrum.removeAll();
                    DatfileTreePanel.this.iSpectrumPanel = new SpectrumPanel(lQuery.getMZArray(), lQuery.getIntensityArray(), lQuery.getPrecursorMZ(), lQuery.getChargeString(), lQuery.getTitle());
                    PeptideHitAnnotation pha = lPeptideHit.getPeptideHitAnnotation(DatfileTreePanel.this.iMascotDatfile.getMasses(), DatfileTreePanel.this.iMascotDatfile.getParametersSection(), lQuery.getPrecursorMZ(), lQuery.getChargeString());
                    Vector annotations = pha.getMatchedIonsByMascot(lQuery.getPeakList(), lPeptideHit.getPeaksUsedFromIons1());
                    DatfileTreePanel.this.iSpectrumPanel.setAnnotations(annotations);
                    JPanel jpanPeptideHit = new JPanel();
                    BoxLayout lBoxLayout = new BoxLayout(jpanPeptideHit, 2);
                    String lFilterSettingThresholdString = DatfileTreePanel.this.iDatfileTreeModel.getFilterSettingThresholdString();
                    double lFilterSettingThreshold = DatfileTreePanel.this.iDatfileTreeModel.getFilterSettingThreshold();
                    MathContext lMathContext = new MathContext(3);
                    BigDecimal lThreshold = new BigDecimal(lPeptideHit.calculateIdentityThreshold(lFilterSettingThreshold), lMathContext);
                    jpanPeptideHit.add(Box.createHorizontalStrut(10));
                    jpanPeptideHit.add(new JLabel("Modified Sequence: " + lPeptideHit.getModifiedSequence() + "     "));
                    jpanPeptideHit.add(Box.createHorizontalStrut(50));
                    jpanPeptideHit.add(new JLabel("Score vs " + lFilterSettingThresholdString + " Threshold: " + lPeptideHit.getIonsScore() + " \\ " + lThreshold.doubleValue() + "    "));
                    jpanPeptideHit.add(Box.createHorizontalStrut(10));
                    DatfileTreePanel.this.jpanSpectrum.add((Component)DatfileTreePanel.this.iSpectrumPanel, "Center");
                    DatfileTreePanel.this.jpanSpectrum.add((Component)jpanPeptideHit, "South");
                    DatfileTreePanel.this.jpanSpectrum.validate();
                    DatfileTreePanel.this.jpanSpectrum.repaint();
                }
            }
        });
        this.treeDatfile.setExpandsSelectedPaths(true);
        this.treeDatfile.validate();
        this.jpanTree = new JPanel(new BorderLayout());
        this.jpanTree.add((Component)new JScrollPane(this.treeDatfile), "Center");
        this.jpanTree.validate();
    }

    public void select_jpanTree_node(String aInput) {
        boolean lIsQuerynumber = true;
        try {
            Integer.parseInt(aInput);
        }
        catch (NumberFormatException e) {
            lIsQuerynumber = false;
        }
        if (lIsQuerynumber) {
            int lQueryNumber = Integer.parseInt(aInput);
            TreePath tpQuery = this.treeDatfile.getNextMatch("Query " + lQueryNumber, 1, Position.Bias.Forward);
            TreePath tpPeptideHit = null;
            if (tpQuery == null) {
                JOptionPane.showMessageDialog(this, "Query " + lQueryNumber + " was not found in the tree.");
            } else {
                Object lPeptideHit = this.treeDatfile.getModel().getChild(tpQuery.getLastPathComponent(), 0);
                tpPeptideHit = tpQuery.pathByAddingChild(lPeptideHit);
                this.treeDatfile.expandPath(tpQuery);
                this.treeDatfile.setSelectionPath(tpPeptideHit);
                this.treeDatfile.getTreeSelectionListeners()[0].valueChanged(new TreeSelectionEvent((Object)this.treeDatfile, new TreePath[]{tpQuery, tpPeptideHit}, new boolean[]{true, false}, tpQuery, tpPeptideHit));
            }
        } else {
            String lSpectrumFilename = aInput;
            if (this.iMascotDatfile.getSpectrumFilenameToQuerynumberMap().get(lSpectrumFilename) == null) {
                JOptionPane.showMessageDialog(this, "Spectrumfilename " + lSpectrumFilename + " has no corresponding Querynumber in the datfile.");
            } else {
                Object o = this.iMascotDatfile.getSpectrumFilenameToQuerynumberMap().get(lSpectrumFilename);
                if (o instanceof Integer) {
                    int lQueryNumber = (Integer)o;
                    TreePath tpQuery = this.treeDatfile.getNextMatch("Query " + lQueryNumber, 1, Position.Bias.Forward);
                    TreePath tpPeptideHit = null;
                    if (tpQuery == null) {
                        JOptionPane.showMessageDialog(this, "Spectrum" + lSpectrumFilename + " was not found in the tree.");
                    } else {
                        Object lPeptideHit = this.treeDatfile.getModel().getChild(tpQuery.getLastPathComponent(), 0);
                        tpPeptideHit = tpQuery.pathByAddingChild(lPeptideHit);
                        this.treeDatfile.expandPath(tpQuery);
                        this.treeDatfile.setSelectionPath(tpPeptideHit);
                        this.treeDatfile.getTreeSelectionListeners()[0].valueChanged(new TreeSelectionEvent((Object)this.treeDatfile, new TreePath[]{tpQuery, tpPeptideHit}, new boolean[]{true, false}, tpQuery, tpPeptideHit));
                    }
                }
            }
        }
    }

    public void setFilterSettingsOnTreeModel(double aConfidence) {
        int lConfidencePercentage = new Double((1.0 - aConfidence) * 100.0).intValue();
        DatfileTreeModel lTempDatfileTreeModel = new DatfileTreeModel(this.iMascotDatfile, "MascotDatfile @" + lConfidencePercentage + "%");
        lTempDatfileTreeModel.setFilterSettingThreshold(aConfidence);
        this.iDatfileTreeModel = lTempDatfileTreeModel;
        this.construct();
    }

    public void setDefaultFilterSettingsOnTreeModel() {
        this.iDatfileTreeModel = new DatfileTreeModel(this.iMascotDatfile, "MascotDatfile");
    }

    public void rescale(double aMinMass, double aMaxMass) {
        this.iSpectrumPanel.rescale(aMinMass, aMaxMass);
        this.jpanSpectrum.repaint();
    }

    public JPanel getSpectrumPanel() {
        return this.jpanSpectrum;
    }
}

