## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    library(ORFik)                        # This package
#    annotation <- getGenomeAndAnnotation(
#                        organism = "saccharomyces_cerevisiae",
#                        output.dir = "~/Bio_data/annotations/Yeast_SacCer3/",
#                        assembly_type = "toplevel"
#                        )

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  index <- STAR.index(annotation, wait = FALSE)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  input.dir.rna <- "~/Bio_data/raw_data/RNA-seq/Yeast_SRR453566/"
#  output.dir.rna <- "~/Bio_data/processed_data/RNAseq/Yeast_SRR453566/aligned_sacCer3/"
#  alignment <-
#    STAR.align.folder(input.dir.rna, output.dir.rna, index,
#                      paired.end = "yes",
#                      steps = "tr-ge", # (trim needed: adapters found, then genome)
#                      adapter.sequence = "auto",
#                      max.cpus = 30, trim.front = 3, min.length = 20)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  STAR.multiQC(alignment)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  txdb_file <- paste0(annotation["gtf"], ".db") # Get txdb file, not raw gtf
#  fa <- annotation["genome"]
#  create.experiment(exper = "yeast_exp_RNA",
#                    dir = paste0(output.dir.rna, "/aligned/"),
#                    txdb = txdb_file, fa = fa,
#                    organism = "Saccharomyces cerevisiae",
#                    viewTemplate = FALSE,
#                    pairedEndBam = c(T) # True/False per bam file
#                    )

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  df <- read.experiment("yeast_exp_RNA")
#    )

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    remove.experiments(df)
#    convertLibs(df, type = "ofst")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    remove.experiments(df)
#    convertLibs(df, type = "wig")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  remove.experiments(df)
#  outputLibs(df, type = "ofst")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    remove.experiments(df)
#    outputLibs(df, type = "wig")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    QCreport(df)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    mrna <- countTable(df, region = "mrna", type = "fpkm")
#    cds <- countTable(df, region = "cds", type = "fpkm")
#    ratio <- cds / mrna

