## ----setup,echo=FALSE,results="hide"------------------------------------------
suppressPackageStartupMessages({
suppressMessages({
library(BiocStyle)
library(HumanTranscriptomeCompendium)
library(beeswarm)
library(SummarizedExperiment)
library(DT)
})
})

## ----lklo---------------------------------------------------------------------
library(HumanTranscriptomeCompendium)
genelev = htx_load()
genelev
assay(genelev)

## ----lksi---------------------------------------------------------------------
sing = grep("single.cell", genelev$study_title, 
   ignore.case=TRUE)
length(sing)

## ----chkspec------------------------------------------------------------------
sa = genelev$study_accession[sing]
sing2 = sing[-which(duplicated(sa))]
length(sing2)
datatable(as.data.frame(colData(genelev[,sing2])),
   options=list(lengthMenu=c(3,5,10,50,100)))

## ----lkchar-------------------------------------------------------------------
bulk = genelev[,-sing]
kpglio = grep("glioblastoma", bulk$study_title, 
  ignore.case=TRUE)
glioGene = bulk[,kpglio]
glioGene

## ----lkmat--------------------------------------------------------------------
beeswarm(as.matrix(assay(
   glioGene["ENSG00000138413.13",1:100])), pwcol=as.numeric(factor(glioGene$study_title[1:100])), ylab="IDH1 expression")
legend(.6, 15000, legend=unique(glioGene$study_accession[1:100]),
   col=1:2, pch=c(1,1))

## ----dotx, eval=FALSE---------------------------------------------------------
#  txlev = htx_load(genesOnly=FALSE)
#  txlev

