/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.crypto.blockcipher;

import edu.rit.crypto.blockcipher.BlockCipher;

public class AES256CipherSmp
extends BlockCipher {
    private static final int ROUND_KEY_COUNT = 15;
    private static final short[] byteSub = new short[]{99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125, 250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204, 52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226, 235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132, 83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251, 67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245, 188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61, 100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219, 224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109, 141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198, 232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185, 134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223, 140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22};
    private static final short[] xtime = new short[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126, 128, 130, 132, 134, 136, 138, 140, 142, 144, 146, 148, 150, 152, 154, 156, 158, 160, 162, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 186, 188, 190, 192, 194, 196, 198, 200, 202, 204, 206, 208, 210, 212, 214, 216, 218, 220, 222, 224, 226, 228, 230, 232, 234, 236, 238, 240, 242, 244, 246, 248, 250, 252, 254, 27, 25, 31, 29, 19, 17, 23, 21, 11, 9, 15, 13, 3, 1, 7, 5, 59, 57, 63, 61, 51, 49, 55, 53, 43, 41, 47, 45, 35, 33, 39, 37, 91, 89, 95, 93, 83, 81, 87, 85, 75, 73, 79, 77, 67, 65, 71, 69, 123, 121, 127, 125, 115, 113, 119, 117, 107, 105, 111, 109, 99, 97, 103, 101, 155, 153, 159, 157, 147, 145, 151, 149, 139, 137, 143, 141, 131, 129, 135, 133, 187, 185, 191, 189, 179, 177, 183, 181, 171, 169, 175, 173, 163, 161, 167, 165, 219, 217, 223, 221, 211, 209, 215, 213, 203, 201, 207, 205, 195, 193, 199, 197, 251, 249, 255, 253, 243, 241, 247, 245, 235, 233, 239, 237, 227, 225, 231, 229};
    private int state00;
    private int state01;
    private int state02;
    private int state03;
    private int state10;
    private int state11;
    private int state12;
    private int state13;
    private int state20;
    private int state21;
    private int state22;
    private int state23;
    private int state30;
    private int state31;
    private int state32;
    private int state33;
    private RoundKey[] expandedKey;
    private long p0;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private long p9;
    private long pa;
    private long pb;
    private long pc;
    private long pd;
    private long pe;
    private long pf;

    public AES256CipherSmp(byte[] byArray) {
        super(16, 32);
        this.setKey(byArray);
    }

    public void setKey(byte[] byArray) {
        if (byArray.length < 32) {
            throw new IllegalArgumentException("Key is not 32 bytes");
        }
        if (this.expandedKey == null) {
            this.expandedKey = new RoundKey[47];
            for (int i = 0; i < 15; ++i) {
                this.expandedKey[i] = new RoundKey();
            }
        }
        RoundKey roundKey = this.expandedKey[0];
        roundKey.key00 = byArray[0] & 0xFF;
        roundKey.key10 = byArray[1] & 0xFF;
        roundKey.key20 = byArray[2] & 0xFF;
        roundKey.key30 = byArray[3] & 0xFF;
        roundKey.key01 = byArray[4] & 0xFF;
        roundKey.key11 = byArray[5] & 0xFF;
        roundKey.key21 = byArray[6] & 0xFF;
        roundKey.key31 = byArray[7] & 0xFF;
        roundKey.key02 = byArray[8] & 0xFF;
        roundKey.key12 = byArray[9] & 0xFF;
        roundKey.key22 = byArray[10] & 0xFF;
        roundKey.key32 = byArray[11] & 0xFF;
        roundKey.key03 = byArray[12] & 0xFF;
        roundKey.key13 = byArray[13] & 0xFF;
        roundKey.key23 = byArray[14] & 0xFF;
        roundKey.key33 = byArray[15] & 0xFF;
        roundKey = this.expandedKey[1];
        roundKey.key00 = byArray[16] & 0xFF;
        roundKey.key10 = byArray[17] & 0xFF;
        roundKey.key20 = byArray[18] & 0xFF;
        roundKey.key30 = byArray[19] & 0xFF;
        roundKey.key01 = byArray[20] & 0xFF;
        roundKey.key11 = byArray[21] & 0xFF;
        roundKey.key21 = byArray[22] & 0xFF;
        roundKey.key31 = byArray[23] & 0xFF;
        roundKey.key02 = byArray[24] & 0xFF;
        roundKey.key12 = byArray[25] & 0xFF;
        roundKey.key22 = byArray[26] & 0xFF;
        roundKey.key32 = byArray[27] & 0xFF;
        roundKey.key03 = byArray[28] & 0xFF;
        roundKey.key13 = byArray[29] & 0xFF;
        roundKey.key23 = byArray[30] & 0xFF;
        roundKey.key33 = byArray[31] & 0xFF;
        int n = 1;
        for (int i = 2; i < 14; i += 2) {
            AES256CipherSmp.advanceRoundKey(this.expandedKey[i - 2], this.expandedKey[i - 1], this.expandedKey[i], n);
            n = xtime[n];
            AES256CipherSmp.advanceRoundKey(this.expandedKey[i - 1], this.expandedKey[i], this.expandedKey[i + 1]);
        }
        AES256CipherSmp.advanceRoundKey(this.expandedKey[12], this.expandedKey[13], this.expandedKey[14], n);
    }

    public void encrypt(byte[] byArray, byte[] byArray2) {
        if (byArray.length < 16) {
            throw new IllegalArgumentException("thePlaintext is not 16 bytes");
        }
        if (byArray2.length < 16) {
            throw new IllegalArgumentException("theCiphertext is not 16 bytes");
        }
        if (this.expandedKey == null) {
            throw new IllegalArgumentException("Key is not set");
        }
        this.state00 = byArray[0] & 0xFF;
        this.state10 = byArray[1] & 0xFF;
        this.state20 = byArray[2] & 0xFF;
        this.state30 = byArray[3] & 0xFF;
        this.state01 = byArray[4] & 0xFF;
        this.state11 = byArray[5] & 0xFF;
        this.state21 = byArray[6] & 0xFF;
        this.state31 = byArray[7] & 0xFF;
        this.state02 = byArray[8] & 0xFF;
        this.state12 = byArray[9] & 0xFF;
        this.state22 = byArray[10] & 0xFF;
        this.state32 = byArray[11] & 0xFF;
        this.state03 = byArray[12] & 0xFF;
        this.state13 = byArray[13] & 0xFF;
        this.state23 = byArray[14] & 0xFF;
        this.state33 = byArray[15] & 0xFF;
        for (int i = 0; i < 13; ++i) {
            this.addRoundKeyByteSubShiftRow(this.expandedKey[i]);
            this.mixColumn();
        }
        this.addRoundKeyByteSubShiftRow(this.expandedKey[13]);
        this.addRoundKey(this.expandedKey[14]);
        byArray2[0] = (byte)this.state00;
        byArray2[1] = (byte)this.state10;
        byArray2[2] = (byte)this.state20;
        byArray2[3] = (byte)this.state30;
        byArray2[4] = (byte)this.state01;
        byArray2[5] = (byte)this.state11;
        byArray2[6] = (byte)this.state21;
        byArray2[7] = (byte)this.state31;
        byArray2[8] = (byte)this.state02;
        byArray2[9] = (byte)this.state12;
        byArray2[10] = (byte)this.state22;
        byArray2[11] = (byte)this.state32;
        byArray2[12] = (byte)this.state03;
        byArray2[13] = (byte)this.state13;
        byArray2[14] = (byte)this.state23;
        byArray2[15] = (byte)this.state33;
    }

    public void erase() {
        this.state00 = 0;
        this.state01 = 0;
        this.state02 = 0;
        this.state03 = 0;
        this.state10 = 0;
        this.state11 = 0;
        this.state12 = 0;
        this.state13 = 0;
        this.state20 = 0;
        this.state21 = 0;
        this.state22 = 0;
        this.state23 = 0;
        this.state30 = 0;
        this.state31 = 0;
        this.state32 = 0;
        this.state33 = 0;
        if (this.expandedKey != null) {
            for (int i = 0; i < 15; ++i) {
                this.expandedKey[i].erase();
                this.expandedKey[i] = null;
            }
            this.expandedKey = null;
        }
    }

    protected void finalize() {
        this.erase();
    }

    private static void advanceRoundKey(RoundKey roundKey, RoundKey roundKey2, RoundKey roundKey3, int n) {
        roundKey3.key00 = roundKey.key00 ^ byteSub[roundKey2.key13] ^ n;
        roundKey3.key10 = roundKey.key10 ^ byteSub[roundKey2.key23];
        roundKey3.key20 = roundKey.key20 ^ byteSub[roundKey2.key33];
        roundKey3.key30 = roundKey.key30 ^ byteSub[roundKey2.key03];
        roundKey3.key01 = roundKey.key01 ^ roundKey3.key00;
        roundKey3.key11 = roundKey.key11 ^ roundKey3.key10;
        roundKey3.key21 = roundKey.key21 ^ roundKey3.key20;
        roundKey3.key31 = roundKey.key31 ^ roundKey3.key30;
        roundKey3.key02 = roundKey.key02 ^ roundKey3.key01;
        roundKey3.key12 = roundKey.key12 ^ roundKey3.key11;
        roundKey3.key22 = roundKey.key22 ^ roundKey3.key21;
        roundKey3.key32 = roundKey.key32 ^ roundKey3.key31;
        roundKey3.key03 = roundKey.key03 ^ roundKey3.key02;
        roundKey3.key13 = roundKey.key13 ^ roundKey3.key12;
        roundKey3.key23 = roundKey.key23 ^ roundKey3.key22;
        roundKey3.key33 = roundKey.key33 ^ roundKey3.key32;
    }

    private static void advanceRoundKey(RoundKey roundKey, RoundKey roundKey2, RoundKey roundKey3) {
        roundKey3.key00 = roundKey.key00 ^ byteSub[roundKey2.key03];
        roundKey3.key10 = roundKey.key10 ^ byteSub[roundKey2.key13];
        roundKey3.key20 = roundKey.key20 ^ byteSub[roundKey2.key23];
        roundKey3.key30 = roundKey.key30 ^ byteSub[roundKey2.key33];
        roundKey3.key01 = roundKey.key01 ^ roundKey3.key00;
        roundKey3.key11 = roundKey.key11 ^ roundKey3.key10;
        roundKey3.key21 = roundKey.key21 ^ roundKey3.key20;
        roundKey3.key31 = roundKey.key31 ^ roundKey3.key30;
        roundKey3.key02 = roundKey.key02 ^ roundKey3.key01;
        roundKey3.key12 = roundKey.key12 ^ roundKey3.key11;
        roundKey3.key22 = roundKey.key22 ^ roundKey3.key21;
        roundKey3.key32 = roundKey.key32 ^ roundKey3.key31;
        roundKey3.key03 = roundKey.key03 ^ roundKey3.key02;
        roundKey3.key13 = roundKey.key13 ^ roundKey3.key12;
        roundKey3.key23 = roundKey.key23 ^ roundKey3.key22;
        roundKey3.key33 = roundKey.key33 ^ roundKey3.key32;
    }

    private void addRoundKey(RoundKey roundKey) {
        this.state00 ^= roundKey.key00;
        this.state01 ^= roundKey.key01;
        this.state02 ^= roundKey.key02;
        this.state03 ^= roundKey.key03;
        this.state10 ^= roundKey.key10;
        this.state11 ^= roundKey.key11;
        this.state12 ^= roundKey.key12;
        this.state13 ^= roundKey.key13;
        this.state20 ^= roundKey.key20;
        this.state21 ^= roundKey.key21;
        this.state22 ^= roundKey.key22;
        this.state23 ^= roundKey.key23;
        this.state30 ^= roundKey.key30;
        this.state31 ^= roundKey.key31;
        this.state32 ^= roundKey.key32;
        this.state33 ^= roundKey.key33;
    }

    private void addRoundKeyByteSubShiftRow(RoundKey roundKey) {
        this.state00 = byteSub[this.state00 ^ roundKey.key00];
        this.state01 = byteSub[this.state01 ^ roundKey.key01];
        this.state02 = byteSub[this.state02 ^ roundKey.key02];
        this.state03 = byteSub[this.state03 ^ roundKey.key03];
        int n = this.state10;
        this.state10 = byteSub[this.state11 ^ roundKey.key11];
        this.state11 = byteSub[this.state12 ^ roundKey.key12];
        this.state12 = byteSub[this.state13 ^ roundKey.key13];
        this.state13 = byteSub[n ^ roundKey.key10];
        n = this.state20;
        this.state20 = byteSub[this.state22 ^ roundKey.key22];
        this.state22 = byteSub[n ^ roundKey.key20];
        n = this.state21;
        this.state21 = byteSub[this.state23 ^ roundKey.key23];
        this.state23 = byteSub[n ^ roundKey.key21];
        n = this.state33;
        this.state33 = byteSub[this.state32 ^ roundKey.key32];
        this.state32 = byteSub[this.state31 ^ roundKey.key31];
        this.state31 = byteSub[this.state30 ^ roundKey.key30];
        this.state30 = byteSub[n ^ roundKey.key33];
    }

    private void mixColumn() {
        int n = this.state00;
        int n2 = this.state00 ^ this.state10 ^ this.state20 ^ this.state30;
        this.state00 ^= xtime[this.state00 ^ this.state10] ^ n2;
        this.state10 ^= xtime[this.state10 ^ this.state20] ^ n2;
        this.state20 ^= xtime[this.state20 ^ this.state30] ^ n2;
        this.state30 ^= xtime[this.state30 ^ n] ^ n2;
        n = this.state01;
        n2 = this.state01 ^ this.state11 ^ this.state21 ^ this.state31;
        this.state01 ^= xtime[this.state01 ^ this.state11] ^ n2;
        this.state11 ^= xtime[this.state11 ^ this.state21] ^ n2;
        this.state21 ^= xtime[this.state21 ^ this.state31] ^ n2;
        this.state31 ^= xtime[this.state31 ^ n] ^ n2;
        n = this.state02;
        n2 = this.state02 ^ this.state12 ^ this.state22 ^ this.state32;
        this.state02 ^= xtime[this.state02 ^ this.state12] ^ n2;
        this.state12 ^= xtime[this.state12 ^ this.state22] ^ n2;
        this.state22 ^= xtime[this.state22 ^ this.state32] ^ n2;
        this.state32 ^= xtime[this.state32 ^ n] ^ n2;
        n = this.state03;
        n2 = this.state03 ^ this.state13 ^ this.state23 ^ this.state33;
        this.state03 ^= xtime[this.state03 ^ this.state13] ^ n2;
        this.state13 ^= xtime[this.state13 ^ this.state23] ^ n2;
        this.state23 ^= xtime[this.state23 ^ this.state33] ^ n2;
        this.state33 ^= xtime[this.state33 ^ n] ^ n2;
    }

    private static class RoundKey {
        public int key00;
        public int key01;
        public int key02;
        public int key03;
        public int key10;
        public int key11;
        public int key12;
        public int key13;
        public int key20;
        public int key21;
        public int key22;
        public int key23;
        public int key30;
        public int key31;
        public int key32;
        public int key33;
        private long p0;
        private long p1;
        private long p2;
        private long p3;
        private long p4;
        private long p5;
        private long p6;
        private long p7;
        private long p8;
        private long p9;
        private long pa;
        private long pb;
        private long pc;
        private long pd;
        private long pe;
        private long pf;

        private RoundKey() {
        }

        public void erase() {
            this.key00 = 0;
            this.key01 = 0;
            this.key02 = 0;
            this.key03 = 0;
            this.key10 = 0;
            this.key11 = 0;
            this.key12 = 0;
            this.key13 = 0;
            this.key20 = 0;
            this.key21 = 0;
            this.key22 = 0;
            this.key23 = 0;
            this.key30 = 0;
            this.key31 = 0;
            this.key32 = 0;
            this.key33 = 0;
        }
    }
}

