### R code from vignette source 'stepwiseCM.Rnw'

###################################################
### code chunk number 1: chunk1
###################################################
# load the full Central Nervous System cancer data 
library(stepwiseCM)
data(CNS)


###################################################
### code chunk number 2: chunk2
###################################################
# gain the prediction labels of the training set
data(CNS)
attach(CNS)
#Note that columns of the train set should corresponding the sample and rows
#corresponding the feature.
id <- sample(1:ncol(mrna), 30, replace=FALSE) 
train.exp <- mrna[, id]
train.cli <- t(cli[id, ])
test.exp <- mrna[, -id]
test.cli <- t(cli[-id, ])
train.label <- class[id]
test.label <- class[-id]
pred.cli <- Classifier(train=train.cli, test=test.cli, train.label=train.label, 
                       type="RF", CVtype="k-fold", outerkfold=2, innerkfold=2)
pred.exp <- Classifier(train=train.exp, test=test.exp, train.label=train.label, 
                       type="plsrf_x", CVtype="k-fold", outerkfold=2, innerkfold=2)
# Classification accuracy of the training set from clinical data is:
sum(pred.cli$P.train == train.label)/length(train.label)
# Classification Accuracy of the training set from expression data is:
sum(pred.exp$P.train == train.label)/length(train.label)


###################################################
### code chunk number 3: chunk3
###################################################
prox.cli <- Proximity(train=train.cli, train.label=train.label, test=test.cli, N=5)
prox.exp <- Proximity(train=train.exp, train.label=train.label, N=5)
#check the range of proximity values from two different data types                                     
par(mfrow=c(1,2))
plot(sort(prox.cli$prox.train[1, ][-1], decreasing=TRUE), main="clinical", xlab="Rank", 
     ylab="Proximity", ylim=c(0,1))
plot(sort(prox.exp$prox.train[1, ][-1], decreasing=TRUE), main="expression", xlab="Rank",
     ylab="Proximity", ylim=c(0,1)) 


###################################################
### code chunk number 4: chunk4
###################################################
RS <- RS.generator(pred.cli$P.train, pred.exp$P.train, 
       train.label, prox.cli$prox.test, prox.exp$prox.train, 
       "both")
#observe the differences by ranking the RS values
order(RS[, 1]) # from the ranking approach
order(RS[, 2]) # from the proximity approach           


###################################################
### code chunk number 5: chunk5
###################################################
result <- Curve.generator(RS[, 1], pred.cli$P.test, pred.exp$P.test, test.label)


###################################################
### code chunk number 6: chunk6
###################################################
A <- Step.pred(RS[, 1], 30)


